/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.BufferAI;
import com.Harbinger.Spore.Sentities.AI.LocHiv.LocalTargettingGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.SearchAreaGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Ssounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Hyper
extends Infected {
    public static final EntityDataAccessor<BlockPos> NEST = SynchedEntityData.defineId(Hyper.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

    public Hyper(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.navigation = new WallClimberNavigation((Mob)this, level);
    }

    @Override
    public boolean canStarve() {
        return false;
    }

    protected int calculateFallDamage(float p_149389_, float p_149390_) {
        return super.calculateFallDamage(p_149389_, p_149390_) - 5;
    }

    @Override
    protected void addRegularGoals() {
        this.goalSelector.addGoal(3, (Goal)new LocalTargettingGoal(this));
        this.goalSelector.addGoal(4, (Goal)new GoBackToTheNest(this));
        this.goalSelector.addGoal(4, (Goal)new SearchAreaGoal(this, 1.2));
        this.goalSelector.addGoal(5, (Goal)new BufferAI(this));
        this.goalSelector.addGoal(6, (Goal)new FloatDiveGoal((Mob)this));
    }

    @Override
    public boolean removeWhenFarAway(double value) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SporeSavedData data = SporeSavedData.getDataLocation(serverLevel);
            return data != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get() && value > 256.0;
        }
        return false;
    }

    @Override
    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        float value = blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos);
        return this.tickCount % 20 == 0 && (value > 0.0f && value <= (float)this.getBreaking() || Utilities.biomass().contains(blockstate));
    }

    protected boolean canRide(Entity entity) {
        if (entity instanceof Infected || entity instanceof UtilityEntity) {
            return super.canRide(entity);
        }
        return false;
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.HYPER_DAMAGE.get();
    }

    @Override
    public boolean hasLineOfSight(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && this.distanceToSqr((Entity)(livingEntity = (LivingEntity)entity)) < 100.0) {
            return true;
        }
        return super.hasLineOfSight(entity);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.level().getDifficulty() == Difficulty.HARD && (double)amount > this.getDamageCap() && ((Boolean)SConfig.SERVER.damagecap.get()).booleanValue()) {
            return super.hurt(source, (float)this.getDamageCap());
        }
        return super.hurt(source, amount);
    }

    public double getDamageCap() {
        return this.getMaxHealth() / 3.0f;
    }

    public int getBreaking() {
        return (Integer)SConfig.SERVER.hyper_bd.get();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("nestX", ((BlockPos)this.entityData.get(NEST)).getX());
        tag.putInt("nestY", ((BlockPos)this.entityData.get(NEST)).getY());
        tag.putInt("nestZ", ((BlockPos)this.entityData.get(NEST)).getZ());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        int x = tag.getInt("nestX");
        int y = tag.getInt("nestY");
        int z = tag.getInt("nestZ");
        this.entityData.set(NEST, (Object)new BlockPos(x, y, z));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(NEST, (Object)BlockPos.ZERO);
    }

    public BlockPos getNestLocation() {
        return (BlockPos)this.entityData.get(NEST);
    }

    public void setNestLocation(BlockPos pos) {
        this.entityData.set(NEST, (Object)pos);
    }

    @Override
    public boolean additionalBreakingTriggers() {
        return this.getLastDamageSource() == this.damageSources().inWall();
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setNestLocation(this.getOnPos());
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    static class GoBackToTheNest
    extends Goal {
        protected Hyper hyper;
        public int tryTicks;

        public GoBackToTheNest(Hyper hyper) {
            this.hyper = hyper;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canContinueToUse() {
            return this.hyper.getTarget() == null;
        }

        public boolean canUse() {
            return this.hyper.getEvoPoints() > 1 && this.hyper.getNestLocation() != BlockPos.ZERO;
        }

        protected void moveMobToBlock(BlockPos pos) {
            double x = (double)this.hyper.random.nextInt(-2, 2) + 0.5;
            double z = (double)this.hyper.random.nextInt(-2, 2) + 0.5;
            this.hyper.getNavigation().moveTo((double)pos.getX() + x, (double)(pos.getY() + 1), (double)pos.getZ() + z, 1.0);
        }

        protected void tryToLayCorpsesAround() {
            AABB aabb = this.hyper.getBoundingBox().inflate(10.0);
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
                Level level = this.hyper.level();
                boolean isGround = level.getBlockState(blockpos).isCollisionShapeFullBlock((BlockGetter)level, blockpos);
                boolean isAir = level.getBlockState(blockpos.above()).isAir();
                if (!(Math.random() < 0.01) || !isGround || !isAir || level.isClientSide) continue;
                level.setBlock(blockpos.above(), ((Block)Sblocks.REMAINS.get()).defaultBlockState(), 3);
                this.hyper.setEvoPoints(this.hyper.getEvoPoints() - 1);
                break;
            }
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 80 == 0;
        }

        public void tick() {
            super.tick();
            ++this.tryTicks;
            if (this.hyper.getNestLocation() != BlockPos.ZERO && this.shouldRecalculatePath()) {
                this.moveMobToBlock(this.hyper.getNestLocation());
            }
        }

        public void start() {
            this.moveMobToBlock(this.hyper.getNestLocation());
            BlockPos pos = this.hyper.getNestLocation();
            if (this.hyper.distanceToSqr(pos.getX(), pos.getY(), pos.getZ()) < 80.0) {
                this.tryToLayCorpsesAround();
            }
            super.start();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }
}

