/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.AI.HurtTargetGoal;
import com.Harbinger.Spore.Sentities.AI.InfectedConsumeFromRemains;
import com.Harbinger.Spore.Sentities.AI.InfectedPanicGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.BufferAI;
import com.Harbinger.Spore.Sentities.AI.LocHiv.FollowOthersGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.LocalTargettingGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.SearchAreaGoal;
import com.Harbinger.Spore.Sentities.ArmedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Experiment;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.SdamageTypes;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sparticles;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Infected
extends UtilityEntity
implements Enemy {
    public static final EntityDataAccessor<Integer> HUNGER = SynchedEntityData.defineId(Infected.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> KILLS = SynchedEntityData.defineId(Infected.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> EVOLUTION_POINTS = SynchedEntityData.defineId(Infected.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> EVOLUTION = SynchedEntityData.defineId(Infected.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> LINKED = SynchedEntityData.defineId(Infected.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> PERSISTENT = SynchedEntityData.defineId(Infected.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ORIGIN = SynchedEntityData.defineId(Infected.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    @javax.annotation.Nullable
    private BlockPos searchPos;
    @javax.annotation.Nullable
    private LivingEntity partner;
    public Predicate<LivingEntity> TARGET_SELECTOR = entity -> Utilities.TARGET_SELECTOR.Test((LivingEntity)entity);

    public Infected(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.xpReward = 5;
    }

    @javax.annotation.Nullable
    public BlockPos getSearchPos() {
        return this.searchPos;
    }

    public void setSearchPos(@javax.annotation.Nullable BlockPos searchPos) {
        this.searchPos = searchPos;
    }

    public void travel(Vec3 p_32858_) {
        if (this.isEffectiveAi() && this.isInFluidType()) {
            this.moveRelative(0.1f, p_32858_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.6));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(p_32858_);
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600, 0), (Entity)this);
        }
        return super.doHurtTarget(entity);
    }

    public void setFollowPartner(@javax.annotation.Nullable LivingEntity followPartner) {
        this.partner = followPartner;
    }

    public LivingEntity getFollowPartner() {
        return this.partner;
    }

    public int getMaxAirSupply() {
        return 1200;
    }

    protected int increaseAirSupply(int p_28389_) {
        return this.getMaxAirSupply();
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.5) {
            return SdamageTypes.infected_damage1(entity);
        }
        if (Math.random() < 0.5) {
            return SdamageTypes.infected_damage2(entity);
        }
        if (Math.random() < 0.5) {
            return SdamageTypes.infected_damage3(entity);
        }
        return this.damageSources().mobAttack((LivingEntity)this);
    }

    @Override
    protected void addTargettingGoals() {
        this.goalSelector.addGoal(2, (Goal)new HurtTargetGoal((PathfinderMob)this, livingEntity -> this.TARGET_SELECTOR.test((LivingEntity)livingEntity), Infected.class).setAlertOthers(Infected.class));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, livingEntity -> livingEntity instanceof Player || ((List)SConfig.SERVER.whitelist.get()).contains(livingEntity.getEncodeId())));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, livingEntity -> (Boolean)SConfig.SERVER.at_mob.get() != false && this.TARGET_SELECTOR.test((LivingEntity)livingEntity)));
    }

    protected void addRegularGoals() {
        this.goalSelector.addGoal(3, (Goal)new LocalTargettingGoal(this));
        this.goalSelector.addGoal(4, (Goal)new BufferAI(this));
        this.goalSelector.addGoal(3, (Goal)new OpenDoorGoal((Mob)this, true){

            public boolean canUse() {
                return super.canUse() && Infected.this.getLinked() && (Boolean)SConfig.SERVER.higher_thinking.get() != false;
            }

            public void start() {
                this.mob.swing(InteractionHand.MAIN_HAND);
                super.start();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new SearchAreaGoal(this, 1.2));
        this.goalSelector.addGoal(5, (Goal)new InfectedPanicGoal(this, 1.5));
        this.goalSelector.addGoal(6, (Goal)new FloatDiveGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new InfectedConsumeFromRemains(this));
        this.goalSelector.addGoal(10, (Goal)new FollowOthersGoal(this, Infected.class, (com.google.common.base.Predicate<LivingEntity>)((com.google.common.base.Predicate)entity -> true)));
        this.goalSelector.addGoal(10, (Goal)new FollowOthersGoal(this, Calamity.class, (com.google.common.base.Predicate<LivingEntity>)((com.google.common.base.Predicate)entity -> this instanceof EvolvingInfected)));
    }

    protected void registerGoals() {
        this.addTargettingGoals();
        this.addRegularGoals();
    }

    public boolean canStarve() {
        return (Boolean)SConfig.SERVER.should_starve.get() != false && (Integer)this.entityData.get(EVOLUTION_POINTS) <= 0;
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.tickCount % 20 == 0) {
            this.applyColdWeaknessEffects();
            this.handleStarvationProgress();
            if ((this.horizontalCollision || this.additionalBreakingTriggers()) && this.canGrief()) {
                this.breakNearbyBlocks();
            }
        }
    }

    public boolean additionalBreakingTriggers() {
        return false;
    }

    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        return (blockstate.getBlock() instanceof StainedGlassBlock || blockstate.getBlock() instanceof LeavesBlock) && blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) >= 0.0f && blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) < 2.0f;
    }

    private void handleStarvationProgress() {
        int hungerIncrement;
        if (!this.canStarve()) {
            return;
        }
        int currentHunger = this.getHunger();
        int hungerThreshold = (Integer)SConfig.SERVER.hunger.get();
        boolean freezingPenalty = this.isInPowderSnow || this.isFreazing();
        int n = hungerIncrement = freezingPenalty ? 2 : 1;
        if (currentHunger < hungerThreshold) {
            this.setHunger(currentHunger + hungerIncrement);
        } else if (!this.hasEffect(Seffects.STARVATION)) {
            this.addEffect(new MobEffectInstance(Seffects.STARVATION, 100, 0));
        }
    }

    private void applyColdWeaknessEffects() {
        if (!((Boolean)SConfig.SERVER.weaktocold.get()).booleanValue()) {
            return;
        }
        if (!this.isInPowderSnow && !this.isFreazing()) {
            return;
        }
        this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 1, false, false), (Entity)this);
        this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0, false, false), (Entity)this);
    }

    private boolean canGrief() {
        return EventHooks.canEntityGrief((Level)this.level(), (Entity)this);
    }

    private void breakNearbyBlocks() {
        boolean brokeAny = false;
        AABB aabb = this.getBoundingBox().inflate(0.2).move(0.0, 0.5, 0.0);
        for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState state = this.level().getBlockState(pos);
            if (!this.blockBreakingParameter(state, pos)) continue;
            brokeAny |= this.interactBlock(pos, this.level());
        }
        if (!brokeAny && this.onGround()) {
            this.jumpFromGround();
        }
    }

    public boolean interactBlock(BlockPos blockPos, Level level) {
        BlockState state = level.getBlockState(blockPos);
        if (Utilities.biomass().contains(state)) {
            return level.setBlock(blockPos, ((Block)Sblocks.MEMBRANE_BLOCK.get()).defaultBlockState(), 3);
        }
        return level.destroyBlock(blockPos, false, (Entity)this);
    }

    public boolean isStarving() {
        return (Integer)this.entityData.get(HUNGER) >= (Integer)SConfig.SERVER.hunger.get() || this.hasEffect(Seffects.STARVATION);
    }

    public boolean removeWhenFarAway(double p_21542_) {
        if (this.getEvoPoints() >= (Integer)SConfig.SERVER.min_kills.get() && this instanceof EvolvingInfected) {
            return false;
        }
        return super.removeWhenFarAway(p_21542_);
    }

    public boolean isFreazing() {
        int i = Mth.floor((double)this.getX());
        int j = Mth.floor((double)this.getY());
        int k = Mth.floor((double)this.getZ());
        BlockPos blockpos = new BlockPos(i, j, k);
        Biome biome = (Biome)this.level().getBiome(blockpos).value();
        return (Boolean)SConfig.SERVER.weaktocold.get() != false && this.random.nextInt(20) == 0 && (double)biome.getBaseTemperature() <= 0.2;
    }

    public void awardKillScore(Entity entity, int i, DamageSource damageSource) {
        this.entityData.set(KILLS, (Object)((Integer)this.entityData.get(KILLS) + 1));
        this.entityData.set(EVOLUTION_POINTS, (Object)((Integer)this.entityData.get(EVOLUTION_POINTS) + 1));
        this.setHunger(0);
        super.awardKillScore(entity, i, damageSource);
    }

    public void setHunger(Integer count) {
        this.entityData.set(HUNGER, (Object)count);
    }

    public int getHunger() {
        return (Integer)this.entityData.get(HUNGER);
    }

    public void setKills(Integer count) {
        this.entityData.set(KILLS, (Object)count);
    }

    public int getKills() {
        return (Integer)this.entityData.get(KILLS);
    }

    public void setEvoPoints(Integer count) {
        this.entityData.set(EVOLUTION_POINTS, (Object)count);
    }

    public int getEvoPoints() {
        return (Integer)this.entityData.get(EVOLUTION_POINTS);
    }

    public void setLinked(Boolean count) {
        this.entityData.set(LINKED, (Object)count);
    }

    public boolean getLinked() {
        return (Boolean)this.entityData.get(LINKED);
    }

    public int getEvolutionCoolDown() {
        return (Integer)this.entityData.get(EVOLUTION);
    }

    public void setEvolution(int u) {
        this.entityData.set(EVOLUTION, (Object)u);
    }

    public void setPersistent(Boolean count) {
        this.entityData.set(PERSISTENT, (Object)count);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("hunger", ((Integer)this.entityData.get(HUNGER)).intValue());
        tag.putInt("kills", ((Integer)this.entityData.get(KILLS)).intValue());
        tag.putInt("evo_points", ((Integer)this.entityData.get(EVOLUTION_POINTS)).intValue());
        tag.putInt("evolution", ((Integer)this.entityData.get(EVOLUTION)).intValue());
        tag.putBoolean("linked", ((Boolean)this.entityData.get(LINKED)).booleanValue());
        tag.putBoolean("persistent", ((Boolean)this.entityData.get(PERSISTENT)).booleanValue());
        tag.putString("origin", (String)this.entityData.get(ORIGIN));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(HUNGER, (Object)tag.getInt("hunger"));
        this.entityData.set(KILLS, (Object)tag.getInt("kills"));
        this.entityData.set(EVOLUTION_POINTS, (Object)tag.getInt("evo_points"));
        this.entityData.set(EVOLUTION, (Object)tag.getInt("evolution"));
        this.entityData.set(LINKED, (Object)tag.getBoolean("linked"));
        this.entityData.set(PERSISTENT, (Object)tag.getBoolean("persistent"));
        if (tag.contains("origin")) {
            this.entityData.set(ORIGIN, (Object)tag.getString("origin"));
        } else {
            this.entityData.set(ORIGIN, (Object)this.origin());
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HUNGER, (Object)0);
        builder.define(KILLS, (Object)0);
        builder.define(EVOLUTION_POINTS, (Object)0);
        builder.define(EVOLUTION, (Object)0);
        builder.define(LINKED, (Object)false);
        builder.define(PERSISTENT, (Object)false);
        builder.define(ORIGIN, (Object)this.origin());
    }

    public String origin() {
        return "";
    }

    public void setOrigin(String string) {
        this.entityData.set(ORIGIN, (Object)string);
    }

    public String getOrigin() {
        return (String)this.entityData.get(ORIGIN);
    }

    public boolean hurt(DamageSource source, float amount) {
        Level level;
        if (this.hasEffect(Seffects.STARVATION) && source == this.damageSources().generic() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x0 = this.getX() - ((double)this.random.nextFloat() - 0.1) * 0.1;
            double y0 = this.getY() + ((double)this.random.nextFloat() - 0.25) * 0.25 * 5.0;
            double z0 = this.getZ() + ((double)this.random.nextFloat() - 0.1) * 0.1;
            serverLevel.sendParticles((ParticleOptions)Sparticles.SPORE_PARTICLE.get(), x0, y0, z0, 4, 0.0, 0.0, 0.0, 1.0);
        }
        if (source.getDirectEntity() != null) {
            this.setSearchPos(new BlockPos((int)source.getDirectEntity().getX(), (int)source.getDirectEntity().getY(), (int)source.getDirectEntity().getZ()));
        }
        return super.hurt(source, amount);
    }

    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if ((Integer)this.entityData.get(HUNGER) >= (Integer)SConfig.SERVER.hunger.get() && (effectInstance.getEffect() == MobEffects.HEAL || effectInstance.getEffect() == MobEffects.REGENERATION)) {
            this.setHunger(0);
        }
        return super.addEffect(effectInstance, entity);
    }

    public void die(DamageSource source) {
        this.placeRemains(source);
        this.placeFrozenRemains();
        if (((Boolean)this.entityData.get(PERSISTENT)).booleanValue()) {
            for (int i = 0; i < this.random.nextInt(1, 4); ++i) {
                super.die(source);
            }
        } else {
            super.die(source);
        }
    }

    private void placeRemains(DamageSource source) {
        if (this.hasEffect(Seffects.STARVATION) && source == this.damageSources().generic()) {
            AABB aabb = this.getBoundingBox().inflate(1.0);
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
                BlockState blockState = this.level().getBlockState(blockpos);
                BlockState above = this.level().getBlockState(blockpos.above());
                if (this.level().isClientSide() || !blockState.isSolidRender((BlockGetter)this.level(), blockpos) || !above.isAir()) continue;
                if (Math.random() < 0.9) {
                    this.level().setBlock(blockpos.above(), Math.random() < 0.5 ? ((Block)Sblocks.GROWTHS_BIG.get()).defaultBlockState() : ((Block)Sblocks.GROWTHS_SMALL.get()).defaultBlockState(), 3);
                }
                if (!(Math.random() < 0.3)) continue;
                this.level().setBlock(blockpos.above(), ((Block)Sblocks.REMAINS.get()).defaultBlockState(), 3);
                break;
            }
        }
    }

    private void placeFrozenRemains() {
        if ((this.isFreazing() || this.getTicksFrozen() > 0) && Math.random() < 0.3) {
            AABB aabb = this.getBoundingBox().inflate(1.0);
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
                BlockState blockState = this.level().getBlockState(blockpos);
                BlockState above = this.level().getBlockState(blockpos.above());
                if (this.level().isClientSide() || !blockState.isSolidRender((BlockGetter)this.level(), blockpos) || !above.isAir() || !(Math.random() < 0.3)) continue;
                this.level().setBlock(blockpos.above(), ((Block)Sblocks.FROZEN_REMAINS.get()).defaultBlockState(), 3);
                break;
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setDefaultLinkage(level);
        this.spawnWithPoints();
        if (!(this instanceof Experiment) && ((Boolean)SConfig.SERVER.daytime_spawn.get()).booleanValue() && spawnType == MobSpawnType.NATURAL) {
            this.teleportToSurface(this.level(), (Mob)this);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void setDefaultLinkage(ServerLevelAccessor level) {
        ServerLevel serverLevel;
        SporeSavedData data;
        if (level instanceof ServerLevel && (data = SporeSavedData.getDataLocation(serverLevel = (ServerLevel)level)) != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get()) {
            Infected infected;
            this.setLinked(true);
            if (Math.random() < 0.3 && (infected = this) instanceof EvolvingInfected) {
                EvolvingInfected evolvingInfected = (EvolvingInfected)((Object)infected);
                if (evolvingInfected instanceof EvolvedInfected) {
                    this.setEvoPoints(this.getEvoPoints() + (Integer)SConfig.SERVER.min_kills_hyper.get());
                } else {
                    this.setEvoPoints(this.getEvoPoints() + (Integer)SConfig.SERVER.min_kills.get());
                }
                this.setEvolution((Integer)SConfig.SERVER.evolution_age_human.get());
            }
            this.enchantEquipment((LivingEntity)this);
        }
    }

    public void spawnWithPoints() {
        if (!((Boolean)SConfig.SERVER.at_mob.get()).booleanValue() && Math.random() < 0.3 && this instanceof EvolvingInfected) {
            this.setEvoPoints((Integer)SConfig.SERVER.min_kills.get());
        }
    }

    public void teleportToSurface(Level level, Mob entity) {
        if (level.canSeeSky(entity.blockPosition())) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Mth.floor((double)entity.getX()), level.getMaxBuildHeight(), Mth.floor((double)entity.getZ()));
        while (pos.getY() > level.getMinBuildHeight()) {
            pos.move(Direction.DOWN);
            BlockState state = level.getBlockState((BlockPos)pos);
            BlockState stateAbove = level.getBlockState(pos.above());
            if (!state.isSolidRender((BlockGetter)level, (BlockPos)pos) || !stateAbove.isAir()) continue;
            entity.teleportTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.01, (double)pos.getZ() + 0.5);
            return;
        }
    }

    public void enchantEquipment(LivingEntity living) {
        if (living instanceof ArmedInfected) {
            ArmedInfected armedInfected = (ArmedInfected)living;
            armedInfected.enchantItems(living);
        }
    }

    public boolean hasLineOfSight(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(Seffects.MARKER)) {
            return true;
        }
        return super.hasLineOfSight(entity);
    }
}

