/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sentities.Projectile.AcidBall;
import com.Harbinger.Spore.Sentities.Projectile.Vomit;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Organoid
extends UtilityEntity
implements Enemy {
    public static final EntityDataAccessor<Integer> BORROW = SynchedEntityData.defineId(Organoid.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> EMERGE = SynchedEntityData.defineId(Organoid.class, (EntityDataSerializer)EntityDataSerializers.INT);

    protected Organoid(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.xpReward = 25;
    }

    public void tick() {
        super.tick();
        if (this.onGround()) {
            this.makeStuckInBlock(Blocks.AIR.defaultBlockState(), new Vec3(0.0, 1.0, 0.0));
        }
        if (!this.level().isClientSide) {
            if (this.isEmerging()) {
                this.tickEmerging();
            } else if (this.isBurrowing()) {
                this.tickBurrowing();
            }
        }
        if (this.tickCount % 200 == 0 && !(this instanceof Proto) && !(this instanceof Mound)) {
            this.regulateSpawns();
        }
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.ORGANOID_DAMAGE.get();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean dampensVibrations() {
        return true;
    }

    public boolean hurt(DamageSource source, float p_21017_) {
        if (source.getDirectEntity() instanceof AcidBall || source.getDirectEntity() instanceof Vomit) {
            return false;
        }
        return super.hurt(source, p_21017_);
    }

    public int getEmerge_tick() {
        return 20;
    }

    public int getBorrow_tick() {
        return 20;
    }

    public boolean isEmerging() {
        return (Integer)this.entityData.get(EMERGE) > 0;
    }

    public void tickEmerging() {
        int emerging = (Integer)this.entityData.get(EMERGE);
        if (emerging > this.getEmerge_tick()) {
            emerging = -1;
        }
        this.entityData.set(EMERGE, (Object)(emerging + 1));
    }

    public boolean isBurrowing() {
        return (Integer)this.entityData.get(BORROW) > 0;
    }

    public void tickBurrowing() {
        int burrowing = (Integer)this.entityData.get(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            burrowing = -1;
        }
        this.entityData.set(BORROW, (Object)(burrowing + 1));
    }

    public int getEmerge() {
        return (Integer)this.entityData.get(EMERGE);
    }

    public int getBorrow() {
        return (Integer)this.entityData.get(BORROW);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BORROW, (Object)0);
        builder.define(EMERGE, (Object)0);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.tickEmerging();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.tickCount % 20 == 0 && this.getHealth() < this.getMaxHealth() && this.getTicksFrozen() <= 0) {
            this.setHealth(this.getHealth() + 1.0f);
        }
    }

    public void awardHivemind() {
        CompoundTag data = this.getPersistentData();
        if (data.contains("hivemind")) {
            int summonerUUID = data.getInt("hivemind");
            Level level = this.level();
            Entity summoner = level.getEntity(summonerUUID);
            if (summoner instanceof Proto) {
                Proto smartMob = (Proto)summoner;
                int decision = data.getInt("decision");
                int member = data.getInt("member");
                smartMob.praisedForDecision(decision, member);
            }
        }
    }

    public void punishHivemind() {
        CompoundTag data = this.getPersistentData();
        if (data.contains("hivemind")) {
            int summonerUUID = data.getInt("hivemind");
            Level level = this.level();
            Entity summoner = level.getEntity(summonerUUID);
            if (summoner instanceof Proto) {
                Proto smartMob = (Proto)summoner;
                int decision = data.getInt("decision");
                int member = data.getInt("member");
                smartMob.punishForDecision(decision, member);
            }
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.isEmerging() || this.isBurrowing()) {
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            Level world = this.level();
            RandomSource randomsource = this.getRandom();
            for (int l = 0; l < this.getNumberOfParticles(); ++l) {
                Level level = this.level();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                int xi = randomsource.nextInt(-1, 1);
                int zi = randomsource.nextInt(-1, 1);
                if (world.getBlockState(new BlockPos((int)x, (int)y - 1, (int)z)).getBlock().asItem() == ItemStack.EMPTY.getItem()) continue;
                serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)world.getBlockState(new BlockPos((int)x, (int)y - 1, (int)z)).getBlock())), x + (double)xi, y - 0.1, z + (double)zi, 3, ((double)randomsource.nextFloat() - 1.0) * 0.08, ((double)randomsource.nextFloat() - 1.0) * 0.08, ((double)randomsource.nextFloat() - 1.0) * 0.08, (double)0.15f);
            }
        }
    }

    public int getNumberOfParticles() {
        return 2;
    }

    public boolean isCloseCombatant() {
        return false;
    }

    public boolean addEffect(MobEffectInstance instance, @Nullable Entity entity) {
        if (((MobEffect)instance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL && instance.getAmplifier() < 1) {
            return false;
        }
        return super.addEffect(instance, entity);
    }

    public void regulateSpawns() {
        AABB aabb = this.getBoundingBox().inflate(6.0);
        List entityList = this.level().getEntities((Entity)this, aabb, entity -> entity instanceof Organoid && !(entity instanceof Proto) && !(entity instanceof Mound));
        if (entityList.size() > 4) {
            this.tickBurrowing();
        }
    }
}

