/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Senchantments;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;

public class UtilityEntity
extends PathfinderMob {
    public Predicate<LivingEntity> TARGET_SELECTOR = entity -> Utilities.TARGET_SELECTOR.Test((LivingEntity)entity);

    protected UtilityEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    public List<? extends String> getDropList() {
        return null;
    }

    public boolean doHurtTarget(Entity entity) {
        boolean flag;
        float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
        Level var5 = this.level();
        if (var5 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var5;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)f);
        }
        if (flag = entity.hurt(this.getCustomDamage((LivingEntity)this), f)) {
            Level var7;
            float f1 = this.getKnockback(entity, damagesource);
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                livingentity.knockback((double)(f1 * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((var7 = this.level()) instanceof ServerLevel) {
                ServerLevel serverlevel1 = (ServerLevel)var7;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel1, (Entity)entity, (DamageSource)damagesource);
            }
            this.setLastHurtMob(entity);
            this.playAttackSound();
        }
        return flag;
    }

    public DamageSource getCustomDamage(LivingEntity entity) {
        return this.damageSources().mobAttack(entity);
    }

    public static boolean checkMonsterInfectedRules(EntityType<? extends UtilityEntity> p_219014_, ServerLevelAccessor levelAccessor, MobSpawnType type, BlockPos pos, RandomSource source) {
        if (levelAccessor.getDifficulty() != Difficulty.PEACEFUL) {
            return UtilityEntity.furtherSpawnParameters(p_219014_, levelAccessor, type, pos, source);
        }
        return false;
    }

    private static int countInfectedMobsInChunk(ServerLevel level, BlockPos pos) {
        int count = 0;
        ChunkPos chunkPos = new ChunkPos(pos);
        for (Entity entity : level.getEntities().getAll()) {
            if (!entity.chunkPosition().equals((Object)chunkPos) || !(entity instanceof Infected)) continue;
            ++count;
        }
        return count;
    }

    private static boolean furtherSpawnParameters(EntityType<? extends UtilityEntity> p_219014_, ServerLevelAccessor levelAccessor, MobSpawnType type, BlockPos pos, RandomSource source) {
        ServerLevel serverLevel;
        MinecraftServer server = levelAccessor.getServer();
        if (server != null && server.getPlayerList().getPlayers().isEmpty()) {
            return false;
        }
        if (levelAccessor instanceof ServerLevel && UtilityEntity.countInfectedMobsInChunk(serverLevel = (ServerLevel)levelAccessor, pos) > (Integer)SConfig.SERVER.mob_cap.get()) {
            return false;
        }
        return Monster.isDarkEnoughToSpawn((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && UtilityEntity.checkMobSpawnRules(p_219014_, (LevelAccessor)levelAccessor, (MobSpawnType)type, (BlockPos)pos, (RandomSource)source);
    }

    protected void addTargettingGoals() {
        this.goalSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Infected.class, Utilities.class}));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>(this, (Mob)this, LivingEntity.class, true, livingEntity -> livingEntity instanceof Player || ((List)SConfig.SERVER.whitelist.get()).contains(livingEntity.getEncodeId())){

            protected AABB getTargetSearchArea(double value) {
                return this.mob.getBoundingBox().inflate(value, value, value);
            }
        });
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>(this, (Mob)this, LivingEntity.class, true, livingEntity -> (Boolean)SConfig.SERVER.at_mob.get() != false && this.TARGET_SELECTOR.test((LivingEntity)livingEntity)){

            protected AABB getTargetSearchArea(double value) {
                return this.mob.getBoundingBox().inflate(value, value, value);
            }
        });
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        if (this.getDropList() == null) {
            return;
        }
        int val = 0;
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            ItemStack itemStack = attacker.getMainHandItem();
            Holder<Enchantment> lootingHolder = Senchantments.getEnchantment((LevelAccessor)attacker.level(), (ResourceKey<Enchantment>)Enchantments.LOOTING);
            val = itemStack.getEnchantmentLevel(lootingHolder);
        }
        if (!this.getDropList().isEmpty()) {
            for (String string : this.getDropList()) {
                String[] string2 = string.split("\\|");
                ItemStack itemStack = Utilities.tryToCreateStack(ResourceLocation.parse((String)string2[0]));
                int m = 1;
                if (Integer.parseUnsignedInt(string2[2]) == Integer.parseUnsignedInt(string2[3])) {
                    int o = Integer.parseUnsignedInt(string2[3]);
                    m = val > 0 ? this.random.nextInt(o, o + val) : o;
                } else if (Integer.parseUnsignedInt(string2[2]) >= 1 && Integer.parseUnsignedInt(string2[2]) >= 1) {
                    int v1 = Integer.parseUnsignedInt(string2[2]);
                    int v2 = Integer.parseUnsignedInt(string2[3]);
                    float e = (float)m * (0.15f * (float)val);
                    int i = e > (float)val ? (int)e : val;
                    m = this.random.nextInt(v1, v2 + i);
                }
                int value = Integer.parseUnsignedInt(string2[1]) + val * 10;
                if (!(Math.random() < (double)((float)value / 100.0f))) continue;
                itemStack.setCount(m);
                ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemStack);
                item.setPickUpDelay(10);
                this.level().addFreshEntity((Entity)item);
            }
        }
    }

    protected boolean Cold() {
        BlockPos pos = new BlockPos(this.getBlockX(), this.getBlockY(), this.getBlockZ());
        Biome biome = (Biome)this.level().getBiome(pos).value();
        return (Boolean)SConfig.SERVER.weaktocold.get() != false && (double)biome.getBaseTemperature() <= 0.2;
    }

    public String getMutation() {
        return null;
    }
}

