/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BasicInfected;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Inebriator;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.HazmatVariant;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.Collection;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfectedHazmat
extends Infected
implements VariantKeeper,
EvolvingInfected {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(InfectedHazmat.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BLOW_TIME = SynchedEntityData.defineId(InfectedHazmat.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public InfectedHazmat(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new CustomMeleeAttackGoal(this, this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.SCIENTIST_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.inf_hazmat_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.inf_hazmat_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.inf_hazmat_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_KNOCKBACK, 0.3);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.define(BLOW_TIME, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getTypeVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        HazmatVariant variant = (HazmatVariant)((Object)Util.getRandom((Object[])HazmatVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void setBlowTime(int i) {
        this.entityData.set(BLOW_TIME, (Object)i);
    }

    public int getBlowTime() {
        return (Integer)this.entityData.get(BLOW_TIME);
    }

    private void tickExplosion() {
        this.setBlowTime(this.getBlowTime() + 1);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.getVariant() == HazmatVariant.TANK && Math.random() < 0.5) {
            this.tickExplosion();
        }
        return super.hurt(source, amount);
    }

    public void tick() {
        super.tick();
        if (this.getVariant() == HazmatVariant.TANK) {
            if (this.getBlowTime() == 1) {
                this.playSound(SoundEvents.TNT_PRIMED);
            }
            if (this.getBlowTime() > 0) {
                this.tickExplosion();
            }
            if (this.getBlowTime() >= 60) {
                this.explodeTank();
            }
        }
        if (this.getVariant() == HazmatVariant.COAT) {
            this.tickEvolution(this, null, ScamperVariants.DEFAULT);
        }
    }

    @Override
    public void Evolve(Infected livingEntity, List<? extends String> value, ScamperVariants variants) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (this.getVariant() == HazmatVariant.COAT) {
                Inebriator inebriator = new Inebriator((EntityType<? extends Infected>)Sentities.INEBRIATER.get(), (Level)world);
                Collection collection = livingEntity.getActiveEffects();
                for (MobEffectInstance mobeffectinstance : collection) {
                    inebriator.addEffect(new MobEffectInstance(mobeffectinstance));
                }
                inebriator.setKills(livingEntity.getKills());
                inebriator.setEvoPoints(livingEntity.getEvoPoints());
                inebriator.setSearchPos(livingEntity.getSearchPos());
                inebriator.setLinked(livingEntity.getLinked());
                inebriator.setPos(livingEntity.getX(), livingEntity.getY() + 0.5, livingEntity.getZ());
                inebriator.setCustomName(livingEntity.getCustomName());
                inebriator.finalizeSpawn((ServerLevelAccessor)world, livingEntity.level().getCurrentDifficultyAt(new BlockPos((int)livingEntity.getX(), (int)livingEntity.getY(), (int)livingEntity.getZ())), MobSpawnType.NATURAL, null);
                world.addFreshEntity((Entity)inebriator);
                livingEntity.discard();
            }
            double x0 = livingEntity.getX() - ((double)this.random.nextFloat() - 0.1) * 0.1;
            double y0 = livingEntity.getY() + ((double)this.random.nextFloat() - 0.25) * 0.15 * 5.0;
            double z0 = livingEntity.getZ() + ((double)this.random.nextFloat() - 0.1) * 0.1;
            world.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
        }
    }

    private void explodeTank() {
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)((Integer)SConfig.SERVER.gastank_explosion.get()).intValue(), Level.ExplosionInteraction.NONE);
            this.discard();
        }
    }

    public HazmatVariant getVariant() {
        return HazmatVariant.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        if (i > HazmatVariant.values().length || i < 0) {
            this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)0);
        } else {
            this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)i);
        }
    }

    @Override
    public int amountOfMutations() {
        return HazmatVariant.values().length;
    }

    private void setVariant(HazmatVariant variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (((MobEffect)effectInstance.getEffect().value()).isBeneficial() || this.getTypeVariant() == 2) {
            return super.addEffect(effectInstance, entity);
        }
        return false;
    }
}

