/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BasicInfected;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.ArmedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvedInfected.HasUsableSlot;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.InfPlayerSkins;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfectedPlayer
extends Infected
implements RangedAttackMob,
ArmedInfected,
EvolvingInfected,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(InfectedPlayer.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public InfectedPlayer(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void customServerAiStep() {
        this.setSprinting(this.isAggressive());
        if (!this.isNoAi() && GoalUtils.hasGroundPathNavigation((Mob)this)) {
            ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        }
        super.customServerAiStep();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_player_loot.get();
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(3, (Goal)new RangedBowAttackGoal<InfectedPlayer>(this, 1.0, 20, 15.0f){

            public boolean canUse() {
                return super.canUse() && InfectedPlayer.this.getTarget() != null && InfectedPlayer.this.distanceToSqr((Entity)InfectedPlayer.this.getTarget()) > 20.0;
            }
        });
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.goalSelector.addGoal(4, (Goal)new CustomMeleeAttackGoal(this, this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new OpenDoorGoal(this, (Mob)this, true){

            public void start() {
                this.mob.swing(InteractionHand.MAIN_HAND);
                super.start();
            }
        });
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        return super.getCustomDamage(entity);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.populateDefaultEquipmentSlots();
        this.setSkin();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void setSkin() {
        InfPlayerSkins variant = (InfPlayerSkins)((Object)Util.getRandom((Object[])InfPlayerSkins.values(), (RandomSource)this.random));
        this.setVariant(variant);
    }

    public static void createItems(LivingEntity living, EquipmentSlot slot, List<? extends String> list) {
        if (living.getItemBySlot(slot) != ItemStack.EMPTY) {
            return;
        }
        ItemStack stack = ItemStack.EMPTY;
        for (String string : list) {
            String[] string2 = string.split("\\|");
            ItemStack itemStack = Utilities.tryToCreateStack(ResourceLocation.parse((String)string2[0]));
            if (!(Math.random() < (double)((float)Integer.parseUnsignedInt(string2[1]) / 100.0f))) continue;
            stack = itemStack;
        }
        living.setItemSlot(slot, stack);
    }

    public static void createName(LivingEntity living, List<? extends String> list) {
        if (living.getCustomName() != null) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            int randomIndex = living.getRandom().nextInt(list.size());
            Component component = Component.nullToEmpty((String)list.get(randomIndex));
            living.setCustomName(component);
        }
    }

    protected void populateDefaultEquipmentSlots() {
        InfectedPlayer.createName((LivingEntity)this, (List)SConfig.DATAGEN.name.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.HEAD, (List)SConfig.DATAGEN.player_h.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.CHEST, (List)SConfig.DATAGEN.player_c.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.LEGS, (List)SConfig.DATAGEN.player_l.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.FEET, (List)SConfig.DATAGEN.player_b.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.MAINHAND, (List)SConfig.DATAGEN.player_hm.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.OFFHAND, (List)SConfig.DATAGEN.player_ho.get());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.player_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.player_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.player_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_KNOCKBACK, 0.2);
    }

    @Override
    public void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getTypeVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.ADVENTURER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    public void performRangedAttack(LivingEntity entity, float value) {
        ItemStack itemstack = this.getProjectile(this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, value);
        if (this.getMainHandItem().getItem() instanceof BowItem) {
            abstractarrow = ((BowItem)this.getMainHandItem().getItem()).customArrow(abstractarrow, ItemStack.EMPTY, ItemStack.EMPTY);
        }
        double d0 = entity.getX() - this.getX();
        double d1 = entity.getY(0.3333333333333333) - abstractarrow.getY();
        double d2 = entity.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        if (abstractarrow instanceof Arrow) {
            Arrow arrow = (Arrow)abstractarrow;
            arrow.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600));
        }
        abstractarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.CROSSBOW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack p_32156_, float p_32157_) {
        return ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)p_32156_, (float)p_32157_, null);
    }

    public void tick() {
        super.tick();
        this.tickEvolution(this, (List)SConfig.SERVER.player_ev.get(), ScamperVariants.DEFAULT);
    }

    @Override
    public void Evolve(Infected livingEntity, List<? extends String> value, ScamperVariants variants) {
        if (livingEntity != null && value != null && livingEntity.level() instanceof ServerLevel) {
            Level level = livingEntity.level();
            RandomSource random = RandomSource.create();
            if (Math.random() < 0.9) {
                Random rand = new Random();
                for (int i = 0; i < 1; ++i) {
                    int randomIndex = rand.nextInt(value.size());
                    ResourceLocation randomElement1 = ResourceLocation.parse((String)value.get(randomIndex));
                    EntityType<?> randomElement = Utilities.tryToCreateEntity(randomElement1);
                    Entity waveentity = randomElement.create(level);
                    waveentity.setPos(livingEntity.getX(), livingEntity.getY() + 0.5, livingEntity.getZ());
                    waveentity.setCustomName(livingEntity.getCustomName());
                    if (waveentity instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)waveentity;
                        Collection collection = livingEntity.getActiveEffects();
                        for (MobEffectInstance mobeffectinstance : collection) {
                            entity.addEffect(new MobEffectInstance(mobeffectinstance));
                        }
                    }
                    if (waveentity instanceof Infected) {
                        Infected infected = (Infected)waveentity;
                        infected.setKills(livingEntity.getKills());
                        infected.setEvoPoints(livingEntity.getEvoPoints());
                        infected.setSearchPos(livingEntity.getSearchPos());
                        infected.setLinked(livingEntity.getLinked());
                        if (infected instanceof HasUsableSlot) {
                            HasUsableSlot hasUsableSlot = (HasUsableSlot)((Object)infected);
                            for (EquipmentSlot slot : EquipmentSlot.values()) {
                                if (!hasUsableSlot.hasUsableSlot(slot)) continue;
                                infected.setItemSlot(slot, this.getItemBySlot(slot));
                            }
                        }
                    }
                    level.addFreshEntity(waveentity);
                    livingEntity.discard();
                }
            } else {
                Scamper scamper = new Scamper(Sentities.SCAMPER.get(), level);
                scamper.setPos(livingEntity.getX(), livingEntity.getY() + 0.5, livingEntity.getZ());
                scamper.setCustomName(livingEntity.getCustomName());
                scamper.setKills(livingEntity.getKills());
                scamper.setEvoPoints(livingEntity.getEvoPoints());
                scamper.setLinked(livingEntity.getLinked());
                scamper.setSearchPos(livingEntity.getSearchPos());
                Collection collection = livingEntity.getActiveEffects();
                for (MobEffectInstance mobeffectinstance : collection) {
                    scamper.addEffect(new MobEffectInstance(mobeffectinstance));
                }
                level.addFreshEntity((Entity)scamper);
                livingEntity.discard();
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double x0 = livingEntity.getX() - ((double)random.nextFloat() - 0.1) * 0.1;
                double y0 = livingEntity.getY() + ((double)random.nextFloat() - 0.25) * 0.15 * 5.0;
                double z0 = livingEntity.getZ() + ((double)random.nextFloat() - 0.1) * 0.1;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        Item item = Items.FLINT_AND_STEEL;
        if (this.getMainHandItem().getItem() == item || this.getOffhandItem().getItem() == item) {
            entity.setRemainingFireTicks(200);
        }
        return super.doHurtTarget(entity);
    }

    private void setVariant(InfPlayerSkins variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public InfPlayerSkins getVariant() {
        return InfPlayerSkins.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(i > InfPlayerSkins.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return InfPlayerSkins.values().length;
    }
}

