/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BasicInfected;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.InfVillagerSkins;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfectedVillager
extends Infected
implements EvolvingInfected,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(InfectedVillager.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public InfectedVillager(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new CustomMeleeAttackGoal(this, this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new OpenDoorGoal(this, (Mob)this, true){

            public boolean canUse() {
                return super.canUse() && (Boolean)SConfig.SERVER.higher_thinking.get() != false;
            }

            public void start() {
                this.mob.swing(InteractionHand.MAIN_HAND);
                super.start();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_villager_loot.get();
    }

    protected void customServerAiStep() {
        if (!this.isNoAi() && GoalUtils.hasGroundPathNavigation((Mob)this) && ((Boolean)SConfig.SERVER.higher_thinking.get()).booleanValue()) {
            ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        }
        super.customServerAiStep();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getTypeVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.inf_vil_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.inf_vil_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.inf_vil_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_KNOCKBACK, 0.3);
    }

    public void baseTick() {
        super.baseTick();
        this.tickEvolution(this, (List)SConfig.SERVER.villager_ev.get(), ScamperVariants.VILLAGER);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INF_VILLAGER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public String origin() {
        return "minecraft:villager";
    }

    private void setVariant(InfVillagerSkins variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public InfVillagerSkins getVariant() {
        return InfVillagerSkins.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(i > InfVillagerSkins.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return InfVillagerSkins.values().length;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Holder biome = level.getBiome(this.getOnPos());
        if (biome.is(Tags.Biomes.IS_DESERT)) {
            this.setVariant(InfVillagerSkins.DESERT);
        }
        if (biome.is(Biomes.JUNGLE) || biome.is(Biomes.BAMBOO_JUNGLE)) {
            this.setVariant(InfVillagerSkins.JUNGLE);
        }
        if (biome.is(Biomes.SAVANNA) || biome.is(Biomes.SAVANNA_PLATEAU)) {
            this.setVariant(InfVillagerSkins.SAVANNA);
        }
        if (biome.is(Tags.Biomes.IS_SWAMP)) {
            this.setVariant(InfVillagerSkins.SWAMP);
        }
        if (biome.is(Tags.Biomes.IS_CONIFEROUS_TREE)) {
            this.setVariant(InfVillagerSkins.TAIGA);
        }
        if (biome.is(Tags.Biomes.IS_SNOWY)) {
            this.setVariant(InfVillagerSkins.TUNDRA);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }
}

