/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BasicInfected;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.Utility.Specter;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.UseItemGoal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;

public class InfectedWanderingTrader
extends Infected
implements EvolvingInfected {
    public InfectedWanderingTrader(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new UseItemGoal((Mob)this, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_INVISIBILITY), SoundEvents.WANDERING_TRADER_DRINK_POTION, mob -> !mob.isInvisible() && this.isAggressive() && (Boolean)SConfig.SERVER.inf_van_potion.get() != false));
        this.goalSelector.addGoal(0, (Goal)new UseItemGoal<InfectedWanderingTrader>(this, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.STRONG_HEALING), SoundEvents.WANDERING_TRADER_DRINK_POTION, mob -> mob.getHealth() < mob.getMaxHealth() / 2.0f && !this.isAggressive() && (Boolean)SConfig.SERVER.inf_van_potion.get() != false){

            public void start() {
                InfectedWanderingTrader.this.setHunger(0);
                super.start();
            }
        });
        this.goalSelector.addGoal(1, (Goal)new CustomMeleeAttackGoal(this, this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_wan_loot.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.inf_van_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.inf_van_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.inf_van_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_KNOCKBACK, 0.3);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.TRADER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound() {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public void baseTick() {
        super.baseTick();
        this.tickEvolution(this, (List)SConfig.SERVER.villager_ev.get(), ScamperVariants.VILLAGER);
    }

    @Override
    public void Evolve(Infected livingEntity, List<? extends String> value, ScamperVariants variants) {
        if (this.getLinked()) {
            Specter specter = new Specter(Sentities.SPECTER.get(), this.level());
            specter.setBiomass(this.getKills() + this.getEvoPoints());
            specter.setCustomName(this.getCustomName());
            specter.moveTo(this.getX(), this.getY(), this.getZ());
            this.level().addFreshEntity((Entity)specter);
            this.discard();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double x0 = livingEntity.getX() - ((double)this.random.nextFloat() - 0.1) * 0.1;
                double y0 = livingEntity.getY() + ((double)this.random.nextFloat() - 0.25) * 0.15 * 5.0;
                double z0 = livingEntity.getZ() + ((double)this.random.nextFloat() - 0.1) * 0.1;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            }
        } else {
            EvolvingInfected.super.Evolve(livingEntity, value, variants);
        }
    }

    @Override
    public String origin() {
        return "minecraft:wandering_trader";
    }
}

