/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BasicInfected;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.BuffAlliesGoal;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.RangedBuff;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SdamageTypes;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.UseItemGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class InfectedWitch
extends Infected
implements RangedAttackMob,
RangedBuff,
EvolvingInfected {
    private Holder<Potion> potion = null;

    public InfectedWitch(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new UseItemGoal<InfectedWitch>(this, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.STRONG_HEALING), SoundEvents.WITCH_DRINK, p_35882_ -> this.getHealth() < this.getMaxHealth() / 2.0f && (Boolean)SConfig.SERVER.use_potions.get() != false){

            public void start() {
                InfectedWitch.this.setHunger(0);
                super.start();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, this, 1.5, false){

            @Override
            public boolean canUse() {
                return super.canUse() && (this.mob.getRandom().nextInt(0, 10) == 8 || (Boolean)SConfig.SERVER.use_potions.get() == false);
            }

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 1.5 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(1, (Goal)new UseItemGoal((Mob)this, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_FIRE_RESISTANCE), SoundEvents.WITCH_DRINK, p_35882_ -> this.isOnFire() && this.getLastDamageSource() != null && this.getLastDamageSource() == this.damageSources().inFire() && !this.hasEffect(MobEffects.FIRE_RESISTANCE) && (Boolean)SConfig.SERVER.use_potions.get() != false));
        this.goalSelector.addGoal(4, (Goal)new BuffAlliesGoal(this, this, Infected.class, 1.3, 35, 45, 3.0f, entity -> entity.hasEffect(Seffects.STARVATION) && !(entity instanceof InfectedWitch)){

            @Override
            public boolean canUse() {
                return super.canUse() && (Boolean)SConfig.SERVER.use_potions.get() != false && this.mob.getLastHurtByMob() == null;
            }
        });
        this.goalSelector.addGoal(4, (Goal)new BuffAlliesGoal(this, this, Mob.class, 1.3, (Integer)SConfig.SERVER.buff_potion_meter.get(), (Integer)SConfig.SERVER.at_potion_meter.get(), 3.0f, entity -> ((List)SConfig.SERVER.evolved.get()).contains(entity.getEncodeId()) && !(entity instanceof InfectedWitch)){

            @Override
            public boolean canUse() {
                return super.canUse() && (Boolean)SConfig.SERVER.use_potions.get() != false && this.mob.getLastHurtByMob() == null;
            }
        });
        this.goalSelector.addGoal(4, (Goal)new BuffAlliesGoal(this, this, Infected.class, 1.3, (Integer)SConfig.SERVER.buff_potion_meter.get(), (Integer)SConfig.SERVER.buff_potion_meter.get(), 3.0f, livingEntity -> !(livingEntity instanceof InfectedWitch)){

            @Override
            public boolean canUse() {
                return super.canUse() && (Boolean)SConfig.SERVER.use_potions.get() != false && this.mob.getLastHurtByMob() == null;
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RangedAttackGoal(this, this, 1.0, (Integer)SConfig.SERVER.at_potion_meter.get(), 10.0f){

            public boolean canUse() {
                return super.canUse() && (Boolean)SConfig.SERVER.use_potions.get() != false;
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_witch_loot.get();
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 30 == 0 && this.potion != null) {
            ItemStack potionStack = PotionContents.createItemStack((Item)Items.POTION, this.potion);
            if (this.isAlive() && !this.getMainHandItem().equals(potionStack)) {
                this.setItemSlot(EquipmentSlot.OFFHAND, potionStack);
            }
        }
        this.tickEvolution(this, (List)SConfig.SERVER.wit_ev.get(), ScamperVariants.VILLAGER);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.inf_witch_melee_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.inf_witch_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.inf_witch_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.3) {
            return SdamageTypes.infected_witch_damage((LivingEntity)this);
        }
        return super.getCustomDamage(entity);
    }

    public void performRangedAttack(LivingEntity entity, float f) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = entity.getX() + vec3.x - this.getX();
        double d1 = entity.getEyeY() - (double)1.1f - this.getY();
        double d2 = entity.getZ() + vec3.z - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.potion = d3 >= 4.0 && this.getAttackPotion() != null ? this.getAttackPotion() : (entity.getType().is(EntityTypeTags.UNDEAD) ? Potions.HEALING : Potions.HARMING);
        ThrownPotion thrownpotion = new ThrownPotion(this.level(), (LivingEntity)this);
        thrownpotion.setItem(PotionContents.createItemStack((Item)Items.SPLASH_POTION, this.potion));
        thrownpotion.setXRot(thrownpotion.getXRot() - -20.0f);
        thrownpotion.shoot(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
        if (!this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        }
        this.level().addFreshEntity((Entity)thrownpotion);
    }

    @Override
    public void performRangedBuff(LivingEntity entity, float f) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = entity.getX() + vec3.x - this.getX();
        double d1 = entity.getEyeY() - (double)1.1f - this.getY();
        double d2 = entity.getZ() + vec3.z - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.potion = entity.getHealth() < entity.getMaxHealth() && !entity.isOnFire() ? Potions.REGENERATION : (entity.isOnFire() && !entity.hasEffect(MobEffects.FIRE_RESISTANCE) ? Potions.FIRE_RESISTANCE : (d3 <= 4.0 && this.getBuffPotion() != null ? this.getBuffPotion() : Potions.HEALING));
        ThrownPotion thrownpotion = new ThrownPotion(this.level(), (LivingEntity)this);
        thrownpotion.setItem(PotionContents.createItemStack((Item)Items.SPLASH_POTION, this.potion));
        thrownpotion.setXRot(thrownpotion.getXRot() - -20.0f);
        thrownpotion.shoot(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
        if (!this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        }
        this.level().addFreshEntity((Entity)thrownpotion);
    }

    private Holder<Potion> getBuffPotion() {
        Random rand = new Random();
        List ev = (List)SConfig.SERVER.buffing_potions.get();
        int randomIndex = rand.nextInt(ev.size());
        ResourceLocation randomElement1 = ResourceLocation.parse((String)((String)ev.get(randomIndex)));
        return Utilities.tryToCreatePotion(randomElement1);
    }

    private Holder<Potion> getAttackPotion() {
        Random rand = new Random();
        List ev = (List)SConfig.SERVER.harming_potions.get();
        int randomIndex = rand.nextInt(ev.size());
        ResourceLocation randomElement1 = ResourceLocation.parse((String)((String)ev.get(randomIndex)));
        return Utilities.tryToCreatePotion(randomElement1);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.WITCH_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public String origin() {
        return "minecraft:witch";
    }
}

