/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.GazenWaterLeapGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.FallenMultipart.Licker;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.Projectile.BileProjectile;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.Sentities.WaterInfected;
import com.Harbinger.Spore.core.SAttributes;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Gazenbrecher
extends Calamity
implements WaterInfected,
RangedAttackMob,
TrueCalamity {
    public static final EntityDataAccessor<Integer> ADAPTATION = SynchedEntityData.defineId(Gazenbrecher.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> TONGUE = SynchedEntityData.defineId(Gazenbrecher.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private int radar;
    private final CalamityMultipart[] subEntities;
    public final CalamityMultipart lowerbody;
    public final CalamityMultipart head;
    public final CalamityMultipart tongue;
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.GAZEN_TAIL, HitboxesForParts.GAZEN_HEAD, HitboxesForParts.GAZEN_LEFT_LEG, HitboxesForParts.GAZEN_RIGHT_LEG);

    public Gazenbrecher(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.lowerbody = new CalamityMultipart(this, "lowerbody", 3.0f, 3.0f);
        this.tongue = new CalamityMultipart(this, "tongue", 2.0f, 2.0f);
        this.head = new CalamityMultipart(this, "head", 3.0f, 3.0f);
        this.subEntities = new CalamityMultipart[]{this.lowerbody, this.head, this.tongue};
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.gazen_loot.get();
    }

    @Override
    public void travel(Vec3 vec) {
        if (this.isEffectiveAi() && this.isInFluidType()) {
            this.moveRelative(0.1f, vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
        } else {
            super.travel(vec);
        }
    }

    @Override
    public void ActivateAdaptation() {
        this.entityData.set(ADAPTATION, (Object)21);
    }

    public void setId(int p_20235_) {
        super.setId(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(p_20235_ + i + 1);
        }
    }

    @Override
    public double setInflation() {
        return 1.0;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getHealth() >= this.getMaxHealth() && this.getTongueHp() < this.getMaxTongueHp() && this.tickCount % 40 == 0) {
            this.setTongueHp(this.getTongueHp() + 1.0f);
        }
        if (this.isInFluidType()) {
            if (this.getTarget() == null && this.radar >= 1200) {
                this.playSound(Ssounds.SONAR.get());
                this.radar = 0;
                AABB boundingBox = this.getBoundingBox().inflate(64.0);
                List entities = this.level().getEntities((Entity)this, boundingBox);
                for (Entity entity : entities) {
                    LivingEntity livingEntity;
                    if (!((List)SConfig.SERVER.whitelist.get()).contains(entity.getEncodeId())) {
                        if (!(entity instanceof Player)) continue;
                        Player player = (Player)entity;
                        if (player.getAbilities().instabuild) continue;
                    }
                    if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isAlive()) continue;
                    this.playSound(Ssounds.SIGNAL.get(), 2.0f, 1.0f);
                    this.setTarget(livingEntity);
                }
            } else {
                ++this.radar;
            }
        }
        if (!this.isAdaptedToFire() && this.tickCount % 40 == 0 && this.isOnFire()) {
            this.entityData.set(ADAPTATION, (Object)((Integer)this.entityData.get(ADAPTATION) + 1));
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TONGUE, (Object)Float.valueOf(this.getMaxTongueHp()));
        builder.define(ADAPTATION, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("tongue_hp", ((Float)this.entityData.get(TONGUE)).floatValue());
        tag.putInt("adaptation", ((Integer)this.entityData.get(ADAPTATION)).intValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(TONGUE, (Object)Float.valueOf(tag.getFloat("tongue_hp")));
        this.entityData.set(ADAPTATION, (Object)tag.getInt("adaptation"));
    }

    public float getTongueHp() {
        return ((Float)this.entityData.get(TONGUE)).floatValue();
    }

    public void setTongueHp(float i) {
        this.entityData.set(TONGUE, (Object)Float.valueOf(i));
    }

    public float getMaxTongueHp() {
        return (float)((Double)SConfig.SERVER.gazen_hp.get() / 4.0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.gazen_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.gazen_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.gazen_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.5).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(SAttributes.TOXICITY, 0.0).add(SAttributes.REJUVENATION, 0.0).add(SAttributes.LOCALIZATION, 0.0).add(SAttributes.LACERATION, 0.0).add(SAttributes.CORROSIVES, 0.0).add(SAttributes.BALLISTIC, 0.0).add(SAttributes.GRINDING, 0.0);
    }

    public void aiStep() {
        float f14 = this.getYRot() * ((float)Math.PI / 180);
        float f2 = Mth.sin((float)f14);
        float f15 = Mth.cos((float)f14);
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].getX(), this.subEntities[j].getY(), this.subEntities[j].getZ());
        }
        this.tickPart(this.lowerbody, f2 * 2.5f, 0.0, -f15 * 2.5f);
        this.tickPart(this.head, f2 * -3.0f, 0.0, -f15 * -3.0f);
        this.tickPart(this.tongue, f2 * -5.0f, 0.3, -f15 * -5.0f);
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].xo = avec3[l].x;
            this.subEntities[l].yo = avec3[l].y;
            this.subEntities[l].zo = avec3[l].z;
            this.subEntities[l].xOld = avec3[l].x;
            this.subEntities[l].yOld = avec3[l].y;
            this.subEntities[l].zOld = avec3[l].z;
        }
        super.aiStep();
    }

    public CalamityMultipart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_218825_) {
        super.recreateFromPacket(p_218825_);
    }

    public boolean isAdaptedToFire() {
        return (Integer)this.entityData.get(ADAPTATION) > 20;
    }

    public int getAdaptationCount() {
        return (Integer)this.entityData.get(ADAPTATION);
    }

    public boolean fireImmune() {
        return this.isAdaptedToFire();
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.gazen_dpsr.get();
    }

    @Override
    public void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new ScatterShotRangedGoal(this, 1.3, 60, 32.0f, 1, 3){

            @Override
            public boolean canUse() {
                if (Gazenbrecher.this.getTongueHp() <= 0.0f) {
                    return false;
                }
                return super.canUse() && (Gazenbrecher.this.calculateHeight() || Gazenbrecher.this.calculateDistance());
            }
        });
        this.goalSelector.addGoal(4, (Goal)new GazenWaterLeapGoal(this));
        this.goalSelector.addGoal(4, (Goal)new AOEMeleeAttackGoal(this, 1.5, false, 2.5, 6.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                float f = Gazenbrecher.this.getBbWidth();
                return f * 2.0f * f * 2.0f + entity.getBbWidth();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(6, (Goal)new CalamityInfectedCommand(this));
        this.goalSelector.addGoal(7, (Goal)new SummonScentInCombat(this));
        this.goalSelector.addGoal(8, (Goal)new SporeBurstSupport(this));
        super.registerGoals();
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        if (calamityMultipart == this.tongue) {
            if (this.getTongueHp() > 0.0f && value > this.getTongueHp()) {
                if (this.getTongueHp() > 0.0f && value > this.getTongueHp()) {
                    this.playSound(Ssounds.LIMB_SLASH.get());
                    this.SummonDetashedTongue();
                }
                this.playSound(Ssounds.LIMB_SLASH.get());
            }
            this.hurt(source, value * 1.5f);
            this.setTongueHp(value > this.getTongueHp() ? 0.0f : this.getTongueHp() - value);
        } else {
            this.hurt(source, value);
        }
        return true;
    }

    @Override
    public int chemicalRange() {
        return 16;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.gazen_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.gazen_debuffs.get();
    }

    boolean calculateHeight() {
        return this.getTarget() != null && this.getTarget().getY() > this.getY() && Math.abs(Math.abs(this.getTarget().getY()) - Math.abs(this.getY())) > 5.0;
    }

    boolean calculateDistance() {
        return this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) > 300.0;
    }

    public boolean hasLineOfSight(Entity entity) {
        if (this.calculateDistance() || this.calculateHeight()) {
            return true;
        }
        return super.hasLineOfSight(entity);
    }

    public void performRangedAttack(LivingEntity livingEntity, float p_33318_) {
        if (!this.level().isClientSide) {
            BileProjectile tumor = new BileProjectile(this.level(), (LivingEntity)this, this.TARGET_SELECTOR);
            Vec3 vec3 = new Vec3(3.0, 0.0, 0.0).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
            double dx = livingEntity.getX() - this.getX();
            double dy = livingEntity.getY() + (double)livingEntity.getEyeHeight();
            double dz = livingEntity.getZ() - this.getZ();
            if (this.isAdaptedToFire()) {
                tumor.setRemainingFireTicks(200);
            }
            tumor.setDamage((float)((Double)SConfig.SERVER.gazen_ranged_damage.get() * 1.0));
            tumor.moveTo(this.getX() + vec3.x, this.getY() + 1.0, this.getZ() + vec3.z);
            tumor.shoot(dx, dy - tumor.getY() + Math.hypot(dx, dz) * (double)0.001f, dz, 2.0f, 6.0f);
            this.level().addFreshEntity((Entity)tumor);
        }
    }

    private void SummonDetashedTongue() {
        Licker licker = new Licker(Sentities.LICKER.get(), this.level());
        Vec3 vec3 = new Vec3(4.0, 0.0, 0.0).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
        licker.setBurned(this.isAdaptedToFire());
        licker.moveTo(this.getX() + vec3.x, this.getY() + 1.6, this.getZ() + vec3.z);
        licker.setYBodyRot(this.getYRot());
        this.level().addFreshEntity((Entity)licker);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (this.isAdaptedToFire()) {
            entity.setRemainingFireTicks(200);
        }
        this.playSound(Ssounds.SIEGER_BITE.get());
        return super.doHurtTarget(entity);
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        if (this.onGround()) {
            return SoundEvents.RAVAGER_STEP;
        }
        return SoundEvents.GENERIC_SWIM;
    }

    protected SoundEvent getAmbientSound() {
        if (this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) > 200.0) {
            return null;
        }
        return Ssounds.GAZEN_AMBIENT.get();
    }

    @Override
    public String getMutation() {
        if (this.isAdaptedToFire()) {
            return "spore.entity.variant.crispy";
        }
        return super.getMutation();
    }

    @Override
    public boolean getAdaptation() {
        return this.isAdaptedToFire();
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>();
        if (this.getTongueHp() > 0.0f) {
            values.add(HitboxesForParts.LICKER);
        }
        for (HitboxesForParts hitboxes : this.innatePartList) {
            HitboxesForParts part = this.calculateChance(hitboxes, 0.85f);
            if (part == null) continue;
            values.add(part);
        }
        return values;
    }
}

