/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.AerialRangedGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.AI.FlyingWanderAround;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.FlyingInfected;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.Projectile.ThrownTumor;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.Sentities.Utility.TumoroidNuke;
import com.Harbinger.Spore.core.SAttributes;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public class Hinderburg
extends Calamity
implements FlyingInfected,
TrueCalamity,
RangedAttackMob {
    public static final EntityDataAccessor<Boolean> ADAPTATION = SynchedEntityData.defineId(Hinderburg.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DROPPED_BOMBS = SynchedEntityData.defineId(Hinderburg.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> BOMB = SynchedEntityData.defineId(Hinderburg.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int bomb_timer = -1;
    private final CalamityMultipart[] subEntities;
    public final CalamityMultipart lowerbody;
    public final CalamityMultipart forwardbody;
    public final CalamityMultipart rightcannon;
    public final CalamityMultipart leftcannon;
    public final CalamityMultipart mouth;
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.HINDEN_FRONT, HitboxesForParts.HINDEN_BACK, HitboxesForParts.MAW, HitboxesForParts.RIGHT_CANNON, HitboxesForParts.LEFT_CANNON);

    public Hinderburg(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.lowerbody = new CalamityMultipart(this, "lowerbody", 4.0f, 4.0f);
        this.forwardbody = new CalamityMultipart(this, "forwardbody", 4.0f, 4.0f);
        this.rightcannon = new CalamityMultipart(this, "rightcannon", 1.5f, 1.5f);
        this.leftcannon = new CalamityMultipart(this, "leftcannon", 1.5f, 1.5f);
        this.mouth = new CalamityMultipart(this, "mouth", 3.0f, 0.5f);
        this.subEntities = new CalamityMultipart[]{this.lowerbody, this.forwardbody, this.rightcannon, this.leftcannon, this.mouth};
        this.moveControl = new HindenMovementController(this);
        this.lookControl = new HindenLookControl((Mob)this);
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public boolean causeFallDamage(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    @Override
    public void travel(Vec3 vec) {
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.1, 0.0));
        }
        if (this.isEffectiveAi() && !this.onGround()) {
            this.moveRelative(0.1f, vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
        } else {
            super.travel(vec);
        }
    }

    @Override
    public boolean canCalcify(Entity entity) {
        return false;
    }

    public boolean isNoGravity() {
        return true;
    }

    public void setId(int p_20235_) {
        super.setId(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(p_20235_ + i + 1);
        }
    }

    @Override
    public double setInflation() {
        return 1.0;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount % 20 == 0) {
            if (this.getKills() >= 50 && this.getDroppedBombs() >= 5 && !this.isAdapted()) {
                this.entityData.set(ADAPTATION, (Object)true);
            }
            if (this.isAdapted()) {
                AABB aabb = this.getBoundingBox().inflate(8.0);
                List entities = this.level().getEntities((Entity)this, aabb);
                for (Entity entity : entities) {
                    LivingEntity living;
                    if (!(entity instanceof LivingEntity) || !Utilities.TARGET_SELECTOR.Test(living = (LivingEntity)entity)) continue;
                    living.setRemainingFireTicks(100);
                }
            }
        }
        if (this.getBomb() < 2450) {
            int value = this.isAdapted() ? 2 : 1;
            this.setBomb(this.getBomb() + value);
        }
        if (this.getBombTimer() >= 0) {
            this.tickBomb();
            if (this.getBombTimer() == 1) {
                Hinderburg entity = this.getTarget() != null ? this.getTarget() : this;
                entity.playSound(Ssounds.HINDEN_NUKE.get());
            }
            if (this.getBombTimer() >= 80) {
                this.SummonNuke();
                this.bomb_timer = -1;
            }
        }
    }

    public int getBombTimer() {
        return this.bomb_timer;
    }

    public void tickBomb() {
        ++this.bomb_timer;
    }

    public int getDroppedBombs() {
        return (Integer)this.entityData.get(DROPPED_BOMBS);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.hinden_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FLYING_SPEED, 0.2).add(Attributes.ARMOR, (Double)SConfig.SERVER.hinden_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.hinden_damage.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(SAttributes.TOXICITY, 0.0).add(SAttributes.REJUVENATION, 0.0).add(SAttributes.LOCALIZATION, 0.0).add(SAttributes.LACERATION, 0.0).add(SAttributes.CORROSIVES, 0.0).add(SAttributes.BALLISTIC, 0.0).add(SAttributes.GRINDING, 0.0);
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        if (calamityMultipart == this.mouth) {
            this.hurt(source, value * 2.0f);
        } else if (calamityMultipart == this.rightcannon || calamityMultipart == this.leftcannon) {
            this.hurt(source, value * 3.0f);
        } else {
            this.hurt(source, value);
        }
        return true;
    }

    @Override
    public int chemicalRange() {
        return 32;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.hinden_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.hinden_debuffs.get();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.hindie_loot.get();
    }

    @Override
    public void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, TumoroidNuke.class, 10.0f, 1.0, 1.2));
        this.goalSelector.addGoal(5, (Goal)new AerialRangedGoal(this, this, 1.3, this.isAdapted() ? 20 : 40, 16.0f, 5, 10){

            @Override
            public boolean canUse() {
                return super.canUse() && this.target != null && (this.target.onGround() || this.target.isInFluidType());
            }
        });
        this.goalSelector.addGoal(6, (Goal)new AOEMeleeAttackGoal(this, 1.0, true, 2.0, 6.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.goalSelector.addGoal(6, (Goal)new CalamityInfectedCommand(this));
        this.goalSelector.addGoal(7, (Goal)new SummonScentInCombat(this));
        this.goalSelector.addGoal(8, (Goal)new SporeBurstSupport(this));
        this.goalSelector.addGoal(9, (Goal)new FlyingWanderAround(this, 0.5));
        super.registerGoals();
    }

    @Override
    public void ActivateAdaptation() {
        this.setKills(this.getKills() + 50);
        this.entityData.set(DROPPED_BOMBS, (Object)((Integer)this.entityData.get(DROPPED_BOMBS) + 5));
    }

    public void aiStep() {
        float f14 = this.getYRot() * ((float)Math.PI / 180);
        float f2 = Mth.sin((float)f14);
        float f15 = Mth.cos((float)f14);
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].getX(), this.subEntities[j].getY(), this.subEntities[j].getZ());
        }
        this.tickPart(this.forwardbody, f2 * -5.0f, 0.0, f15 * 5.0f);
        this.tickPart(this.lowerbody, f2 * 5.0f, 0.0, f15 * -5.0f);
        this.tickPart(this.mouth, f2 * -0.5f, -0.5, f15 * 0.5f);
        this.tickPart(this.rightcannon, new Vec3(0.0, 0.0, 4.0), 0.3);
        this.tickPart(this.leftcannon, new Vec3(0.0, 0.0, -4.0), 0.3);
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].xo = avec3[l].x;
            this.subEntities[l].yo = avec3[l].y;
            this.subEntities[l].zo = avec3[l].z;
            this.subEntities[l].xOld = avec3[l].x;
            this.subEntities[l].yOld = avec3[l].y;
            this.subEntities[l].zOld = avec3[l].z;
        }
        super.aiStep();
        if (this.isAdapted()) {
            for (int i = 0; i < 360; ++i) {
                if (i % 40 != 0) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY(), this.getZ(), Math.cos(i) * 0.25, 0.25, Math.sin(i) * 0.25);
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY(), this.getZ(), Math.sin(i) * 0.25, -0.25, Math.cos(i) * 0.25);
            }
        }
    }

    public CalamityMultipart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_218825_) {
        super.recreateFromPacket(p_218825_);
    }

    public boolean isAdapted() {
        return (Boolean)this.entityData.get(ADAPTATION);
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.hinden_dpsr.get();
    }

    public boolean tryToSummonNUKE(Entity entity) {
        if (entity != null && this.isArmed()) {
            double x = Math.abs(entity.getX()) - Math.abs(this.getX());
            double z = Math.abs(entity.getZ()) - Math.abs(this.getZ());
            return entity.getY() < this.getY() && Math.abs(x) < 10.0 && Math.abs(z) < 10.0;
        }
        return false;
    }

    public void SummonNuke() {
        TumoroidNuke tnt = new TumoroidNuke(this.level(), this);
        tnt.setOverclocked((Boolean)this.entityData.get(ADAPTATION));
        tnt.setBuster(Math.random() < 0.2);
        this.entityData.set(DROPPED_BOMBS, (Object)((Integer)this.entityData.get(DROPPED_BOMBS) + 1));
        this.level().addFreshEntity((Entity)tnt);
        this.setBomb(0);
    }

    public int getAmbientSoundInterval() {
        return 200;
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.HINDEN_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.RAVAGER_STEP;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOMB, (Object)0);
        builder.define(DROPPED_BOMBS, (Object)0);
        builder.define(ADAPTATION, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("bomb", ((Integer)this.entityData.get(BOMB)).intValue());
        tag.putInt("dropped_bombs", ((Integer)this.entityData.get(DROPPED_BOMBS)).intValue());
        tag.putBoolean("adaptation", ((Boolean)this.entityData.get(ADAPTATION)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(BOMB, (Object)tag.getInt("bomb"));
        this.entityData.set(DROPPED_BOMBS, (Object)tag.getInt("dropped_bombs"));
        this.entityData.set(ADAPTATION, (Object)tag.getBoolean("adaptation"));
    }

    public int getBomb() {
        return (Integer)this.entityData.get(BOMB);
    }

    public void setBomb(int i) {
        this.entityData.set(BOMB, (Object)i);
    }

    public boolean isArmed() {
        return this.getBomb() >= 2400;
    }

    @Override
    public boolean tryToDigDown() {
        return super.tryToDigDown() || this.verticalCollision;
    }

    public void performRangedAttack(LivingEntity livingEntity, float p_33318_) {
        if (!this.level().isClientSide) {
            ThrownTumor tumor = new ThrownTumor(this.level(), (LivingEntity)this);
            double dx = livingEntity.getX() - this.getX();
            double dy = livingEntity.getY() + (double)livingEntity.getEyeHeight() - 1.5;
            double dz = livingEntity.getZ() - this.getZ();
            Vec3 vec3 = this.random.nextFloat() < 0.3f ? new Vec3(2.0, 1.3, 5.0).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f) : (this.random.nextFloat() < 0.3f ? new Vec3(2.0, 1.3, -5.0).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f) : new Vec3(0.0, -2.0, 0.0).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f));
            if (SConfig.SERVER.hinden_explosive_effects != null) {
                List ev = (List)SConfig.SERVER.hinden_explosive_effects.get();
                for (int i = 0; i < 1; ++i) {
                    int randomIndex = this.random.nextInt(ev.size());
                    ResourceLocation randomElement1 = ResourceLocation.parse((String)((String)ev.get(randomIndex)));
                    Holder<MobEffect> randomElement = Utilities.tryToCreateEffect(randomElement1);
                    tumor.setMobEffect(randomElement);
                }
            }
            tumor.setExplode(Level.ExplosionInteraction.MOB);
            tumor.moveTo(this.getX() + vec3.x(), this.getY() + vec3.y(), this.getZ() + vec3.z());
            tumor.shoot(dx, dy - tumor.getY() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
            this.level().addFreshEntity((Entity)tumor);
            this.setDeltaMovement(this.getDeltaMovement().add(new Vec3(dx, dy, dz).normalize().scale(0.2)));
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        this.playSound(Ssounds.SIEGER_BITE.get());
        return super.doHurtTarget(entity);
    }

    @Override
    public String getMutation() {
        if (this.isAdapted()) {
            return "spore.entity.variant.overclocked";
        }
        return super.getMutation();
    }

    @Override
    public boolean getAdaptation() {
        return this.isAdapted();
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>();
        for (HitboxesForParts hitboxes : this.innatePartList) {
            HitboxesForParts part = this.calculateChance(hitboxes, 0.75f);
            if (part == null) continue;
            values.add(part);
        }
        return values;
    }

    private static class HindenMovementController
    extends MoveControl {
        private final Hinderburg mob;
        private int floatDuration;

        public HindenMovementController(Hinderburg mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.mob.getRandom().nextInt(4) + 2;
                Vec3 vec3 = new Vec3(this.wantedX - this.mob.getX(), this.wantedY - this.mob.getY(), this.wantedZ - this.mob.getZ());
                vec3 = vec3.normalize();
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(vec3.scale(0.1)));
            }
            if (this.operation == MoveControl.Operation.WAIT && !this.hasWanted() && this.mob.getTarget() == null) {
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, -0.01, 0.0));
            }
        }
    }

    private static class HindenLookControl
    extends LookControl {
        public HindenLookControl(Mob mob) {
            super(mob);
        }

        public void tick() {
            super.tick();
            if (this.mob.getTarget() == null) {
                if (this.mob.tickCount % 40 == 0) {
                    Vec3 vec3 = this.mob.getDeltaMovement();
                    this.mob.setYRot(-((float)Mth.atan2((double)vec3.x, (double)vec3.z)) * 57.295776f);
                    this.mob.yBodyRot = this.mob.getYRot();
                }
            } else {
                LivingEntity livingentity = this.mob.getTarget();
                if (livingentity.distanceToSqr((Entity)this.mob) < 4096.0) {
                    double d1 = livingentity.getX() - this.mob.getX();
                    double d2 = livingentity.getZ() - this.mob.getZ();
                    this.mob.setYRot(-((float)Mth.atan2((double)d1, (double)d2)) * 57.295776f);
                    this.mob.yBodyRot = this.mob.getYRot();
                }
            }
        }
    }
}

