/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.BaseEntities.HohlMultipart;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.MovementControls.UndergroundMovementControl;
import com.Harbinger.Spore.Sentities.MovementControls.UndergroundPathNavigation;
import com.Harbinger.Spore.Sentities.Projectile.ThrownTumor;
import com.Harbinger.Spore.Sentities.Projectile.VomitHohlBall;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.Sentities.Utility.CorpseEntity;
import com.Harbinger.Spore.core.SAttributes;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;

public class Hohlfresser
extends Calamity
implements TrueCalamity,
RangedAttackMob {
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.defineId(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> CHILD_ID = SynchedEntityData.defineId(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> VULNERABLE = SynchedEntityData.defineId(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> ADAPTED = SynchedEntityData.defineId(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> UNDERGROUND = SynchedEntityData.defineId(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> WORM_ANGLE = SynchedEntityData.defineId(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ORES = SynchedEntityData.defineId(Hohlfresser.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private float spin = 0.0f;
    private HohlMultipart[] parts = null;
    public final float[] ringBuffer = new float[64];
    public int ringBufferIndex = -1;
    public float prevWormAngle;
    private int ticksUnder;
    private static final Map<BlockState, Integer> cache = new WeakHashMap<BlockState, Integer>();
    public static final TagKey<Block> ORE_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"c:ores"));
    public static final int FLAG_MINEABLE = 1;
    public static final int FLAG_HARD = 2;
    public static final int FLAG_WRONG = 4;
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.HOHL_JAW, HitboxesForParts.HOHL_HEAD);
    private final List<HitboxesForParts> tailHitboxes = List.of(HitboxesForParts.HOHL_SEG1, HitboxesForParts.HOHL_SEG2, HitboxesForParts.HOHL_SEG3, HitboxesForParts.HOHL_TAIL);

    public Hohlfresser(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.moveControl = new UndergroundMovementControl((Mob)this);
        this.navigation = new UndergroundPathNavigation(this, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ADAPTED, (Object)false);
        builder.define(UNDERGROUND, (Object)false);
        builder.define(VULNERABLE, (Object)0);
        builder.define(CHILD_UUID, Optional.empty());
        builder.define(CHILD_ID, (Object)-1);
        builder.define(WORM_ANGLE, (Object)Float.valueOf(0.0f));
        builder.define(ORES, (Object)Float.valueOf(0.0f));
    }

    public float getSpin() {
        float speed = (float)Math.sqrt(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().z * this.getDeltaMovement().z);
        this.spin += speed * 2.5E-4f * (float)this.tickCount;
        return this.spin;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.hohl_loot.get();
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canGoUnderground() {
        return (Boolean)this.entityData.get(UNDERGROUND) == false && (Integer)this.entityData.get(VULNERABLE) <= 0;
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.hohl_dpsr.get();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("adaptation", ((Boolean)this.entityData.get(ADAPTED)).booleanValue());
        tag.putBoolean("underground", ((Boolean)this.entityData.get(UNDERGROUND)).booleanValue());
        tag.putInt("vulnerable", ((Integer)this.entityData.get(VULNERABLE)).intValue());
        tag.putFloat("ores", ((Float)this.entityData.get(ORES)).floatValue());
        if (this.getChildId() != null) {
            tag.putUUID("ChildUUID", this.getChildId());
        }
    }

    public boolean isInWall(LivingEntity mob) {
        float f = mob.getBbWidth() * 0.8f;
        AABB aabb = AABB.ofSize((Vec3)mob.getEyePosition().add(0.0, -0.05, 0.0), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.betweenClosedStream((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = mob.level().getBlockState(p_201942_);
            return !blockstate.isAir() && blockstate.isSuffocating((BlockGetter)mob.level(), p_201942_) && Shapes.joinIsNotEmpty((VoxelShape)blockstate.getCollisionShape((BlockGetter)mob.level(), p_201942_).move((double)p_201942_.getX(), (double)p_201942_.getY(), (double)p_201942_.getZ()), (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.AND);
        });
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(ADAPTED, (Object)tag.getBoolean("adaptation"));
        this.entityData.set(UNDERGROUND, (Object)tag.getBoolean("underground"));
        this.entityData.set(VULNERABLE, (Object)tag.getInt("vulnerable"));
        this.entityData.set(ORES, (Object)Float.valueOf(tag.getFloat("ores")));
        if (tag.hasUUID("ChildUUID")) {
            this.setChildId(tag.getUUID("ChildUUID"));
        }
    }

    @Override
    protected void grief(AABB aabb) {
        if (!this.isUnderground() && this.tickCount % 20 == 0) {
            AABB box;
            DamageSource source = this.getLastDamageSource();
            AABB aABB = box = source == null ? aabb : aabb.move(new Vec3(0.0, 1.0, 0.0));
            if (Math.random() < (double)0.2f) {
                this.handleDigIn();
            }
            super.grief(box);
        }
    }

    public boolean isUnderground() {
        return (Boolean)this.entityData.get(UNDERGROUND);
    }

    public void setUnderground(boolean val) {
        if (val) {
            this.playSound(Ssounds.WORM_DIGGING.get());
            this.ticksUnder = 40;
        } else {
            this.entityData.set(VULNERABLE, (Object)200);
        }
        this.entityData.set(UNDERGROUND, (Object)val);
        this.noPhysics = val;
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        return this.hurt(source, value);
    }

    public void setWormAngle(float angle) {
        this.entityData.set(WORM_ANGLE, (Object)Float.valueOf(angle));
    }

    public float getWormAngle() {
        return ((Float)this.entityData.get(WORM_ANGLE)).floatValue();
    }

    @Override
    public int chemicalRange() {
        return 16;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.hohl_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.hohl_debuffs.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.hohl_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.hohl_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.hohl_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(Attributes.STEP_HEIGHT, 2.0).add(SAttributes.TOXICITY, 0.0).add(SAttributes.REJUVENATION, 0.0).add(SAttributes.LOCALIZATION, 0.0).add(SAttributes.LACERATION, 0.0).add(SAttributes.CORROSIVES, 0.0).add(SAttributes.BALLISTIC, 0.0).add(SAttributes.GRINDING, 0.0);
    }

    public HohlMultipart[] getHolfParts() {
        return this.parts;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.entityData.get(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.entityData.set(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    private int getSegments() {
        return 5;
    }

    private boolean shouldReplaceParts() {
        if (this.parts == null || this.parts[0] == null) {
            return true;
        }
        for (int i = 0; i < this.getSegments(); ++i) {
            if (this.parts[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        this.prevWormAngle = this.getWormAngle();
        if (this.yRotO - this.getYRot() > 0.05f) {
            this.setWormAngle(this.getWormAngle() + 15.0f);
        } else if (this.yRotO - this.getYRot() < -0.05f) {
            this.setWormAngle(this.getWormAngle() - 15.0f);
        } else if (this.getWormAngle() > 0.0f) {
            this.setWormAngle(Math.max(this.getWormAngle() - 20.0f, 0.0f));
        } else if (this.getWormAngle() < 0.0f) {
            this.setWormAngle(Math.min(this.getWormAngle() + 20.0f, 0.0f));
        }
        if ((Integer)this.entityData.get(VULNERABLE) > 0) {
            this.entityData.set(VULNERABLE, (Object)((Integer)this.entityData.get(VULNERABLE) - 1));
        }
        if (!this.level().isClientSide) {
            int i;
            Entity child = this.getChild();
            if (child == null) {
                float size = 1.0f;
                TrueCalamity partParent = this;
                this.parts = new HohlMultipart[this.getSegments()];
                for (i = 0; i < this.getSegments(); ++i) {
                    HohlMultipart part = new HohlMultipart(Sentities.HOHLFRESSER_SEG.get(), this.level());
                    part.setPos(this.getX(), this.getY(), this.getZ());
                    part.setParent((Entity)partParent);
                    part.setSize(size -= 0.1f);
                    part.setColor(this.getMutationColor());
                    part.setVariant();
                    part.setIsTail(i == this.getSegments() - 1);
                    if (partParent == this) {
                        this.setChildId(part.getUUID());
                        this.entityData.set(CHILD_ID, (Object)part.getId());
                    }
                    if (partParent instanceof HohlMultipart) {
                        HohlMultipart partIndex = (HohlMultipart)partParent;
                        partIndex.setChildId(part.getUUID());
                    }
                    partParent = part;
                    this.level().addFreshEntity((Entity)part);
                    this.parts[i] = part;
                }
            }
            if (this.shouldReplaceParts() && this.getChild() instanceof HohlMultipart) {
                this.parts = new HohlMultipart[this.getSegments()];
                this.parts[0] = (HohlMultipart)this.getChild();
                this.entityData.set(CHILD_ID, (Object)this.parts[0].getId());
                for (int i2 = 1; i2 < this.parts.length && this.parts[i2 - 1].getChild() instanceof HohlMultipart; ++i2) {
                    this.parts[i2] = (HohlMultipart)this.parts[i2 - 1].getChild();
                }
            }
            Vec3 prev = this.position();
            float xRot = this.getXRot();
            for (i = 0; i < this.getSegments(); ++i) {
                if (this.parts[i] == null) continue;
                float yaw = this.getYawForPart(i);
                prev = this.parts[i].tickMultipartPosition(this.getId(), prev, xRot, this.getYRot(), yaw, true);
                xRot = this.parts[i].getXRot();
            }
        }
        if (this.isUnderground()) {
            this.handleUnearthing();
        }
        if (this.tickCount % 20 == 0) {
            this.handleDigIn();
        }
        if (this.ticksUnder > 0) {
            --this.ticksUnder;
        }
        if (this.tickCount % 20 == 0 && this.isMoving() && this.isUnderground() && this.getTarget() != null) {
            this.tryAndCrumbleBlocks();
        }
        if (this.tickCount % 80 == 0 && this.isUnderground() && this.isInWall((LivingEntity)this)) {
            this.playSound(Ssounds.WORM_DIGGING.get());
        }
        if (this.tickCount % 10 == 0) {
            this.handleShooting();
        }
    }

    void handleShooting() {
        LivingEntity living = this.getTarget();
        if (living != null && living.distanceToSqr((Entity)this) > 100.0 && this.hasSight((Entity)living)) {
            this.performRangedAttack(living, 0.0f);
        }
    }

    public boolean hasSight(Entity entity) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vec31 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        if (vec31.distanceTo(vec3) > 128.0) {
            return false;
        }
        return this.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    public float getOres() {
        return ((Float)this.entityData.get(ORES)).floatValue();
    }

    public void tryAndCrumbleBlocks() {
        ServerLevel serverLevel;
        if (this.level().isClientSide) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel && !this.checkForNearbyPlayers(serverLevel = (ServerLevel)level)) {
            return;
        }
        boolean canGrief = EventHooks.canEntityGrief((Level)this.level(), (Entity)this);
        if (!canGrief) {
            return;
        }
        AABB aabb = this.getBoundingBox().inflate(8.0);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            double speed;
            boolean canFall;
            BlockState state = this.level().getBlockState(blockpos);
            BlockState stateBelow = this.level().getBlockState(blockpos.below());
            boolean bl = canFall = stateBelow.isAir() || stateBelow.liquid();
            if (canFall && Math.random() < (double)0.01f && (speed = (double)state.getDestroySpeed((BlockGetter)this.level(), blockpos)) > 0.0 && speed <= (double)((Integer)SConfig.SERVER.calamity_bd.get()).intValue()) {
                this.level().removeBlock(blockpos, false);
                FallingBlockEntity.fall((Level)this.level(), (BlockPos)blockpos, (BlockState)state);
            }
            if ((state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.DIRT)) && Math.random() < 0.2) {
                this.level().setBlock(blockpos, Math.random() < 0.5 ? Blocks.DIRT.defaultBlockState() : Blocks.COARSE_DIRT.defaultBlockState(), 3);
            }
            if (!state.is(ORE_TAG) || !(Math.random() < (double)0.005f)) continue;
            this.entityData.set(ORES, (Object)Float.valueOf(((Float)this.entityData.get(ORES)).floatValue() + 1.0f));
            this.level().setBlock(blockpos, blockpos.getY() < 0 ? Blocks.COBBLED_DEEPSLATE.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState(), 3);
        }
    }

    private boolean checkForNearbyPlayers(ServerLevel serverLevel) {
        List playerList = serverLevel.getPlayers(p -> true);
        if (playerList.isEmpty()) {
            return false;
        }
        for (ServerPlayer player : playerList) {
            if (!(player.distanceTo((Entity)this) < 400.0f)) continue;
            return true;
        }
        return false;
    }

    public int analyzeBlock(BlockState state, BlockPos pos, Map<BlockState, Integer> cache) {
        return cache.computeIfAbsent(state, s -> {
            double hardness = s.getDestroySpeed((BlockGetter)this.level(), pos);
            if (hardness == -1.0) {
                return 6;
            }
            boolean isMineable = s.isAir() || s.canBeReplaced() || s.is(BlockTags.MINEABLE_WITH_SHOVEL) || s.is(BlockTags.MINEABLE_WITH_PICKAXE) || !s.isSolidRender((BlockGetter)this.level(), pos) || hardness == 0.0;
            boolean isHard = hardness > 3.0;
            boolean isWrong = !isMineable;
            int result = 0;
            if (isMineable) {
                result |= 1;
            }
            if (isHard) {
                result |= 2;
            }
            if (isWrong) {
                result |= 4;
            }
            return result;
        });
    }

    private boolean checkBlocksUnder() {
        AABB aabb = this.getBoundingBox().move(0.0, -0.6, 0.0);
        for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState state = this.level().getBlockState(pos);
            int result = this.analyzeBlock(state, pos, cache);
            if ((result & 2) != 0 || (result & 1) == 0) {
                return false;
            }
            BlockState aboveState = this.level().getBlockState(pos.above());
            int aboveResult = this.analyzeBlock(aboveState, pos.above(), cache);
            if ((aboveResult & 1) != 0 && (aboveResult & 2) == 0) continue;
            return false;
        }
        return true;
    }

    public void handleDigIn() {
        if (!this.isUnderground() && (Integer)this.entityData.get(VULNERABLE) <= 0) {
            boolean above;
            boolean tooDeep = (double)this.level().getMinBuildHeight() < this.getY() - 5.0;
            boolean below = this.moveControl.getWantedY() < this.getY();
            boolean bl = above = this.moveControl.getWantedY() > this.getY() + 1.0;
            if ((below || above) && this.checkBlocksUnder() && tooDeep) {
                this.setUnderground(true);
            }
        }
    }

    public void handleUnearthing() {
        AABB aabb = this.getBoundingBox().inflate(1.0, 1.4, 1.0);
        int airAmount = 0;
        boolean meetsHardBlock = false;
        boolean meetsWrongBlock = false;
        for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState state = this.level().getBlockState(pos);
            int result = this.analyzeBlock(state, pos, cache);
            if (this.level().canSeeSky(pos) && this.ticksUnder <= 0) {
                ++airAmount;
            }
            if ((result & 4) != 0) {
                meetsWrongBlock = true;
                break;
            }
            if ((result & 2) == 0) continue;
            meetsHardBlock = true;
            break;
        }
        if (airAmount >= 4 || meetsHardBlock || meetsWrongBlock) {
            this.setUnderground(false);
        }
    }

    private float getYawForPart(int i) {
        return this.getRingBuffer(4 + i * 2, 1.0f);
    }

    public float getRingBuffer(int bufferOffset, float partialTicks) {
        if (this.isDeadOrDying()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - bufferOffset & 0x3F;
        int j = this.ringBufferIndex - bufferOffset - 1 & 0x3F;
        float d0 = this.ringBuffer[i];
        float d1 = this.ringBuffer[j] - d0;
        return Mth.wrapDegrees((float)(d0 + d1 * partialTicks));
    }

    public boolean isMoving() {
        return Math.sqrt(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().z * this.getDeltaMovement().z) > 0.0;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.FALL);
    }

    @Override
    public void registerGoals() {
        this.goalSelector.addGoal(4, (Goal)new HohlChargeGoal(this, 0.5, 300, 100.0f));
        this.goalSelector.addGoal(5, (Goal)new HohlfresserMeleeAttack(this, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.goalSelector.addGoal(6, (Goal)new CalamityInfectedCommand(this));
        this.goalSelector.addGoal(7, (Goal)new SummonScentInCombat(this));
        this.goalSelector.addGoal(8, (Goal)new SporeBurstSupport(this));
        super.registerGoals();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    private boolean checkVectorForSeeing(Entity target) {
        Vec3 startVec = this.position();
        Vec3 endVec = target.position();
        Vec3 direction = endVec.subtract(startVec).normalize();
        double distance = startVec.distanceTo(endVec);
        for (double i = 0.0; i <= distance; i += 0.5) {
            Vec3 current = startVec.add(direction.scale(i));
            BlockPos pos = BlockPos.containing((Position)current);
            BlockState state = this.level().getBlockState(pos);
            int result = this.analyzeBlock(state, pos, cache);
            if ((result & 2) == 0 && (result & 1) != 0) continue;
            return false;
        }
        return true;
    }

    public boolean hasLineOfSight(Entity entity) {
        if (this.getSearchArea() == BlockPos.ZERO) {
            if (this.isInWater()) {
                return true;
            }
            return this.checkVectorForSeeing(entity) || super.hasLineOfSight(entity);
        }
        return super.hasLineOfSight(entity);
    }

    public int getShootingAmount() {
        AttributeInstance instance = this.getAttribute(SAttributes.BALLISTIC);
        if (instance != null && instance.getValue() > 0.0) {
            int value = (int)(instance.getValue() * 3.0);
            return this.random.nextInt(value + 1);
        }
        return 1;
    }

    public void performRangedAttack(LivingEntity livingEntity, float v) {
        if (Math.random() < (double)0.1f) {
            for (int i = 0; i < this.getShootingAmount(); ++i) {
                this.shootTumor(livingEntity);
            }
        } else {
            float extraDamage = (float)((Double)SConfig.SERVER.hohl_r_damage.get() + (double)(this.getOres() * 0.2f));
            double maxDamage = (Double)SConfig.SERVER.hohl_damage.get() / 2.0;
            double damage = maxDamage <= (double)extraDamage ? maxDamage : (double)extraDamage;
            VomitHohlBall.shoot((LivingEntity)this, livingEntity, (float)damage, this.getOres() > 0.0f, this.getKills() > 0);
        }
    }

    void shootTumor(LivingEntity livingEntity) {
        if (this.level().isClientSide) {
            return;
        }
        ThrownTumor tumor = new ThrownTumor(this.level(), (LivingEntity)this);
        double dx = livingEntity.getX() - this.getX();
        double dy = livingEntity.getY() + (double)livingEntity.getEyeHeight();
        double dz = livingEntity.getZ() - this.getZ();
        tumor.setExplode(Level.ExplosionInteraction.MOB);
        tumor.shoot(dx, dy - tumor.getY() + Math.hypot(dx, dz) * (double)0.05f, dz, 1.0f, 12.0f);
        this.level().addFreshEntity((Entity)tumor);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        this.playSound(Ssounds.SIEGER_BITE.get());
        return super.doHurtTarget(entity);
    }

    protected void onEffectAdded(MobEffectInstance instance, @Nullable Entity source) {
        super.onEffectAdded(instance, source);
        HohlMultipart[] parts = this.getHolfParts();
        if (parts == null) {
            return;
        }
        for (HohlMultipart part : parts) {
            if (part == null) {
                return;
            }
            MobEffectInstance existing = part.getEffect(instance.getEffect());
            if (existing != null && existing.getDuration() >= instance.getDuration() - 5) continue;
            part.addEffect(new MobEffectInstance(instance));
        }
    }

    protected void onEffectRemoved(MobEffectInstance instance) {
        super.onEffectRemoved(instance);
        if (this.getHolfParts() == null) {
            return;
        }
        for (HohlMultipart hohlMultipart : this.getHolfParts()) {
            if (hohlMultipart == null) {
                return;
            }
            hohlMultipart.removeEffect(instance.getEffect());
        }
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.HOHL_AMBIENT.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.RAVAGER_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>(this.innatePartList);
        if (this.getHolfParts() != null) {
            for (HohlMultipart multipart : this.getHolfParts()) {
                values.add(this.CalculateParts(multipart));
            }
        }
        return values;
    }

    @Override
    public void summonCorpsePart(int partCount, List<List<ItemStack>> distributedLoot, List<HitboxesForParts> partList) {
        AtomicInteger index = new AtomicInteger();
        for (int i = 0; i < partCount; ++i) {
            CorpseEntity partEntity = new CorpseEntity(Sentities.CORPSE_PIECE.get(), this.level());
            for (ItemStack stack : distributedLoot.get(i)) {
                partEntity.addToInventory(stack);
            }
            partEntity.setColor(this.getMutationColor());
            partEntity.moveTo(this.calculateSegmentsPosition(i - 2));
            partEntity.setDeltaMovement(new Vec3((this.random.nextDouble() - this.random.nextDouble()) * 0.9, this.random.nextDouble() * 0.6 + 0.3, (this.random.nextDouble() - this.random.nextDouble()) * 0.9));
            partEntity.setOwnerAda(this.getAdaptation());
            partEntity.setCorpseType(partList.get(i).getID());
            partEntity.setInflation(this.tryToFindInflation(index.get(), partList.get(i).getID(), index::getAndIncrement));
            this.level().addFreshEntity((Entity)partEntity);
        }
    }

    private Vec3 calculateSegmentsPosition(int value) {
        if (value < 0 || this.getHolfParts() == null || this.getHolfParts().length < value) {
            return this.position();
        }
        return this.getHolfParts()[value].position();
    }

    public float tryToFindInflation(int startPoint, int ID, Runnable runnable) {
        if (this.getHolfParts() == null) {
            return 1.0f;
        }
        int length = this.getHolfParts().length;
        if (length < startPoint) {
            return 1.0f;
        }
        if (this.tailHitboxes.contains((Object)HitboxesForParts.byId(ID))) {
            HohlMultipart multipart = this.getHolfParts()[startPoint];
            return multipart == null ? 1.0f : multipart.getSize();
        }
        runnable.run();
        return 1.0f;
    }

    private HitboxesForParts CalculateParts(HohlMultipart hohlMultipart) {
        if (hohlMultipart.isTail()) {
            return HitboxesForParts.HOHL_TAIL;
        }
        if (hohlMultipart.getSegmentVariant() == HohlMultipart.SegmentVariants.MELEE) {
            return HitboxesForParts.HOHL_SEG2;
        }
        if (hohlMultipart.getSegmentVariant() == HohlMultipart.SegmentVariants.ORGAN) {
            return HitboxesForParts.HOHL_SEG3;
        }
        return HitboxesForParts.HOHL_SEG1;
    }

    static class HohlChargeGoal
    extends Goal {
        private final Hohlfresser mob;
        private final double speed;
        private final int chargeDelay;
        private int chargeTimer = 0;
        private final float distance;

        HohlChargeGoal(Hohlfresser mob, double speed, int chargeDelay, float distance) {
            this.mob = mob;
            this.speed = speed;
            this.chargeDelay = chargeDelay;
            this.distance = distance;
        }

        public boolean canUse() {
            LivingEntity target = this.mob.getTarget();
            if (target == null || !target.isAlive()) {
                this.chargeTimer = 0;
                return false;
            }
            if (this.chargeTimer < this.chargeDelay) {
                ++this.chargeTimer;
                return false;
            }
            if (this.checkVectorForCharging((Entity)target)) {
                return true;
            }
            this.chargeTimer = 0;
            return false;
        }

        boolean jump(LivingEntity us, LivingEntity target) {
            return target.level().canSeeSky(target.getOnPos()) && us.level().canSeeSky(us.getOnPos());
        }

        public void start() {
            LivingEntity target = this.mob.getTarget();
            if (target != null && target.distanceTo((Entity)this.mob) < this.distance) {
                this.mob.setUnderground(true);
                Vec3 direction = target.position().subtract(this.mob.position());
                if (direction.lengthSqr() > 1.0E-7) {
                    direction.normalize();
                }
                if (this.jump((LivingEntity)this.mob, target)) {
                    direction.add(new Vec3(0.0, 0.3, 0.0));
                }
                this.mob.setDeltaMovement(direction.scale(this.speed));
            }
            this.chargeTimer = 0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        private boolean checkVectorForCharging(Entity target) {
            HashMap<BlockState, Integer> cache = new HashMap<BlockState, Integer>();
            Vec3 startVec = this.mob.position();
            Vec3 endVec = target.position();
            Vec3 direction = endVec.subtract(startVec).normalize();
            double distance = startVec.distanceTo(endVec);
            for (double i = 0.0; i <= distance; i += 0.5) {
                Vec3 current = startVec.add(direction.scale(i));
                BlockPos pos = BlockPos.containing((Position)current);
                BlockState state = this.mob.level().getBlockState(pos);
                int result = this.mob.analyzeBlock(state, pos, cache);
                if ((result & 2) == 0 && (result & 1) != 0) continue;
                return false;
            }
            return true;
        }
    }

    static class HohlfresserMeleeAttack
    extends AOEMeleeAttackGoal {
        public HohlfresserMeleeAttack(Hohlfresser mob, Predicate<LivingEntity> targets) {
            super(mob, 1.5, false, 2.5, 6.0f, targets);
        }

        @Override
        protected double getAttackReachSqr(LivingEntity entity) {
            float f = this.mob.getBbWidth();
            return f * 1.5f * f + entity.getBbWidth();
        }
    }
}

