/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.AI.LeapGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.FallenMultipart.HowitzerArm;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.Projectile.FleshBomb;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.Sentities.Utility.NukeEntity;
import com.Harbinger.Spore.core.SAttributes;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class Howitzer
extends Calamity
implements TrueCalamity,
RangedAttackMob {
    public static final EntityDataAccessor<Float> RIGHT_ARM = SynchedEntityData.defineId(Howitzer.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> LEFT_ARM = SynchedEntityData.defineId(Howitzer.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> ORES = SynchedEntityData.defineId(Howitzer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> NUKE = SynchedEntityData.defineId(Howitzer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> SELF_DETONATION = SynchedEntityData.defineId(Howitzer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final CalamityMultipart[] subEntities;
    public final CalamityMultipart rightArm;
    public final CalamityMultipart leftArm;
    public final CalamityMultipart mouth;
    public int getLeapTime = 0;
    @Nullable
    private BlockPos Targetpos;
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.HOWI_CANNON1, HitboxesForParts.HOWI_CANNON2, HitboxesForParts.HOWI_CANNON3, HitboxesForParts.HOWI_LEFT_LEG, HitboxesForParts.HOWI_RIGHT_LEG, HitboxesForParts.HOWI_SACK);

    public Howitzer(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.rightArm = new CalamityMultipart(this, "rightarm", 2.0f, 4.0f);
        this.leftArm = new CalamityMultipart(this, "leftarm", 2.0f, 4.0f);
        this.mouth = new CalamityMultipart(this, "mouth", 4.0f, 3.0f);
        this.subEntities = new CalamityMultipart[]{this.rightArm, this.leftArm, this.mouth};
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public void setId(int p_20235_) {
        super.setId(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(p_20235_ + i + 1);
        }
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.howit_dpsr.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.howit_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.howit_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.howit_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 128.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.5).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(SAttributes.TOXICITY, 0.0).add(SAttributes.REJUVENATION, 0.0).add(SAttributes.LOCALIZATION, 0.0).add(SAttributes.LACERATION, 0.0).add(SAttributes.CORROSIVES, 0.0).add(SAttributes.BALLISTIC, 0.0).add(SAttributes.GRINDING, 0.0);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        this.playSound(Ssounds.LANDING.get(), 0.5f, 0.5f);
        return super.doHurtTarget(entity);
    }

    @Override
    public void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new LeapGoal((Mob)this, 0.9f){

            @Override
            public boolean canUse() {
                return Howitzer.this.getGetLeapTime() <= 0 && Howitzer.this.hasBothArms() && Howitzer.this.isInMeleeRange() && super.canUse();
            }

            @Override
            public void start() {
                super.start();
                Howitzer.this.setLeapTicks(200);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new AOEMeleeAttackGoal(this, 1.0, true, 2.0, 5.0f, e -> this.TARGET_SELECTOR.test(e)){

            @Override
            public boolean canUse() {
                return Howitzer.this.isInMeleeRange() && super.canUse();
            }

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                float f = Howitzer.this.getBbWidth();
                return f * 1.5f * f * 1.5f + entity.getBbWidth();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new HowitzerRangedAttackGoal(this, 1.0, 80, 64.0f, 1, 5){

            @Override
            public boolean canUse() {
                return !Howitzer.this.isInMeleeRange() && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(5, (Goal)new SearchAroundGoal(this));
        this.goalSelector.addGoal(6, (Goal)new FloatDiveGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new CalamityInfectedCommand(this));
        this.goalSelector.addGoal(7, (Goal)new SummonScentInCombat(this));
        this.goalSelector.addGoal(8, (Goal)new SporeBurstSupport(this));
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void aiStep() {
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].getX(), this.subEntities[j].getY(), this.subEntities[j].getZ());
        }
        this.tickPart(this.mouth, Vec3.ZERO, 5.0);
        if (this.getRightArmHp() > 0.0f) {
            this.tickPart(this.rightArm, new Vec3(-3.85, 0.0, 4.0));
        } else {
            this.tickPart(this.rightArm, Vec3.ZERO);
            this.rightArm.getBoundingBox().inflate(1.0, 0.3, 1.0);
        }
        if (this.getLeftArmHp() > 0.0f) {
            this.tickPart(this.leftArm, new Vec3(3.85, 0.0, -4.0));
        } else {
            this.tickPart(this.leftArm, Vec3.ZERO);
            this.leftArm.getBoundingBox().inflate(1.0, 0.3, 1.0);
        }
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].xo = avec3[l].x;
            this.subEntities[l].yo = avec3[l].y;
            this.subEntities[l].zo = avec3[l].z;
            this.subEntities[l].xOld = avec3[l].x;
            this.subEntities[l].yOld = avec3[l].y;
            this.subEntities[l].zOld = avec3[l].z;
        }
        super.aiStep();
    }

    public void tickDetonation() {
        if ((Integer)this.entityData.get(SELF_DETONATION) >= 30) {
            NukeEntity nukeEntity = new NukeEntity(Sentities.NUKE.get(), this.level());
            nukeEntity.setInitRange(3.0f);
            nukeEntity.setRange((float)((Double)SConfig.SERVER.nuke_range.get() * 2.0));
            nukeEntity.setInitDuration(0);
            nukeEntity.setDuration((Integer)SConfig.SERVER.nuke_time.get());
            nukeEntity.setDamage((float)((Double)SConfig.SERVER.nuke_damage.get() * 1.0));
            nukeEntity.livingEntityPredicate = this.TARGET_SELECTOR;
            nukeEntity.setPos(this.getX(), this.getY(), this.getZ());
            this.level().addFreshEntity((Entity)nukeEntity);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Utilities.explodeCircle(serverLevel, (Entity)this, this.getOnPos(), 15.0, (float)((Double)SConfig.SERVER.howit_damage.get() * 1.0), 8.0, entity -> {
                    LivingEntity livingEntity;
                    return entity instanceof LivingEntity && this.TARGET_SELECTOR.test(livingEntity = (LivingEntity)entity);
                });
            }
            this.discard();
        } else {
            this.entityData.set(SELF_DETONATION, (Object)((Integer)this.entityData.get(SELF_DETONATION) + 1));
        }
    }

    public int getSelfDetonation() {
        return (Integer)this.entityData.get(SELF_DETONATION);
    }

    public boolean hasBothArms() {
        return this.getRightArmHp() > 0.0f && this.getLeftArmHp() > 0.0f;
    }

    public boolean isInMeleeRange() {
        LivingEntity living = this.getTarget();
        return living != null && this.distanceToSqr((Entity)living) < 200.0;
    }

    public int getGetLeapTime() {
        return this.getLeapTime;
    }

    public void setLeapTicks(int i) {
        this.getLeapTime = i;
    }

    public CalamityMultipart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket entityPacket) {
        super.recreateFromPacket(entityPacket);
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        if (calamityMultipart == this.mouth) {
            this.hurt(source, value * 2.0f);
        } else if (calamityMultipart == this.rightArm) {
            this.hurt(source, value * 1.5f);
            float lostHealth = this.getRightArmHp() - this.getDamageAfterArmorAbsorb(source, value);
            this.setRightArmHp(lostHealth > 0.0f ? lostHealth : (this.getRightArmHp() != 0.0f ? this.summonDetashedPart(true) : 0.0f));
        } else if (calamityMultipart == this.leftArm) {
            this.hurt(source, value * 1.5f);
            float lostHealth = this.getLeftArmHp() - this.getDamageAfterArmorAbsorb(source, value);
            this.setLeftArmHp(lostHealth > 0.0f ? lostHealth : (this.getLeftArmHp() != 0.0f ? this.summonDetashedPart(false) : 0.0f));
        } else {
            this.hurt(source, value);
        }
        return true;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() != null && this.random.nextFloat() < 0.2f) {
            this.setTarget(null);
        }
        if (source.is(DamageTypes.FREEZE)) {
            this.entityData.set(NUKE, (Object)0);
        }
        if (this.getHealth() <= 50.0f && this.isRadioactive() && this.getSelfDetonation() <= 0) {
            this.tickDetonation();
        }
        return super.hurt(source, amount);
    }

    @Override
    public int chemicalRange() {
        return 16;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.howit_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.howit_debuffs.get();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RIGHT_ARM, (Object)Float.valueOf(this.getMaxArmHp()));
        builder.define(LEFT_ARM, (Object)Float.valueOf(this.getMaxArmHp()));
        builder.define(ORES, (Object)0);
        builder.define(NUKE, (Object)0);
        builder.define(SELF_DETONATION, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("right_arm", ((Float)this.entityData.get(RIGHT_ARM)).floatValue());
        tag.putFloat("left_arm", ((Float)this.entityData.get(LEFT_ARM)).floatValue());
        tag.putInt("ores", ((Integer)this.entityData.get(ORES)).intValue());
        tag.putInt("nuke", ((Integer)this.entityData.get(NUKE)).intValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(RIGHT_ARM, (Object)Float.valueOf(tag.getFloat("right_arm")));
        this.entityData.set(LEFT_ARM, (Object)Float.valueOf(tag.getFloat("left_arm")));
        this.entityData.set(ORES, (Object)tag.getInt("ores"));
        this.entityData.set(NUKE, (Object)tag.getInt("nuke"));
    }

    public float getRightArmHp() {
        return ((Float)this.entityData.get(RIGHT_ARM)).floatValue();
    }

    public void setRightArmHp(float i) {
        this.entityData.set(RIGHT_ARM, (Object)Float.valueOf(i));
    }

    public float getLeftArmHp() {
        return ((Float)this.entityData.get(LEFT_ARM)).floatValue();
    }

    public void setLeftArmHp(float i) {
        this.entityData.set(LEFT_ARM, (Object)Float.valueOf(i));
    }

    public float getMaxArmHp() {
        return (float)((Double)SConfig.SERVER.howit_hp.get() / 4.0);
    }

    public boolean hasLineOfSight(Entity entity) {
        if (this.canEntitySeeTheSky(entity) || entity.distanceToSqr((Entity)this) < 200.0) {
            return true;
        }
        return super.hasLineOfSight(entity);
    }

    private boolean canEntitySeeTheSky(Entity entity) {
        return entity.level().canSeeSky(entity.getOnPos());
    }

    @Override
    protected int calculateFallDamage(float p_149389_, float p_149390_) {
        if (this.getLeapTime > 140) {
            this.damageStomp(this.level(), this.getOnPos(), 12.0, 8.0);
        }
        return super.calculateFallDamage(p_149389_, p_149390_) - 25;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getGetLeapTime() > 0) {
            --this.getLeapTime;
        }
        if (this.tickCount % 20 == 0 && this.getHealth() == this.getMaxHealth()) {
            if (this.getRightArmHp() < this.getMaxArmHp()) {
                this.setRightArmHp(this.getRightArmHp() + 1.0f);
            }
            if (this.getLeftArmHp() < this.getMaxArmHp()) {
                this.setLeftArmHp(this.getLeftArmHp() + 1.0f);
            }
        }
        if (this.tickCount % 20 == 0) {
            this.createBomb();
            if (this.isRadioactive()) {
                this.spreadRadiation();
            }
        }
        if (this.tickCount % 200 == 0) {
            this.searchBlocks();
        }
        if (this.isRadioactive() && this.getSelfDetonation() > 0) {
            if (!this.level().isClientSide && this.tickCount % 20 == 0) {
                this.tickDetonation();
            }
            for (int i = 0; i < 360; ++i) {
                if (i % 40 != 0) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + 2.0, this.getZ(), Math.cos(i) * 0.25, 0.25, Math.sin(i) * 0.25);
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + 2.0, this.getZ(), Math.sin(i) * 0.25, -0.25, Math.cos(i) * 0.25);
            }
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.howit_loot.get();
    }

    public float summonDetashedPart(boolean isRight) {
        double offset = isRight ? 3.0 : -3.0;
        Vec3 vec3 = new Vec3(0.0, 0.0, offset).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
        HowitzerArm arm = new HowitzerArm(Sentities.HOWIT_ARM.get(), this.level());
        arm.setRight(isRight);
        arm.setNuclear(this.isRadioactive());
        arm.moveTo(this.getX() + vec3.x, this.getY() + 1.6, this.getZ() + vec3.z);
        this.level().addFreshEntity((Entity)arm);
        this.playSound(Ssounds.LIMB_SLASH.get());
        return 0.0f;
    }

    protected void damageStomp(Level level, BlockPos pos, double range, double damageRange) {
        AABB aabb = this.getBoundingBox().inflate(damageRange);
        List entities = level.getEntities((Entity)this, aabb, entity -> {
            LivingEntity living;
            return entity instanceof LivingEntity && this.TARGET_SELECTOR.test(living = (LivingEntity)entity);
        });
        int i = 0;
        while ((double)i <= 2.0 * range) {
            int j = 0;
            while ((double)j <= 2.0 * range) {
                int k = 0;
                while ((double)k <= 2.0 * range) {
                    double distance = Mth.sqrt((float)((float)(((double)i - range) * ((double)i - range) + ((double)j - range) * ((double)j - range) + ((double)k - range) * ((double)k - range))));
                    if ((Math.abs(i) != 2 || Math.abs(j) != 2 || Math.abs(k) != 2) && distance < range + 0.5) {
                        BlockPos blockpos = pos.offset(i - (int)range, j - (int)range, k - (int)range);
                        BlockState state = level.getBlockState(blockpos);
                        boolean airBelow = level.getBlockState(blockpos.below()).isAir();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            if (airBelow && state.getDestroySpeed((BlockGetter)level, pos) >= 0.0f && Math.random() < 0.3) {
                                FallingBlockEntity.fall((Level)serverLevel, (BlockPos)blockpos, (BlockState)state);
                                serverLevel.removeBlock(blockpos, false);
                            }
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            for (int i2 = 0; i2 < 2; ++i2) {
                this.doHurtTarget((Entity)living);
                living.hurtTime = 0;
                living.invulnerableTime = 0;
            }
        }
        this.playSound(Ssounds.LANDING.get());
    }

    private FleshBomb.BombType compareEntity(LivingEntity living, int burnable) {
        AABB aabb = living.getBoundingBox().inflate(4.0);
        List extra_targets = this.level().getEntities((Entity)living, aabb, entity -> {
            LivingEntity livingEntity;
            return entity instanceof LivingEntity && this.TARGET_SELECTOR.test(livingEntity = (LivingEntity)entity);
        });
        if (this.isRadioactive() && this.hasNuke() && (living.getMaxHealth() >= 100.0f || living.getArmorValue() >= 20)) {
            this.entityData.set(NUKE, (Object)0);
            return FleshBomb.BombType.NUCLEAR;
        }
        if (burnable > 8) {
            return Math.random() < (double)0.3f ? FleshBomb.BombType.BILE : FleshBomb.BombType.FLAME;
        }
        if (((List)SConfig.SERVER.corrosion.get()).contains(living.getEncodeId())) {
            return FleshBomb.BombType.ACID;
        }
        if (extra_targets.size() > 1 || living.getArmorValue() >= 10) {
            return FleshBomb.BombType.BILE;
        }
        return FleshBomb.BombType.BASIC;
    }

    public boolean isRadioactive() {
        return (Integer)this.entityData.get(ORES) >= 100;
    }

    @Override
    public void ActivateAdaptation() {
        super.ActivateAdaptation();
        this.entityData.set(ORES, (Object)100);
    }

    public void performRangedAttack(LivingEntity entity, float val) {
        float damage = (float)((Double)SConfig.SERVER.howit_ranged_damage.get() * (Double)SConfig.SERVER.global_damage.get());
        FleshBomb bomb = new FleshBomb(this.level(), (LivingEntity)this, damage, this.compareEntity(entity, (int)val), this.random.nextInt(4, 7));
        bomb.setLivingEntityPredicate(this.TARGET_SELECTOR);
        bomb.setCarrier(Math.random() < (double)0.2f);
        bomb.setTarget((Entity)entity);
        double dx = entity.getX() - this.getX();
        double dz = entity.getZ() - this.getZ();
        double dy = entity.getY() - this.getY();
        float value = this.random.nextFloat() * 0.5f;
        bomb.moveTo(this.getX() + (double)value, this.getY() + 7.0, this.getZ() + (double)value);
        bomb.shoot(dx * (double)0.085f, 6.5 + Math.hypot(dx, dz) * (double)0.02f + (dy > 0.0 ? dy : 0.0), dz * (double)0.085f, 2.0f, 14.0f);
        this.level().addFreshEntity((Entity)bomb);
        this.playSound(Ssounds.FALLING_BOMB.get());
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.HOWITZER_AMBIENT.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.RAVAGER_STEP;
    }

    @Override
    protected void grief(AABB aabb) {
        boolean flag = false;
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (Utilities.biomass().contains(blockstate)) {
                flag = this.level().setBlock(blockpos, ((Block)Sblocks.MEMBRANE_BLOCK.get()).defaultBlockState(), 3) || flag;
                this.breakCounter = 0;
                continue;
            }
            if (!(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) < (float)this.getDestroySpeed()) || !(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) >= 0.0f) || !EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) continue;
            if (blockstate.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"c:ores")))) {
                this.entityData.set(ORES, (Object)((Integer)this.entityData.get(ORES) + 1));
            }
            flag = this.level().destroyBlock(blockpos, false, (Entity)this) || flag;
            this.breakCounter = 0;
        }
    }

    public boolean hasLineOfSightBlocks(BlockPos pos) {
        BlockHitResult raytraceresult = this.level().clip(new ClipContext(this.getEyePosition(1.0f), new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockPos position = raytraceresult.getBlockPos();
        return pos.equals((Object)position) || this.level().isEmptyBlock(pos) || this.level().getBlockEntity(pos) == this.level().getBlockEntity(position);
    }

    public void searchBlocks() {
        AABB aabb = this.getBoundingBox().inflate(32.0, 4.0, 32.0);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState block = this.level().getBlockState(blockpos);
            if (!block.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"c:ores"))) || !this.hasLineOfSightBlocks(blockpos) || !(this.random.nextFloat() < 0.5f)) continue;
            this.setTargetPos(blockpos);
            break;
        }
    }

    @Nullable
    private BlockPos getTargetPos() {
        return this.Targetpos;
    }

    public void setTargetPos(@Nullable BlockPos pos) {
        this.Targetpos = pos;
    }

    public boolean hasNuke() {
        return (Integer)this.entityData.get(NUKE) > 60;
    }

    protected void createBomb() {
        if (this.isRadioactive() && !this.hasNuke()) {
            this.entityData.set(NUKE, (Object)((Integer)this.entityData.get(NUKE) + 1));
        }
    }

    @Override
    public String getMutation() {
        if (this.isRadioactive()) {
            return "spore.entity.variant.irradiated";
        }
        return super.getMutation();
    }

    public void spreadRadiation() {
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(12.0));
        for (Entity entity : entities) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || !this.TARGET_SELECTOR.test(living = (LivingEntity)entity)) continue;
            this.addEffect(living);
        }
    }

    public void addEffect(LivingEntity living) {
        if (ModList.get().isLoaded("alexscaves")) {
            Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)"alexscaves:irradiated"));
            if (effect != null) {
                living.addEffect(new MobEffectInstance(effect, 400, 0));
            }
        } else {
            living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 400, 0));
        }
    }

    @Override
    public boolean getAdaptation() {
        return this.isRadioactive();
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>();
        if (this.getRightArmHp() > 0.0f) {
            values.add(HitboxesForParts.HOWI_RIGHT_ARM);
        }
        if (this.getLeftArmHp() > 0.0f) {
            values.add(HitboxesForParts.HOWI_LEFT_ARM);
        }
        for (HitboxesForParts hitboxes : this.innatePartList) {
            HitboxesForParts part = this.calculateChance(hitboxes, 0.65f);
            if (part == null) continue;
            values.add(part);
        }
        return values;
    }

    public static class SearchAroundGoal
    extends Goal {
        private final Howitzer howitzer;
        public int tryTicks;

        public SearchAroundGoal(Howitzer specter) {
            this.howitzer = specter;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.howitzer.getTargetPos() != null && this.howitzer.getTarget() == null;
        }

        protected void moveToBlock(BlockPos pos) {
            if (pos != null) {
                this.howitzer.navigation.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 1.0);
            }
        }

        public void start() {
            this.moveToBlock(this.howitzer.getTargetPos());
            this.tryTicks = 0;
            super.start();
        }

        public boolean canContinueToUse() {
            return this.howitzer.getTarget() == null;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            super.tick();
            ++this.tryTicks;
            BlockPos pos = this.howitzer.getTargetPos();
            if (pos != null && this.shouldRecalculatePath()) {
                this.moveToBlock(pos);
            }
            if (pos != null && pos.closerToCenterThan((Position)this.howitzer.position(), 7.0)) {
                this.howitzer.level().destroyBlock(pos, false, (Entity)this.howitzer);
                this.howitzer.entityData.set(ORES, (Object)((Integer)this.howitzer.entityData.get(ORES) + 1));
                this.howitzer.setTargetPos(null);
                this.howitzer.searchBlocks();
            }
        }
    }

    public static class HowitzerRangedAttackGoal
    extends ScatterShotRangedGoal {
        public HowitzerRangedAttackGoal(RangedAttackMob mob, double speed, int interval, float range, int min, int max) {
            super(mob, speed, interval, range, min, max);
        }

        private int getBurnable(LivingEntity target) {
            AABB aabb = target.getBoundingBox().inflate(4.0);
            ArrayList<BlockPos> burnable_material = new ArrayList<BlockPos>();
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
                if (!this.mob.level().getBlockState(blockpos).isFlammable((BlockGetter)this.mob.level(), blockpos, Direction.UP)) continue;
                burnable_material.add(blockpos);
            }
            return burnable_material.size();
        }

        @Override
        public void tick() {
            double d0 = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
            boolean flag = this.mob.getSensing().hasLineOfSight((Entity)this.target);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.mob.getNavigation().stop();
            } else {
                this.mob.getNavigation().moveTo((Entity)this.target, this.speedModifier);
            }
            this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            if (--this.attackTime == 0) {
                if (!flag) {
                    return;
                }
                RandomSource randomSource = RandomSource.create();
                int shot = randomSource.nextInt(this.minShots, this.maxShots + this.getExtraShots());
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = this.getBurnable(this.target);
                for (int i = 0; i < shot; ++i) {
                    this.rangedAttackMob.performRangedAttack(this.target, f1);
                }
                this.attackTime = Mth.floor((float)(f * (float)this.attackInterval + (float)this.attackInterval));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackInterval, (double)this.attackInterval));
            }
        }
    }
}

