/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.FallenMultipart.SiegerTail;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.Projectile.ThrownTumor;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.core.SAttributes;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public class Sieger
extends Calamity
implements RangedAttackMob,
TrueCalamity {
    public static final EntityDataAccessor<Float> TAIL_HP = SynchedEntityData.defineId(Sieger.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> ADAPTATION = SynchedEntityData.defineId(Sieger.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final CalamityMultipart[] subEntities;
    public final CalamityMultipart lowerbody;
    public final CalamityMultipart head;
    public final CalamityMultipart tail;
    public final CalamityMultipart tail2;
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.SIEGER_BODY, HitboxesForParts.SIEGER_JAW, HitboxesForParts.SIEGER_RIGHT_LEG, HitboxesForParts.SIEGER_LEFT_LEG, HitboxesForParts.SIEGER_BACK_RIGHT_LEG, HitboxesForParts.SIEGER_BACK_LEFT_LEG);

    public Sieger(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.lowerbody = new CalamityMultipart(this, "lowerbody", 3.0f, 3.0f);
        this.tail = new CalamityMultipart(this, "tail", 1.5f, 1.5f);
        this.tail2 = new CalamityMultipart(this, "tail", 1.5f, 1.5f);
        this.head = new CalamityMultipart(this, "head", 1.4f, 1.4f);
        this.subEntities = new CalamityMultipart[]{this.lowerbody, this.tail, this.tail2, this.head};
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.sieger_loot.get();
    }

    public void setId(int p_20235_) {
        super.setId(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(p_20235_ + i + 1);
        }
    }

    @Override
    public double setInflation() {
        return 1.0;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getHealth() >= this.getMaxHealth() && this.getTailHp() < this.getMaxTailHp() && this.tickCount % 40 == 0) {
            this.setTailHp(this.getTailHp() + 1.0f);
        }
        if (this.tickCount % 20 == 0 && this.getHealth() < this.getMaxHealth()) {
            this.entityData.set(ADAPTATION, (Object)((Integer)this.entityData.get(ADAPTATION) + 1));
        }
    }

    public void aiStep() {
        float f14 = this.getYRot() * ((float)Math.PI / 180);
        float f2 = Mth.sin((float)f14);
        float f15 = Mth.cos((float)f14);
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].getX(), this.subEntities[j].getY(), this.subEntities[j].getZ());
        }
        if (this.getTailHp() > 0.0f) {
            this.tickPart(this.tail, new Vec3(-1.5, 7.0, 0.0));
        } else {
            this.tickPart(this.tail, f2 * 2.0f, 1.0, -f15 * 2.0f);
        }
        if (this.getTailHp() > 0.0f) {
            this.tickPart(this.tail2, new Vec3(-3.0, 4.0, 0.0));
        } else {
            this.tickPart(this.tail2, f2 * 2.0f, 1.0, -f15 * 2.0f);
        }
        this.tickPart(this.head, f2 * -2.5f, 1.4, -f15 * -2.5f);
        this.tickPart(this.lowerbody, f2 * 3.0f, 0.0, -f15 * 3.0f);
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].xo = avec3[l].x;
            this.subEntities[l].yo = avec3[l].y;
            this.subEntities[l].zo = avec3[l].z;
            this.subEntities[l].xOld = avec3[l].x;
            this.subEntities[l].yOld = avec3[l].y;
            this.subEntities[l].zOld = avec3[l].z;
        }
        super.aiStep();
    }

    public CalamityMultipart[] getSubEntities() {
        return this.subEntities;
    }

    boolean calculateHeight() {
        return this.getTarget() != null && this.getTarget().getY() > this.getY() && Math.abs(Math.abs(this.getTarget().getY()) - Math.abs(this.getY())) > 5.0;
    }

    boolean calculateDistance() {
        return this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) > 400.0;
    }

    public boolean hasLineOfSight(Entity entity) {
        if (this.calculateDistance() || this.calculateHeight()) {
            return true;
        }
        return super.hasLineOfSight(entity);
    }

    private int[] ammoAmount() {
        int[] values = new int[2];
        if (this.isAdapted()) {
            values[0] = 5;
            values[1] = 8;
        } else {
            values[0] = 3;
            values[1] = 6;
        }
        return values;
    }

    @Override
    public void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new ScatterShotRangedGoal(this, 1.5, 80, 48.0f, this.ammoAmount()[0], this.ammoAmount()[1]){

            @Override
            public boolean canUse() {
                if (Sieger.this.getTailHp() <= 0.0f) {
                    return false;
                }
                return super.canUse() && (Sieger.this.calculateHeight() || Sieger.this.calculateDistance());
            }
        });
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(4, (Goal)new AOEMeleeAttackGoal(this, 1.5, false, 2.5, 6.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                float f = Sieger.this.getBbWidth();
                return f * 3.0f * f * 3.0f + entity.getBbWidth();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(6, (Goal)new FloatDiveGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new CalamityInfectedCommand(this));
        this.goalSelector.addGoal(7, (Goal)new SummonScentInCombat(this));
        this.goalSelector.addGoal(8, (Goal)new SporeBurstSupport(this));
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        super.registerGoals();
    }

    public boolean canDisableShield() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.sieger_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.sieger_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.sieger_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.5).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(SAttributes.TOXICITY, 0.0).add(SAttributes.REJUVENATION, 0.0).add(SAttributes.LOCALIZATION, 0.0).add(SAttributes.LACERATION, 0.0).add(SAttributes.CORROSIVES, 0.0).add(SAttributes.BALLISTIC, 0.0).add(SAttributes.GRINDING, 0.0);
    }

    protected SoundEvent getAmbientSound() {
        if (this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) > 200.0) {
            return null;
        }
        return Ssounds.SIEGER_AMBIENT.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.RAVAGER_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_218825_) {
        super.recreateFromPacket(p_218825_);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        return super.hurt(source, this.isAdapted() ? amount * 0.7f : amount);
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.sieger_dpsr.get();
    }

    public void performRangedAttack(LivingEntity livingEntity, float p_33318_) {
        if (!this.level().isClientSide) {
            ThrownTumor tumor = new ThrownTumor(this.level(), (LivingEntity)this);
            double dx = livingEntity.getX() - this.getX();
            double dy = livingEntity.getY() + (double)livingEntity.getEyeHeight() + 5.0;
            double dz = livingEntity.getZ() - this.getZ();
            if (SConfig.SERVER.sieger_explosive_effects != null) {
                List ev = (List)SConfig.SERVER.sieger_explosive_effects.get();
                for (int i = 0; i < 1; ++i) {
                    int randomIndex = this.random.nextInt(ev.size());
                    ResourceLocation randomElement1 = ResourceLocation.parse((String)((String)ev.get(randomIndex)));
                    Holder<MobEffect> randomElement = Utilities.tryToCreateEffect(randomElement1);
                    tumor.setMobEffect(randomElement);
                }
            }
            tumor.setExplode(Level.ExplosionInteraction.MOB);
            tumor.moveTo(this.getX(), this.getY() + 8.2, this.getZ());
            tumor.shoot(dx, dy - tumor.getY() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
            this.level().addFreshEntity((Entity)tumor);
        }
    }

    public boolean isAdapted() {
        return (Integer)this.entityData.get(ADAPTATION) >= 900;
    }

    @Override
    public void ActivateAdaptation() {
        this.entityData.set(ADAPTATION, (Object)900);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        this.playSound(Ssounds.SIEGER_BITE.get());
        return super.doHurtTarget(entity);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TAIL_HP, (Object)Float.valueOf(this.getMaxTailHp()));
        builder.define(ADAPTATION, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("tail_hp", ((Float)this.entityData.get(TAIL_HP)).floatValue());
        tag.putInt("adaptation", ((Integer)this.entityData.get(ADAPTATION)).intValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(TAIL_HP, (Object)Float.valueOf(tag.getFloat("tail_hp")));
        this.entityData.set(ADAPTATION, (Object)tag.getInt("adaptation"));
    }

    public float getTailHp() {
        return ((Float)this.entityData.get(TAIL_HP)).floatValue();
    }

    public void setTailHp(float i) {
        this.entityData.set(TAIL_HP, (Object)Float.valueOf(i));
    }

    public float getMaxTailHp() {
        return (float)((Double)SConfig.SERVER.sieger_hp.get() / 4.0);
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        if (calamityMultipart == this.tail || calamityMultipart == this.tail2) {
            if (this.getTailHp() > 0.0f && value > this.getTailHp()) {
                this.playSound(Ssounds.LIMB_SLASH.get());
                this.SummonDetashedTail();
            }
            this.hurt(source, this.isAdapted() ? value : value * 2.0f);
            this.setTailHp(value > this.getTailHp() ? 0.0f : this.getTailHp() - value);
        }
        if (calamityMultipart == this.head) {
            this.hurt(source, value * 0.75f);
        } else {
            this.hurt(source, value);
        }
        return true;
    }

    @Override
    public int chemicalRange() {
        return 16;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.sieger_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.sieger_debuffs.get();
    }

    private void SummonDetashedTail() {
        SiegerTail siegerTail = new SiegerTail(Sentities.SIEGER_TAIL.get(), this.level());
        Vec3 vec3 = new Vec3(-1.7, 0.0, 0.0).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
        siegerTail.setWar(this.isAdapted());
        siegerTail.moveTo(this.getX() + vec3.x, this.getY() + 1.6, this.getZ() + vec3.z);
        this.level().addFreshEntity((Entity)siegerTail);
    }

    @Override
    public String getMutation() {
        if (this.isAdapted()) {
            return "spore.entity.variant.war_torn";
        }
        return super.getMutation();
    }

    @Override
    public boolean getAdaptation() {
        return this.isAdapted();
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>();
        if (this.getTailHp() > 0.0f) {
            values.add(HitboxesForParts.SIEGER_TAIL);
        }
        for (HitboxesForParts hitboxes : this.innatePartList) {
            HitboxesForParts part = this.calculateChance(hitboxes, 0.75f);
            if (part == null) continue;
            values.add(part);
        }
        return values;
    }
}

