/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface CasingGenerator {
    private boolean compare(Level level, BlockPos blockpos) {
        boolean propery1 = level.getBlockState(blockpos.below()).isSolidRender((BlockGetter)level, blockpos);
        boolean propery2 = level.getBlockState(blockpos.above()).isSolidRender((BlockGetter)level, blockpos);
        boolean properzx1 = level.getBlockState(blockpos.east()).isSolidRender((BlockGetter)level, blockpos);
        boolean properzx2 = level.getBlockState(blockpos.south()).isSolidRender((BlockGetter)level, blockpos);
        boolean properzx3 = level.getBlockState(blockpos.north()).isSolidRender((BlockGetter)level, blockpos);
        boolean properzx4 = level.getBlockState(blockpos.west()).isSolidRender((BlockGetter)level, blockpos);
        return propery1 || propery2 || properzx1 || properzx2 || properzx3 || properzx4;
    }

    default public List<BlockState> possibleBlocks() {
        ArrayList<BlockState> values = new ArrayList<BlockState>();
        values.add(((Block)Sblocks.BIOMASS_BLOCK.get()).defaultBlockState());
        values.add(((Block)Sblocks.BIOMASS_BLOCK.get()).defaultBlockState());
        values.add(((Block)Sblocks.BIOMASS_BLOCK.get()).defaultBlockState());
        values.add(((Block)Sblocks.ROOTED_BIOMASS.get()).defaultBlockState());
        values.add(((Block)Sblocks.ROOTED_BIOMASS.get()).defaultBlockState());
        values.add(((Block)Sblocks.ROOTED_BIOMASS.get()).defaultBlockState());
        values.add(((Block)Sblocks.CALCIFIED_BIOMASS_BLOCK.get()).defaultBlockState());
        values.add(((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).defaultBlockState());
        values.add(((Block)Sblocks.GASTRIC_BIOMASS.get()).defaultBlockState());
        return values;
    }

    default public void generateChasing(BlockPos pos, Entity entity, int radius) {
        this.generateChasing(pos, entity, radius, 1);
    }

    default public void generateChasing(BlockPos pos, Entity entity, int radius, int thickness) {
        Level level = entity.level();
        RandomSource randomSource = RandomSource.create();
        for (int i = 0; i <= 2 * radius; ++i) {
            for (int j = 0; j <= 2 * radius; ++j) {
                for (int k = 0; k <= 2 * radius; ++k) {
                    double distance = Mth.sqrt((float)((i - radius) * (i - radius) + (j - radius) * (j - radius) + (k - radius) * (k - radius)));
                    if (Math.abs(i) == 2 && Math.abs(j) == 2 && Math.abs(k) == 2 || !(distance > (double)radius - (double)thickness / 2.0) || !(distance < (double)radius + (double)thickness / 2.0)) continue;
                    BlockPos blockpos = pos.offset(i - radius, j - radius, k - radius);
                    BlockState blockstate = level.getBlockState(blockpos);
                    if (Math.random() < 0.1 && !blockstate.isSolidRender((BlockGetter)level, blockpos) && this.compare(level, blockpos) && !level.isClientSide) {
                        level.setBlock(blockpos, this.possibleBlocks().get(randomSource.nextInt(this.possibleBlocks().size())), 3);
                        if (Math.random() < 0.001) {
                            this.createSpots(blockpos, level, randomSource.nextInt(3, 6), Math.random() < 0.5 ? ((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).defaultBlockState() : ((Block)Sblocks.CALCIFIED_BIOMASS_BLOCK.get()).defaultBlockState());
                        }
                        if (Math.random() < 0.001) {
                            this.createPussSpots(blockpos, level, randomSource.nextInt(2, 5));
                        }
                        if (Math.random() < 0.005) {
                            if (level.getBlockState(blockpos.above()).isAir()) {
                                this.createFungalStalks(blockpos, level, randomSource, false);
                            } else if (level.getBlockState(blockpos.below()).isAir()) {
                                this.createFungalStalks(blockpos, level, randomSource, true);
                            }
                        }
                    }
                    if (!(Math.random() < 0.05) || !blockstate.isSolidRender((BlockGetter)level, blockpos)) continue;
                    for (String str : (List)SConfig.DATAGEN.block_infection.get()) {
                        Item item;
                        ItemStack itemStack;
                        String[] string = str.split("\\|");
                        ItemStack stack = Utilities.tryToCreateStack(ResourceLocation.parse((String)string[0]));
                        if (stack == ItemStack.EMPTY || blockstate.getBlock().asItem() != stack.getItem() || (itemStack = Utilities.tryToCreateStack(ResourceLocation.parse((String)string[1]))) == ItemStack.EMPTY || !((item = itemStack.getItem()) instanceof BlockItem)) continue;
                        BlockItem blockItem = (BlockItem)item;
                        level.setBlock(blockpos, blockItem.getBlock().defaultBlockState(), 3);
                    }
                }
            }
        }
    }

    default public void createSpots(BlockPos pos, Level level, int range, BlockState state) {
        for (int i = 0; i <= 2 * range; ++i) {
            for (int j = 0; j <= 2 * range; ++j) {
                for (int k = 0; k <= 2 * range; ++k) {
                    double distance = Mth.sqrt((float)((i - range) * (i - range) + (j - range) * (j - range) + (k - range) * (k - range)));
                    if (Math.abs(i) == 2 && Math.abs(j) == 2 && Math.abs(k) == 2 || !(distance < (double)range + 0.5)) continue;
                    BlockPos blockpos = pos.offset(i - range, j - range, k - range);
                    if (!this.possibleBlocks().contains(level.getBlockState(blockpos))) continue;
                    level.setBlock(blockpos, state, 3);
                }
            }
        }
    }

    default public void createPussSpots(BlockPos pos, Level level, int range) {
        for (int i = 0; i <= 2 * range; ++i) {
            for (int j = 0; j <= 2 * range; ++j) {
                for (int k = 0; k <= 2 * range; ++k) {
                    BlockPos blockpos;
                    double distance = Mth.sqrt((float)((i - range) * (i - range) + (j - range) * (j - range) + (k - range) * (k - range)));
                    if (Math.abs(i) == 2 && Math.abs(j) == 2 && Math.abs(k) == 2) continue;
                    if (distance < (double)range + 0.5 && distance > (double)range - 0.5 && level.getBlockState(blockpos = pos.offset(i - range, j - range, k - range)).isAir()) {
                        level.setBlock(blockpos, Math.random() < 0.5 ? ((Block)Sblocks.GASTRIC_BIOMASS.get()).defaultBlockState() : ((Block)Sblocks.BIOMASS_BLOCK.get()).defaultBlockState(), 3);
                    }
                    if (!(distance < (double)range - 0.5) || !level.getBlockState(blockpos = pos.offset(i - range, j - range, k - range)).isAir()) continue;
                    level.setBlock(blockpos, Math.random() < 0.5 ? ((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).defaultBlockState() : ((LiquidBlock)Sblocks.BILE.get()).defaultBlockState(), 3);
                }
            }
        }
    }

    default public void createFungalStalks(BlockPos pos, Level level, RandomSource source, boolean down) {
        int random = down ? -source.nextInt(4, 16) : source.nextInt(4, 16);
        ArrayList<BlockState> states = new ArrayList<BlockState>(){
            {
                this.add(((Block)Sblocks.MYCELIUM_BLOCK.get()).defaultBlockState());
                this.add(((Block)Sblocks.FUNGAL_SHELL.get()).defaultBlockState());
            }
        };
        for (int i = 0; i <= random; ++i) {
            BlockState state = (BlockState)states.get(source.nextInt(states.size()));
            int randomX = source.nextInt(-1, 1);
            int randomZ = source.nextInt(-1, 1);
            BlockPos blockPos = pos.offset(randomX, i, randomZ);
            if (i % 2 == 0) {
                if (level.getBlockState(blockPos).isAir()) {
                    level.setBlock(blockPos, state, 3);
                }
                if (level.getBlockState(blockPos.above()).isAir()) {
                    level.setBlock(blockPos.above(), state, 3);
                }
            }
            if (i != random - 1) continue;
            if (level.getBlockState(blockPos.above()).isAir()) {
                level.setBlock(blockPos.above(), ((Block)Sblocks.ORGANITE.get()).defaultBlockState(), 3);
            }
            if (!level.getBlockState(blockPos).isAir()) continue;
            level.setBlock(blockPos, state, 3);
        }
    }
}

