/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.HybridPathNavigation;
import com.Harbinger.Spore.Sentities.AI.ReturnToWater;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.MovementControls.WaterXlandMovement;
import com.Harbinger.Spore.Sentities.WaterInfected;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sparticles;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class Bloater
extends EvolvedInfected
implements WaterInfected {
    public static final EntityDataAccessor<Integer> TUMORS = SynchedEntityData.defineId(Bloater.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int explosionTicks = 0;

    public Bloater(EntityType<? extends Infected> type, Level level) {
        super(type, level);
        this.moveControl = new WaterXlandMovement((Mob)this);
        this.navigation = new HybridPathNavigation((Mob)this, this.level());
    }

    @Override
    public void travel(Vec3 p_32858_) {
        if (this.isEffectiveAi() && this.isInFluidType()) {
            this.moveRelative(0.1f, p_32858_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.85));
        } else {
            super.travel(p_32858_);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.bloater_melee_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.braio_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.bloater_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 28.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public int getAmountOfTumors() {
        return (Integer)this.entityData.get(TUMORS);
    }

    public void setAmountOfTumors(int value) {
        this.entityData.set(TUMORS, (Object)value);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TUMORS, (Object)4);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setAmountOfTumors(tag.getInt("tumors"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("tumors", this.getAmountOfTumors());
    }

    public void tick() {
        super.tick();
        if (this.explosionTicks > 0) {
            this.tickExplosion();
        }
        if (this.tickCount % 400 == 0 && this.getAmountOfTumors() < 4) {
            this.setAmountOfTumors(this.getAmountOfTumors() + 1);
        }
    }

    public void tickExplosion() {
        if (this.explosionTicks == 1) {
            this.playSound(SoundEvents.CREEPER_PRIMED);
        }
        ++this.explosionTicks;
        if (this.explosionTicks == 50) {
            this.explodeTumor();
            this.explosionTicks = 0;
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.bloater_loot.get();
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (Math.random() < 0.5 && this.getAmountOfTumors() > 0) {
            this.tickExplosion();
        }
        if (entity.isInFluidType()) {
            entity.setDeltaMovement(this.getDeltaMovement().add(0.0, -1.0, 0.0));
        }
        return super.doHurtTarget(entity);
    }

    public void explodeTumor() {
        Entity entity22;
        AABB aabb = this.getBoundingBox().inflate(8.0);
        List entities = this.level().getEntities((Entity)this, aabb, entity -> {
            LivingEntity living;
            return entity instanceof LivingEntity && this.TARGET_SELECTOR.test(living = (LivingEntity)entity);
        });
        for (Entity entity22 : entities) {
            if (!(entity22 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity22;
            if (Utilities.helmetList().contains(living.getItemBySlot(EquipmentSlot.HEAD).getItem())) continue;
            living.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 200, 2));
            living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0));
        }
        this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value());
        this.setAmountOfTumors(this.getAmountOfTumors() - 1);
        entity22 = this.level();
        if (entity22 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity22;
            double x0 = this.getX() - ((double)this.random.nextFloat() - 0.1) * 0.1;
            double y0 = this.getY() + ((double)this.random.nextFloat() - 0.25) * 0.25 * 5.0;
            double z0 = this.getZ() + ((double)this.random.nextFloat() - 0.1) * 0.1;
            serverLevel.sendParticles((ParticleOptions)Sparticles.SPORE_PARTICLE.get(), x0, y0, z0, 12, 0.0, 0.0, 0.0, 1.0);
        }
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new CustomMeleeAttackGoal(this, this, 1.3, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0f + entity.getBbWidth() * entity.getBbWidth();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new ReturnToWater(this, 1.2));
        super.registerGoals();
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.DROWNED_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.DROWNED_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }
}

