/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.BraionmilSwellGoal;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.Hyper.Brot;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SdamageTypes;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class Braionmil
extends EvolvedInfected
implements EvolvingInfected {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.defineId(Braionmil.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int swell;
    private final int maxSwell = 40;

    public Braionmil(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_braio_loot.get();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SWELL_DIR, (Object)-1);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag data) {
        super.addAdditionalSaveData(data);
        data.putShort("Fuse", (short)this.maxSwell);
    }

    public void tick() {
        if (this.isAlive()) {
            int i = this.getSwellDir();
            if (i > 0 && this.swell == 0) {
                this.playSound(Ssounds.BRAIOMIL_ATTACK.get(), 1.0f, 0.5f);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.setSwellDir(-1);
                this.chemAttack((LivingEntity)this);
            }
        }
        super.tick();
        this.tickHyperEvolution(this);
    }

    public int getSwellDir() {
        return (Integer)this.entityData.get(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.entityData.set(DATA_SWELL_DIR, (Object)p_32284_);
    }

    private void chemAttack(LivingEntity pLivingEntity) {
        AABB boundingBox = pLivingEntity.getBoundingBox().inflate(8.0);
        List entities = pLivingEntity.level().getEntities((Entity)pLivingEntity, boundingBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (Utilities.helmetList().contains(livingEntity.getItemBySlot(EquipmentSlot.HEAD).getItem()) || !this.TARGET_SELECTOR.test(livingEntity)) continue;
            for (String str : (List)SConfig.SERVER.braio_effects.get()) {
                String[] string = str.split("\\|");
                Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)string[0]));
                if (livingEntity.hasEffect(effect)) continue;
                livingEntity.addEffect(new MobEffectInstance(effect, Integer.parseUnsignedInt(string[1]), Integer.parseUnsignedInt(string[2])));
            }
        }
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.3) {
            return SdamageTypes.braiomil_damage((LivingEntity)this);
        }
        return super.getCustomDamage(entity);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        if (this.swell >= 25) {
            for (int i = 0; i < 360; ++i) {
                if (i % 20 != 0) continue;
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y + 1.2, z, Math.cos(i) * 0.15, Math.sin(i) * Math.cos(i) * 0.15, Math.sin(i) * 0.15);
            }
        }
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new CustomMeleeAttackGoal(this, this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0f + entity.getBbWidth() * entity.getBbWidth();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new BraionmilSwellGoal(this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.braio_melee_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.braio_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.braio_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 28.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INF_GROWL.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public void HyperEvolve(LivingEntity living) {
        Brot brot = new Brot((EntityType<? extends Infected>)Sentities.BROTKATZE.get(), this.level());
        Collection collection = this.getActiveEffects();
        for (MobEffectInstance mobeffectinstance : collection) {
            brot.addEffect(new MobEffectInstance(mobeffectinstance));
        }
        brot.setKills(this.getKills());
        brot.setEvoPoints(this.getEvoPoints() - (Integer)SConfig.SERVER.min_kills_hyper.get());
        brot.setCustomName(this.getCustomName());
        brot.setPos(this.getX(), this.getY(), this.getZ());
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            brot.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.getOnPos()), MobSpawnType.CONVERSION, null);
        }
        this.level().addFreshEntity((Entity)brot);
        this.discard();
        EvolvingInfected.super.HyperEvolve(living);
    }
}

