/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.TransportInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Carrier;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.Hyper.Ogre;
import com.Harbinger.Spore.Sentities.Projectile.ThrownBlockProjectile;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Brute
extends EvolvedInfected
implements Carrier,
RangedAttackMob,
EvolvingInfected {
    private static final EntityDataAccessor<Optional<BlockState>> DATA_CARRY_STATE = SynchedEntityData.defineId(Brute.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE);

    public Brute(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_brute_loot.get();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new TransportInfected<Mob>((Mob)this, Mob.class, 1.1, entity -> ((List)SConfig.SERVER.ranged.get()).contains(entity.getEncodeId())));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal(this, 1.3, 80, 48.0f){

            public boolean canUse() {
                return super.canUse() && Brute.this.getCarriedBlock() != null && Brute.this.getTarget() != null && Brute.this.distanceToSqr((Entity)Brute.this.getTarget()) > 200.0;
            }
        });
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, this, 1.3, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    public void setCarriedBlock(@Nullable BlockState state) {
        this.entityData.set(DATA_CARRY_STATE, Optional.ofNullable(state));
    }

    @Nullable
    public BlockState getCarriedBlock() {
        return ((Optional)this.entityData.get(DATA_CARRY_STATE)).orElse(null);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        BlockState blockstate = this.getCarriedBlock();
        if (blockstate != null) {
            tag.put("carriedBlockState", (Tag)NbtUtils.writeBlockState((BlockState)blockstate));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        BlockState blockstate = null;
        if (tag.contains("carriedBlockState", 10) && (blockstate = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("carriedBlockState"))).isAir()) {
            blockstate = null;
        }
        this.setCarriedBlock(blockstate);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CARRY_STATE, Optional.empty());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (DATA_CARRY_STATE.equals(dataAccessor)) {
            if (this.getCarriedBlock() != null) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)this.getCarriedBlock().getBlock().asItem()));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            }
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.brute_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.brute_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.brute_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public void tick() {
        if (this.isAlive() && this.getTarget() != null && this.getRandom().nextInt(0, 6) == 3 && this.checkForInfected((Entity)this) && this.switchy()) {
            this.performRangedAttack((LivingEntity)this);
        }
        super.tick();
        if (this.getCarriedBlock() == null && this.random.nextInt(250) == 0) {
            this.setCarriedBlock(this.blocky());
        }
        this.tickHyperEvolution(this);
    }

    private boolean switchy() {
        if (this.getTarget() != null) {
            double ze = this.distanceToSqr((Entity)this.getTarget());
            return ze > 60.0 && ze < 400.0;
        }
        return false;
    }

    boolean checkForInfected(Entity entity) {
        AABB boundingBox = entity.getBoundingBox().inflate(1.2);
        List entities = entity.level().getEntities(entity, boundingBox);
        for (Entity en : entities) {
            if (!((List)SConfig.SERVER.can_be_carried.get()).contains(en.getEncodeId())) continue;
            return true;
        }
        return false;
    }

    public void performRangedAttack(LivingEntity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = entity.getX() + vec3.x - this.getTarget().getX();
        double d1 = entity.getEyeY() - (double)1.1f - this.getY();
        double d2 = entity.getZ() + vec3.z - this.getTarget().getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        AABB boundingBox = entity.getBoundingBox().inflate(1.2);
        List entities = entity.level().getEntities((Entity)entity, boundingBox);
        for (Entity en : entities) {
            if (!(en instanceof Mob) || !((List)SConfig.SERVER.can_be_carried.get()).contains(en.getEncodeId())) continue;
            en.setDeltaMovement(d0 * -0.2, (d1 + d3) * 0.02, d2 * -0.2);
            ((Mob)en).addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 200, 0));
        }
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INF_PILLAGER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_VILLAGER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public void performRangedAttack(LivingEntity livingEntity, float p_33318_) {
        if (!this.level().isClientSide && this.getCarriedBlock() != null) {
            ThrownBlockProjectile thrownBlockProjectile = new ThrownBlockProjectile(this.level(), (LivingEntity)this, Float.valueOf(10.0f), this.getCarriedBlock(), this.TARGET_SELECTOR);
            double dx = livingEntity.getX() - this.getX();
            double dy = livingEntity.getY() + (double)livingEntity.getEyeHeight() - 1.0;
            double dz = livingEntity.getZ() - this.getZ();
            thrownBlockProjectile.moveTo(this.getX(), this.getY() + 1.5, this.getZ());
            thrownBlockProjectile.shoot(dx, dy - thrownBlockProjectile.getY() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
            this.level().addFreshEntity((Entity)thrownBlockProjectile);
            this.setCarriedBlock(null);
        }
    }

    public BlockState blocky() {
        AABB aabb = this.getBoundingBox().inflate(0.2);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (!(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) < 5.0f) || !(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) >= 0.0f)) continue;
            this.level().destroyBlock(blockpos, false);
            return blockstate;
        }
        return null;
    }

    @Override
    public void HyperEvolve(LivingEntity living) {
        Ogre ogre = new Ogre((EntityType<? extends Infected>)Sentities.OGRE.get(), this.level());
        Collection collection = this.getActiveEffects();
        for (MobEffectInstance mobeffectinstance : collection) {
            ogre.addEffect(new MobEffectInstance(mobeffectinstance));
        }
        ogre.setKills(this.getKills());
        ogre.setEvoPoints(this.getEvoPoints() - (Integer)SConfig.SERVER.min_kills_hyper.get());
        ogre.setCustomName(this.getCustomName());
        ogre.setPos(this.getX(), this.getY(), this.getZ());
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ogre.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.getOnPos()), MobSpawnType.CONVERSION, null);
        }
        this.level().addFreshEntity((Entity)ogre);
        this.discard();
        EvolvingInfected.super.HyperEvolve(living);
    }
}

