/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Sentities.AI.BusserFlyAndDrop;
import com.Harbinger.Spore.Sentities.AI.BusserSwellGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.PhayerGrabAndDropTargets;
import com.Harbinger.Spore.Sentities.AI.PullGoal;
import com.Harbinger.Spore.Sentities.AI.TransportInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Carrier;
import com.Harbinger.Spore.Sentities.FlyingInfected;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedArialMovementControl;
import com.Harbinger.Spore.Sentities.Projectile.StingerProjectile;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.BusserVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Busser
extends EvolvedInfected
implements Carrier,
FlyingInfected,
RangedAttackMob,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(Busser.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.defineId(Busser.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int flytimeV;
    private int swell;

    public Busser(EntityType<? extends Infected> type, Level level) {
        super(type, level);
        this.moveControl = new InfectedArialMovementControl((Mob)this, 20, true);
        this.navigation = new FlyingPathNavigation((Mob)this, level);
    }

    public boolean causeFallDamage(float p_147105_, float p_147106_, DamageSource p_147107_) {
        return false;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_bus_loot.get();
    }

    protected void positionRider(Entity entity, Entity.MoveFunction p_19958_) {
        super.positionRider(entity, p_19958_);
        Vec3 vec3 = new Vec3(0.4, 0.0, 0.0).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
        entity.setPos(this.getX() + vec3.x, this.getY() - 1.2, this.getZ() + vec3.z);
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(4, (Goal)new CustomMeleeAttackGoal(this, 1.5, false){

            @Override
            public boolean canUse() {
                return Busser.this.getTypeVariant() != 3 && super.canUse();
            }

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 5.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(3, (Goal)new PullGoal((Mob)this, 32.0, 16.0){

            @Override
            public boolean canUse() {
                return Busser.this.getTypeVariant() == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new BusserFlyAndDrop(this, 6){

            @Override
            public boolean canUse() {
                return Busser.this.getTypeVariant() == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new TransportInfected<Mob>((Mob)this, Mob.class, 0.8, e -> ((List)SConfig.SERVER.can_be_carried.get()).contains(e.getEncodeId()) || ((List)SConfig.SERVER.ranged.get()).contains(e.getEncodeId())){

            @Override
            public boolean canUse() {
                return Busser.this.getTypeVariant() == 0 && super.canUse();
            }
        });
    }

    public void addVariantGoals() {
        if (this.getTypeVariant() == 3) {
            this.goalSelector.addGoal(3, (Goal)new ScatterShotRangedGoal(this, 1.2, 40, 20.0f, 1, 3){

                @Override
                public boolean canUse() {
                    return super.canUse() && Busser.this.getTypeVariant() == 3;
                }
            });
        }
        if (this.getTypeVariant() == 1) {
            this.goalSelector.addGoal(3, (Goal)new PhayerGrabAndDropTargets(this));
        }
        if (this.getTypeVariant() == 2) {
            this.goalSelector.addGoal(3, (Goal)new BusserSwellGoal(this));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.bus_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.bus_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.bus_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.FLYING_SPEED, 0.4);
    }

    public void tick() {
        super.tick();
        if (this.isAlive() && this.getTypeVariant() == 2) {
            this.manageExplosiveBusser();
        }
    }

    public void manageExplosiveBusser() {
        int i = this.getSwellDir();
        if (i > 0 && this.swell == 0) {
            this.playSound(SoundEvents.CREEPER_PRIMED, 1.0f, 0.5f);
            this.gameEvent((Holder)GameEvent.PRIME_FUSE);
        }
        if (i != 0) {
            this.swell = i > 0 ? ++this.swell : --this.swell;
            if (this.swell < 0) {
                this.swell = 0;
            }
        }
        if (this.swell >= 20) {
            this.swell = 20;
            this.explodeBusser();
        }
    }

    private void explodeBusser() {
        if (!this.level().isClientSide) {
            Level.ExplosionInteraction explosion$blockinteraction = EventHooks.canEntityGrief((Level)this.level(), (Entity)this) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)((Integer)SConfig.SERVER.kami_busser_explosion.get()).intValue(), explosion$blockinteraction);
            this.discard();
            for (int i = 0; i < 3; ++i) {
                int x = this.random.nextInt(-2, 2);
                int z = this.random.nextInt(-2, 2);
                AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX() + (double)x, this.getY(), this.getZ() + (double)z);
                areaeffectcloud.setRadius(2.5f);
                areaeffectcloud.setRadiusOnUse(-0.5f);
                areaeffectcloud.setWaitTime(10);
                areaeffectcloud.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 200, 2));
                areaeffectcloud.addEffect(new MobEffectInstance(Seffects.MARKER, 600, 0));
                areaeffectcloud.setDuration(areaeffectcloud.getDuration() / 2);
                areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
                this.level().addFreshEntity((Entity)areaeffectcloud);
            }
        }
    }

    @Override
    public void travel(Vec3 vec) {
        if (this.isEffectiveAi() && !this.onGround()) {
            this.moveRelative(0.1f, vec);
            this.move(MoverType.SELF, this.getDeltaMovement().scale(this.isInWater() ? 0.1 : 0.75));
            this.setDeltaMovement(this.getDeltaMovement().scale(0.85));
        } else {
            super.travel(vec);
        }
    }

    protected void customServerAiStep() {
        if (this.getTypeVariant() == 1 && this.isVehicle()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.03, 0.0));
            if (this.flytimeV < 200) {
                ++this.flytimeV;
            } else {
                this.flytimeV = 0;
                this.ejectPassengers();
            }
        }
        if (this.tickCount % 20 == 0 && this.getTarget() == null && !this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.2, 0.0));
        }
        super.customServerAiStep();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.define(DATA_SWELL_DIR, (Object)-1);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getTypeVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> dataAccessor) {
        if (DATA_ID_TYPE_VARIANT.equals(dataAccessor)) {
            this.addVariantGoals();
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.getVariant() == BusserVariants.ENHANCED) {
            EntityDimensions baseDimensions = super.getDefaultDimensions(pose);
            return baseDimensions.scale(1.2f);
        }
        return super.getDefaultDimensions(pose);
    }

    public int getSwellDir() {
        return (Integer)this.entityData.get(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.entityData.set(DATA_SWELL_DIR, (Object)p_32284_);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        BusserVariants variant = (BusserVariants)((Object)Util.getRandom((Object[])BusserVariants.values(), (RandomSource)this.random));
        this.setVariant(variant);
        if (this.getTypeVariant() == 1) {
            AttributeInstance health = this.getAttribute(Attributes.MAX_HEALTH);
            AttributeInstance armor = this.getAttribute(Attributes.ARMOR);
            if (health != null) {
                health.setBaseValue((Double)SConfig.SERVER.bus_hp.get() * 1.5 * (Double)SConfig.SERVER.global_health.get());
            }
            if (armor != null) {
                armor.setBaseValue((Double)SConfig.SERVER.bus_armor.get() * 1.5 * (Double)SConfig.SERVER.global_armor.get());
            }
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public BusserVariants getVariant() {
        return BusserVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(i > BusserVariants.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return BusserVariants.values().length;
    }

    private void setVariant(BusserVariants variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INF_GROWL.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public void performRangedAttack(LivingEntity entity, float p_33318_) {
        StingerProjectile stinger = new StingerProjectile(this.level(), (LivingEntity)this, (float)((Double)SConfig.SERVER.bus_damage.get() * 1.0));
        stinger.moveTo(this.getX(), this.getY(), this.getZ());
        double dx = entity.getX() - this.getX();
        double dy = entity.getY() + (double)entity.getEyeHeight() - 2.0;
        double dz = entity.getZ() - this.getZ();
        stinger.shoot(dx, dy - stinger.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        this.level().addFreshEntity((Entity)stinger);
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }
}

