/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Carrier;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.HowlerVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Howler
extends EvolvedInfected
implements VariantKeeper,
ArmorPersentageBypass {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(Howler.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final List<String> sculkSummon = List.of("sculkhorde:sculk_mite", "sculkhorde:sculk_mite_aggressor");

    public Howler(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(2, (Goal)new HowlerAttackGoal(this, 1.5));
        this.goalSelector.addGoal(3, (Goal)new BansheeMeleeGoal(this, this.random));
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, 1.2, true){

            @Override
            public boolean canUse() {
                return super.canUse() && Howler.this.getVariant() == HowlerVariants.DEFAULT;
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.how_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.how_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.how_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_KNOCKBACK, 3.0);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INF_PILLAGER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_20135_, BlockState p_20136_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public HowlerVariants getVariant() {
        return HowlerVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(i > HowlerVariants.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return HowlerVariants.values().length;
    }

    private void setVariant(HowlerVariants variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }

    public void tick() {
        super.tick();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_howler_loot.get();
    }

    public void ScreamAOE(Entity origin) {
        AABB area = origin.getBoundingBox().inflate(12.0);
        List targets = origin.level().getEntities(origin, area, EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        for (Entity target : targets) {
            if (target instanceof Infected) {
                Infected infected = (Infected)target;
                infected.addEffect(new MobEffectInstance(Seffects.MARKER, 400, 0));
                continue;
            }
            if (!(target instanceof Player)) continue;
            Player player = (Player)target;
            player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0));
            player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 0));
        }
    }

    public void ScreamBuffInfected(Entity origin) {
        AABB area = origin.getBoundingBox().inflate(6.0);
        List allies = origin.level().getEntities(origin, area);
        int duration = switch (origin.level().getDifficulty()) {
            case Difficulty.EASY -> 100;
            case Difficulty.NORMAL -> 200;
            case Difficulty.HARD -> 400;
            default -> 0;
        };
        int amplifier = origin.level().getDifficulty() == Difficulty.HARD ? 1 : 0;
        List buffs = (List)SConfig.SERVER.howler_effects_buff.get();
        String randomBuff = (String)buffs.get(this.random.nextInt(buffs.size()));
        Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)randomBuff));
        if (effect != null) {
            for (Entity ally : allies) {
                if (!(ally instanceof Infected)) continue;
                Infected infected = (Infected)ally;
                infected.addEffect(new MobEffectInstance(effect, duration, amplifier));
            }
        }
        this.playSound(Ssounds.HOWLER_GROWL.get());
    }

    public void SummonScream(LivingEntity caster, boolean isSkulk, boolean sculkAround) {
        Mob summoned;
        ServerLevelAccessor levelAccessor = (ServerLevelAccessor)caster.level();
        Level level = caster.level();
        int dx = this.random.nextInt(-8, 9);
        int dz = this.random.nextInt(-8, 9);
        int dy = this.random.nextInt(0, 2);
        List summonPool = isSkulk && sculkAround ? sculkSummon : (List)SConfig.SERVER.howler_summon.get();
        String chosen = (String)summonPool.get(this.random.nextInt(summonPool.size()));
        ResourceLocation entityId = ResourceLocation.parse((String)chosen);
        EntityType<?> entityType = Utilities.tryToCreateEntity(entityId);
        if (entityType != null && (summoned = (Mob)entityType.create(level)) != null) {
            summoned.teleportRelative(caster.getX() + (double)dx, caster.getY() + 0.5 + (double)dy, caster.getZ() + (double)dz);
            summoned.finalizeSpawn(levelAccessor, level.getCurrentDifficultyAt(BlockPos.containing((Position)caster.position())), MobSpawnType.NATURAL, null);
            level.addFreshEntity((Entity)summoned);
            this.playSound(Ssounds.HOWLER_GROWL.get());
        }
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public boolean dampensVibrations() {
        return this.getVariant() == HowlerVariants.SONIC;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getTypeVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    public boolean checkForInfected(Entity origin) {
        AABB area = origin.getBoundingBox().inflate(4.0);
        List nearby = origin.level().getEntities(origin, area, EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        for (Entity entity : nearby) {
            if (!(entity instanceof Infected) || ((List)SConfig.SERVER.support.get()).contains(entity.getEncodeId()) || entity instanceof Carrier) continue;
            return true;
        }
        return false;
    }

    @Override
    public float amountOfDamage(float value) {
        return this.getVariant() == HowlerVariants.BANSHEE ? (float)((Double)SConfig.SERVER.how_damage.get() * (Double)SConfig.SERVER.global_damage.get() / 2.0) : 0.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        HowlerVariants variant = (HowlerVariants)((Object)Util.getRandom((Object[])HowlerVariants.values(), (RandomSource)this.random));
        this.setVariant(variant);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    private class HowlerAttackGoal
    extends Goal {
        private final Howler mob;
        private final double speed;
        private int screamTimer = 0;

        private HowlerAttackGoal(Howler mob, double speedModifier) {
            this.mob = mob;
            this.speed = speedModifier;
        }

        public boolean canUse() {
            return this.mob.getTarget() != null && this.mob.getVariant() != HowlerVariants.BANSHEE;
        }

        public void tick() {
            LivingEntity target;
            if (this.screamTimer > 0) {
                --this.screamTimer;
            }
            if ((target = this.mob.getTarget()) == null) {
                return;
            }
            boolean isSkulk = this.mob.getVariant() == HowlerVariants.SONIC && (Boolean)SConfig.SERVER.skulk_target.get() != false;
            this.mob.getLookControl().setLookAt((Entity)target, 10.0f, (float)this.mob.getMaxHeadXRot());
            double dist = this.mob.distanceToSqr((Entity)target);
            if (dist > 120.0) {
                this.mob.getNavigation().moveTo((Entity)target, this.speed);
            } else if (this.screamTimer <= 0) {
                if (Howler.this.checkForInfected((Entity)this.mob)) {
                    Howler.this.ScreamAOE((Entity)this.mob);
                    Howler.this.ScreamBuffInfected((Entity)this.mob);
                } else {
                    boolean skulk = ModList.get().isLoaded("sculkhorde");
                    int summons = skulk ? Howler.this.random.nextInt(3, 9) : Howler.this.random.nextInt(1, 4);
                    for (int i = 0; i < summons; ++i) {
                        Howler.this.SummonScream((LivingEntity)this.mob, isSkulk, skulk);
                    }
                }
                if (this.mob.getVariant() == HowlerVariants.SONIC) {
                    this.shootSonicBoom(target, (float)((Double)SConfig.SERVER.how_damage.get() * (Double)SConfig.SERVER.global_damage.get()));
                }
                this.screamTimer = 120;
            }
        }

        public void shootSonicBoom(LivingEntity target, float damage) {
            if (target == null || !target.isAlive()) {
                return;
            }
            this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.HOSTILE, 3.0f, 1.0f);
            Level level = this.mob.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double dx = target.getX() - this.mob.getX();
                double dy = target.getY(0.5) - this.mob.getEyeY();
                double dz = target.getZ() - this.mob.getZ();
                for (int i = 0; i < 10; ++i) {
                    double px = this.mob.getX() + dx * (double)i / 10.0;
                    double py = this.mob.getEyeY() + dy * (double)i / 10.0;
                    double pz = this.mob.getZ() + dz * (double)i / 10.0;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            target.hurt(this.mob.damageSources().sonicBoom((Entity)this.mob), damage);
            Vec3 push = new Vec3(target.getX() - this.mob.getX(), target.getEyeY() - this.mob.getEyeY(), target.getZ() - this.mob.getZ()).normalize().scale(1.5);
            target.push(push.x, push.y * 0.5, push.z);
        }
    }

    private static class BansheeMeleeGoal
    extends CustomMeleeAttackGoal {
        private int timeBeforeBigScream;
        private final RandomSource randomSource;

        public BansheeMeleeGoal(PathfinderMob mob, RandomSource randomSource) {
            super(mob, 1.75, true);
            this.randomSource = randomSource;
        }

        @Override
        public void tick() {
            super.tick();
            if (this.timeBeforeBigScream < 200) {
                ++this.timeBeforeBigScream;
            } else {
                this.callOrSummon();
                this.timeBeforeBigScream = 0;
                this.mob.playSound(Ssounds.HOWLER_GROWL.get());
            }
        }

        public void callOrSummon() {
            List<Infected> brothers = this.getBrothers();
            if (brothers.isEmpty() || brothers.size() < 6) {
                Vec3 vec3 = Utilities.generatePositionAway(this.mob.position(), 16.0);
                for (int i = 0; i < this.randomSource.nextInt(3, 10); ++i) {
                    this.summonAtDistance(vec3);
                }
            } else {
                for (Infected infected : brothers) {
                    if (!infected.isAlive() || infected.getTarget() != null) continue;
                    infected.setTarget(this.mob.getTarget());
                }
            }
        }

        public void summonAtDistance(Vec3 vec3) {
            Level level;
            Mob summoned;
            List summonPool = (List)SConfig.SERVER.howler_summon.get();
            String chosen = (String)summonPool.get(this.randomSource.nextInt(summonPool.size()));
            ResourceLocation entityId = ResourceLocation.parse((String)chosen);
            EntityType<?> entityType = Utilities.tryToCreateEntity(entityId);
            if (entityType != null && (summoned = (Mob)entityType.create(this.mob.level())) != null && (level = this.mob.level()) instanceof ServerLevelAccessor) {
                ServerLevelAccessor accessor = (ServerLevelAccessor)level;
                summoned.teleportTo(vec3.x, this.mob.getY() + 0.5, vec3.z);
                summoned.finalizeSpawn(accessor, accessor.getCurrentDifficultyAt(BlockPos.containing((Position)this.mob.position())), MobSpawnType.NATURAL, null);
                summoned.setTarget(this.mob.getTarget());
                accessor.addFreshEntity((Entity)summoned);
            }
        }

        public List<Infected> getBrothers() {
            return this.mob.level().getEntitiesOfClass(Infected.class, this.mob.getBoundingBox().inflate(32.0, 8.0, 32.0));
        }

        @Override
        public boolean canUse() {
            Howler howler;
            PathfinderMob pathfinderMob;
            return super.canUse() && (pathfinderMob = this.mob) instanceof Howler && (howler = (Howler)pathfinderMob).getVariant() == HowlerVariants.BANSHEE;
        }
    }
}

