/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class Inebriator
extends EvolvedInfected {
    private int attackAnimationTick;
    private LivingEntity patient;

    public Inebriator(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    public void setPatient(LivingEntity patient) {
        this.patient = patient;
    }

    public LivingEntity getPatient() {
        return this.patient;
    }

    public List<MobEffectInstance> getEffects() {
        ArrayList<MobEffectInstance> values = new ArrayList<MobEffectInstance>();
        for (String s : (List)SConfig.SERVER.ineb_buffs.get()) {
            String[] val = s.split("\\|");
            Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)val[0]));
            if (effect == null) continue;
            values.add(new MobEffectInstance(effect, Integer.parseUnsignedInt(val[1]), Integer.parseUnsignedInt(val[2])));
        }
        return values;
    }

    public void checkForPatients() {
        Level level = this.level();
        if (!level.isClientSide()) {
            LivingEntity livingEntity;
            AABB aabb = this.getBoundingBox().inflate(4.0, 1.0, 4.0);
            List entities = level.getEntities((Entity)this, aabb, entity -> {
                LivingEntity livingEntity;
                return entity instanceof LivingEntity && ((livingEntity = (LivingEntity)entity) instanceof Infected || livingEntity instanceof UtilityEntity);
            });
            if (entities.isEmpty()) {
                return;
            }
            Entity entity2 = (Entity)entities.get(this.random.nextInt(entities.size()));
            if (entity2 instanceof LivingEntity && !((livingEntity = (LivingEntity)entity2) instanceof Inebriator) && this.hasLineOfSight((Entity)livingEntity) && !livingEntity.isInvulnerable()) {
                this.setPatient(livingEntity);
            }
        }
    }

    public void InjectMedicine(List<MobEffectInstance> effects) {
        LivingEntity entity = this.getPatient();
        if (entity != null) {
            for (MobEffectInstance instance : effects) {
                entity.addEffect(instance);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
            this.playSound(Ssounds.INEBRIATER_INJECT.get());
        }
    }

    public void handleEntityEvent(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.handleEntityEvent(value);
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(entity);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.tickCount % 40 == 0) {
            this.checkForPatients();
            LivingEntity livingEntity = this.getPatient();
            if (this.getPatient() != null && !this.getPatient().isAlive()) {
                this.setPatient(null);
            }
            if (livingEntity != null) {
                if (!livingEntity.isAlive()) {
                    this.setPatient(null);
                } else if (livingEntity.distanceTo((Entity)this) < 4.0f) {
                    this.InjectMedicine(this.getEffects());
                }
            }
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inebriater_loot.get();
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.ineb_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.ineb_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.ineb_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new FollowPatientGoal(this, 1.5, 4.0f, 2.0f));
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 4.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }

            @Override
            public boolean canUse() {
                AABB aabb = this.mob.getBoundingBox().inflate(4.0, 1.0, 4.0);
                List allies = this.mob.level().getEntities((Entity)this.mob, aabb, entity -> (entity instanceof Infected || entity instanceof UtilityEntity) && !(entity instanceof Inebriator));
                return allies.isEmpty() && super.canUse();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.SCIENTIST_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public static class FollowPatientGoal
    extends Goal {
        private final Inebriator mob;
        private LivingEntity target;
        private final double speedModifier;
        private final float stopDistance;
        private final float startDistance;

        public FollowPatientGoal(Inebriator mob, double speedModifier, float startDistance, float stopDistance) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.target = this.mob.getPatient();
            return this.target != null && this.target.isAlive() && this.mob.distanceTo((Entity)this.target) > this.startDistance;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.target.isAlive() && this.mob.distanceTo((Entity)this.target) > this.stopDistance;
        }

        public void tick() {
            if (this.target != null) {
                this.mob.getNavigation().moveTo((Entity)this.target, this.speedModifier);
            }
        }

        public void stop() {
            this.target = null;
            this.mob.getNavigation().stop();
        }
    }
}

