/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.PullGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.Hyper.Hevoker;
import com.Harbinger.Spore.Sentities.Utility.InfEvoClaw;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfectedEvoker
extends EvolvedInfected
implements EvolvingInfected {
    private static final EntityDataAccessor<Boolean> HAS_ARM = SynchedEntityData.defineId(InfectedEvoker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public InfectedEvoker(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.inf_evo_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.inf_evo_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.inf_evo_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_evoker_loot.get();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_ARM, (Object)true);
    }

    public void tick() {
        super.tick();
        if (!((Boolean)this.getEntityData().get(HAS_ARM)).booleanValue() && Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).getBaseValue() == (Double)SConfig.SERVER.inf_evo_damage.get() * (Double)SConfig.SERVER.global_damage.get()) {
            AttributeInstance attackDamage = this.getAttribute(Attributes.ATTACK_DAMAGE);
            assert (attackDamage != null);
            attackDamage.setBaseValue((Double)SConfig.SERVER.inf_evo_damage.get() / 2.0 * (Double)SConfig.SERVER.global_damage.get());
        }
        this.tickHyperEvolution(this);
    }

    public boolean hasArm() {
        return (Boolean)this.entityData.get(HAS_ARM);
    }

    public void setArm(boolean b) {
        this.entityData.set(HAS_ARM, (Object)b);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("arm", ((Boolean)this.entityData.get(HAS_ARM)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(HAS_ARM, (Object)tag.getBoolean("arm"));
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.populateDefaultEquipmentEnchantments(level, this.random, difficulty);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected void populateDefaultEquipmentEnchantments(ServerLevelAccessor level, RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING));
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INF_EVOKER_GROWL.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.INF_EVOKER_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_EVOKER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new CustomMeleeAttackGoal(this, 1.4, true){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                if (((Boolean)InfectedEvoker.this.entityData.get(HAS_ARM)).booleanValue()) {
                    return 6.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
                }
                return 3.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(1, (Goal)new PullGoal((Mob)this, 32.0, 8.0){

            @Override
            public boolean canUse() {
                return InfectedEvoker.this.switchy();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private boolean switchy() {
        if (this.getTarget() != null) {
            double ze = this.distanceToSqr((Entity)this.getTarget());
            return ze > 200.0 && ze < 600.0 && (Boolean)this.entityData.get(HAS_ARM) != false;
        }
        return false;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (Math.random() < 0.3) {
            this.SummonArm((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        }
        return super.hurt(source, amount);
    }

    private void SummonArm(LevelAccessor levelAccessor, double x, double y, double z, Entity entity) {
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)levelAccessor;
            if (((Boolean)this.entityData.get(HAS_ARM)).booleanValue()) {
                InfEvoClaw entityToSpawn = new InfEvoClaw(Sentities.CLAW.get(), (Level)_level);
                entityToSpawn.moveTo(x, y, z, levelAccessor.getRandom().nextFloat() * 360.0f, 0.0f);
                entityToSpawn.finalizeSpawn((ServerLevelAccessor)_level, levelAccessor.getCurrentDifficultyAt(entityToSpawn.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
                levelAccessor.addFreshEntity((Entity)entityToSpawn);
                this.entityData.set(HAS_ARM, (Object)false);
            }
        }
    }

    @Override
    public void HyperEvolve(LivingEntity living) {
        Hevoker brot = new Hevoker((EntityType<? extends Infected>)Sentities.HEVOKER.get(), this.level());
        Collection collection = this.getActiveEffects();
        for (MobEffectInstance mobeffectinstance : collection) {
            brot.addEffect(new MobEffectInstance(mobeffectinstance));
        }
        brot.setKills(this.getKills());
        brot.setEvoPoints(this.getEvoPoints() - (Integer)SConfig.SERVER.min_kills_hyper.get());
        brot.setCustomName(this.getCustomName());
        brot.setPos(this.getX(), this.getY(), this.getZ());
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            brot.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.getOnPos()), MobSpawnType.CONVERSION, null);
        }
        this.level().addFreshEntity((Entity)brot);
        this.discard();
        EvolvingInfected.super.HyperEvolve(living);
    }

    @Override
    public String origin() {
        return "minecraft:evoker";
    }
}

