/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class Jagdhund
extends EvolvedInfected {
    private static final EntityDataAccessor<Boolean> UNDERGROUND = SynchedEntityData.defineId(Jagdhund.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> BORROW = SynchedEntityData.defineId(Jagdhund.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> EMERGE = SynchedEntityData.defineId(Jagdhund.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Jagdhund(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.jagd_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.jagd_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.jagd_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 46.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.jagd_loot.get();
    }

    public void setUnderground(boolean value) {
        this.entityData.set(UNDERGROUND, (Object)value);
    }

    public boolean isUnderground() {
        return (Boolean)this.entityData.get(UNDERGROUND);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("underground", ((Boolean)this.entityData.get(UNDERGROUND)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(UNDERGROUND, (Object)tag.getBoolean("underground"));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(UNDERGROUND, (Object)false);
        builder.define(BORROW, (Object)0);
        builder.define(EMERGE, (Object)0);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f){

            public boolean canUse() {
                return super.canUse() && !Jagdhund.this.isUnderground();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, 1.5, false){

            @Override
            protected void checkAndPerformAttack(LivingEntity entity, double at) {
                if (!Jagdhund.this.isUnderground() || Jagdhund.this.isEmerging()) {
                    super.checkAndPerformAttack(entity, at);
                }
            }

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 6.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    public void tick() {
        super.tick();
        LivingEntity target = this.getTarget();
        if (this.tickCount % 20 == 0 && (!this.isSoftEnough(this.getOnPos()) || this.isInFluidType()) && this.isUnderground() && !this.isEmerging()) {
            this.tickEmerging();
        }
        if (this.tickCount % 10 == 0 && target != null) {
            if (target.distanceToSqr((Entity)this) > 100.0 && !this.isUnderground() && !this.isBurrowing() && this.isSoftEnough(this.getOnPos())) {
                this.tickBurrowing();
            }
            if (target.distanceToSqr((Entity)this) < 50.0 && this.isUnderground() && !this.isEmerging()) {
                this.tickEmerging();
            }
        }
        if (this.isEmerging() || this.isBurrowing()) {
            this.SummonParticles(this.getOnPos());
        }
        if (this.navigation.isInProgress() && this.isUnderground()) {
            this.SummonParticles(this.getOnPos());
        }
        if (this.isEmerging()) {
            this.tickEmerging();
        } else if (this.isBurrowing()) {
            this.tickBurrowing();
        }
    }

    private void SummonParticles(BlockPos pos) {
        for (int l = 0; l < this.random.nextInt(3, 6); ++l) {
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            int xi = this.random.nextInt(-1, 1);
            int zi = this.random.nextInt(-1, 1);
            if (this.level().getBlockState(pos).getBlock().asItem() == ItemStack.EMPTY.getItem()) continue;
            serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)this.level().getBlockState(pos).getBlock())), this.getX() + (double)xi, this.getY() - 0.1, this.getZ() + (double)zi, 3, ((double)this.random.nextFloat() - 1.0) * 0.08, ((double)this.random.nextFloat() - 1.0) * 0.08, ((double)this.random.nextFloat() - 1.0) * 0.08, (double)0.15f);
        }
    }

    public boolean isInvisible() {
        return this.isUnderground() && !this.isEmerging();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return super.canDrownInFluidType(type) && !this.isUnderground();
    }

    private boolean isSoftEnough(BlockPos pos) {
        return this.level().getBlockState(pos).getDestroySpeed((BlockGetter)this.level(), pos) < 4.0f;
    }

    public boolean isEmerging() {
        return (Integer)this.entityData.get(EMERGE) > 0;
    }

    public void tickEmerging() {
        int emerging = (Integer)this.entityData.get(EMERGE);
        if (emerging > this.getEmerge_tick()) {
            this.setUnderground(false);
            emerging = -1;
        }
        this.entityData.set(EMERGE, (Object)(emerging + 1));
    }

    public boolean isBurrowing() {
        return (Integer)this.entityData.get(BORROW) > 0;
    }

    public void tickBurrowing() {
        int burrowing = (Integer)this.entityData.get(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            this.setUnderground(true);
            burrowing = -1;
        }
        this.entityData.set(BORROW, (Object)(burrowing + 1));
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.HUNGER, 1200, 0));
        }
        return super.doHurtTarget(entity);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.EXPLOSION)) {
            return super.hurt(source, amount);
        }
        if (this.isUnderground() || this.isEmerging() || this.isBurrowing()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        super.onSyncedDataUpdated(accessor);
        if (UNDERGROUND.equals(accessor)) {
            this.refreshDimensions();
        }
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isUnderground()) {
            EntityDimensions baseDimensions = super.getDefaultDimensions(pose);
            return baseDimensions.scale(1.2f, 0.1f);
        }
        return super.getDefaultDimensions(pose);
    }

    public int getEmerge() {
        return (Integer)this.entityData.get(EMERGE);
    }

    public int getBorrow() {
        return (Integer)this.entityData.get(BORROW);
    }

    public int getBorrow_tick() {
        return 60;
    }

    public int getEmerge_tick() {
        return 60;
    }

    protected SoundEvent getAmbientSound() {
        return this.isUnderground() ? null : Ssounds.HUSK_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (this.isUnderground()) {
            this.playSound(state.getSoundType((LevelReader)this.level(), pos, (Entity)this).getBreakSound(), 0.15f, 0.5f);
        } else {
            this.playSound(this.getStepSound(), 0.15f, 1.0f);
        }
    }
}

