/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedWallMovementControl;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Spotion;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.UseItemGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Mephetic
extends EvolvedInfected
implements RangedAttackMob {
    private final List<ItemStack> potions = new ArrayList<ItemStack>();
    private int attackAnimationTick;
    private int throwAnimationTick;
    private int mouthAnimationTick;
    private int ticksBeforeThrown;

    public Mephetic(EntityType<? extends Infected> type, Level level) {
        super(type, level);
        this.navigation = new WallClimberNavigation((Mob)this, level);
        this.moveControl = new InfectedWallMovementControl((Mob)this);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, this, 1.0, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 6.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(2, (Goal)new UseItemGoal((Mob)this, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_FIRE_RESISTANCE), SoundEvents.WITCH_DRINK, p_35882_ -> this.isOnFire() && !this.hasEffect(MobEffects.FIRE_RESISTANCE) && (Boolean)SConfig.SERVER.use_potions.get() != false));
        this.goalSelector.addGoal(3, (Goal)new UseItemGoal((Mob)this, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER_BREATHING), SoundEvents.WITCH_DRINK, p_35882_ -> this.isInWater() && !this.hasEffect(MobEffects.WATER_BREATHING) && (Boolean)SConfig.SERVER.use_potions.get() != false));
        this.goalSelector.addGoal(4, new DrinkPotionGoal<Mephetic>(this, SoundEvents.WITCH_DRINK));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_mep_loot.get();
    }

    public void handleEntityEvent(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
        } else if (value == 5) {
            this.mouthAnimationTick = 10;
        } else if (value == 6) {
            this.throwAnimationTick = 10;
        } else {
            super.handleEntityEvent(value);
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 200, 1));
        }
        return super.doHurtTarget(entity);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.throwAnimationTick > 0) {
            --this.throwAnimationTick;
        }
        if (this.mouthAnimationTick > 0) {
            --this.mouthAnimationTick;
        }
        if (this.ticksBeforeThrown <= 80) {
            ++this.ticksBeforeThrown;
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public int getThrowAnimationTick() {
        return this.throwAnimationTick;
    }

    public int getMouthAnimationTick() {
        return this.mouthAnimationTick;
    }

    public void tick() {
        super.tick();
        if (this.ticksBeforeThrown == 40) {
            this.loadPotions();
        }
        LivingEntity living = this.getTarget();
        if (this.ticksBeforeThrown >= 79 && living != null && this.hasLineOfSight((Entity)living) && living.distanceToSqr((Entity)this) > 20.0) {
            this.throwPotions(living);
        }
        if (this.tickCount % 200 == 0 && living != null && this.hasLineOfSight((Entity)living) && living.distanceToSqr((Entity)this) > 60.0) {
            this.throwLingeringPotions(living);
        }
    }

    private Holder<Potion> getAttackPotion() {
        Random rand = new Random();
        List ev = (List)SConfig.SERVER.mep_potions.get();
        int randomIndex = rand.nextInt(ev.size());
        ResourceLocation randomElement1 = ResourceLocation.parse((String)((String)ev.get(randomIndex)));
        Holder<Potion> potion = Utilities.tryToCreatePotion(randomElement1);
        LivingEntity living = this.getTarget();
        if (living != null && living.getType().is(EntityTypeTags.UNDEAD)) {
            if (potion == null) {
                return Potions.HEALING;
            }
            if (potion.equals((Object)Potions.HARMING)) {
                return Potions.HEALING;
            }
            if (potion.equals((Object)Potions.POISON)) {
                return Spotion.MYCELIUM_POTION;
            }
        }
        return potion;
    }

    public void loadPotions() {
        this.potions.clear();
        for (int i = 0; i < 3; ++i) {
            this.potions.add(PotionContents.createItemStack((Item)Items.SPLASH_POTION, this.getAttackPotion()));
        }
    }

    public void throwPotions(LivingEntity living) {
        this.throwAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)6);
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        for (int i = 0; i < this.potions.size(); ++i) {
            this.performRangedAttack(living, i);
        }
        this.potions.clear();
        this.ticksBeforeThrown = 0;
    }

    public void throwLingeringPotions(LivingEntity living) {
        this.mouthAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)5);
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        int u = this.random.nextInt(1, 6);
        for (int i = 0; i < u; ++i) {
            this.lingeringPotionThrow(living, this.getAttackPotion());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.mep_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.mep_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.mep_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    public List<ItemStack> getPotions() {
        return this.potions;
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.WITCH_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public void performRangedAttack(LivingEntity entity, float v) {
        ItemStack potion = this.potions.get((int)v);
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = entity.getX() + vec3.x - this.getX();
        double d1 = entity.getEyeY() - (double)1.1f - this.getY();
        double d2 = entity.getZ() + vec3.z - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        ThrownPotion thrownpotion = new ThrownPotion(this.level(), (LivingEntity)this);
        thrownpotion.setItem(potion);
        thrownpotion.setXRot(thrownpotion.getXRot() - -20.0f);
        thrownpotion.shoot(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
        this.level().addFreshEntity((Entity)thrownpotion);
    }

    public void lingeringPotionThrow(LivingEntity entity, Holder<Potion> potion) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = entity.getX() + vec3.x - this.getX();
        double d1 = entity.getEyeY() - (double)1.1f - this.getY();
        double d2 = entity.getZ() + vec3.z - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        ThrownPotion thrownpotion = new ThrownPotion(this.level(), (LivingEntity)this);
        thrownpotion.setItem(PotionContents.createItemStack((Item)Items.LINGERING_POTION, potion));
        thrownpotion.setXRot(thrownpotion.getXRot() - -20.0f);
        thrownpotion.shoot(d0, d1 + d3 * 0.4, d2, 1.0f, 8.0f);
        this.level().addFreshEntity((Entity)thrownpotion);
    }

    public static class DrinkPotionGoal<T extends Mob>
    extends Goal {
        private final T mob;
        private final ItemStack healingPotion = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.HEALING);
        private final ItemStack strengthPotion = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.STRENGTH);
        private final ItemStack speedPotion = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.SWIFTNESS);
        @Nullable
        private final SoundEvent finishUsingSound;

        public DrinkPotionGoal(T mob, @Nullable SoundEvent finishUsingSound) {
            this.mob = mob;
            this.finishUsingSound = finishUsingSound;
        }

        public boolean canUse() {
            return this.mob.getHealth() < this.mob.getMaxHealth();
        }

        public boolean canContinueToUse() {
            return this.mob.isUsingItem();
        }

        public void start() {
            this.mob.setItemSlot(EquipmentSlot.MAINHAND, this.healingPotion.copy());
            this.mob.startUsingItem(InteractionHand.MAIN_HAND);
            if (Math.random() < 0.2) {
                this.mob.setItemSlot(EquipmentSlot.OFFHAND, Math.random() < 0.5 ? this.strengthPotion.copy() : this.speedPotion.copy());
            }
        }

        public void stop() {
            Holder potion;
            PotionContents potionContents;
            if (!this.mob.getOffhandItem().isEmpty() && (potionContents = (PotionContents)this.mob.getOffhandItem().get(DataComponents.POTION_CONTENTS)) != null && (potion = (Holder)potionContents.potion().orElse(null)) != null) {
                if (potion.equals((Object)Potions.STRENGTH)) {
                    this.mob.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 3600));
                }
                if (potion.equals((Object)Potions.SWIFTNESS)) {
                    this.mob.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 3600));
                }
            }
            this.mob.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            this.mob.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
            if (this.finishUsingSound != null) {
                this.mob.playSound(this.finishUsingSound, 1.0f, this.mob.getRandom().nextFloat() * 0.2f + 0.9f);
            }
        }
    }
}

