/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.ArmedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedPlayer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.HasUsableSlot;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public class Nuclealave
extends EvolvedInfected
implements RangedAttackMob,
ArmedInfected,
HasUsableSlot {
    public Nuclealave(EntityType<? extends Infected> type, Level level) {
        super(type, level);
        if (!this.isNoAi() && GoalUtils.hasGroundPathNavigation((Mob)this)) {
            ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.nucke_loot.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.nuckelave_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.nuckelave_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.nuckelave_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_219059_, DifficultyInstance p_219060_) {
        InfectedPlayer.createName((LivingEntity)this, (List)SConfig.DATAGEN.name.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.HEAD, (List)SConfig.DATAGEN.player_h.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.CHEST, (List)SConfig.DATAGEN.player_c.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.LEGS, (List)SConfig.DATAGEN.player_l.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.FEET, (List)SConfig.DATAGEN.player_b.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.MAINHAND, (List)SConfig.DATAGEN.player_hm.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.OFFHAND, (List)SConfig.DATAGEN.player_ho.get());
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.populateDefaultEquipmentSlots(this.random, difficulty);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public void awardKillScore(Entity entity, int i, DamageSource damageSource) {
        super.awardKillScore(entity, i, damageSource);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = living.getItemBySlot(slot);
                if (this.getItemBySlot(slot) != ItemStack.EMPTY || stack == ItemStack.EMPTY) continue;
                this.setItemSlot(slot, stack);
            }
        }
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal(this, 1.1f, 50, 20.0f){

            public boolean canUse() {
                return Nuclealave.this.canDoRangedAttacks() && super.canUse();
            }

            public void start() {
                super.start();
                Nuclealave.this.setAggressive(true);
            }

            public void stop() {
                super.stop();
                Nuclealave.this.setAggressive(false);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, 1.3, false){

            @Override
            public boolean canUse() {
                return !Nuclealave.this.canDoRangedAttacks() && super.canUse();
            }

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean canDoRangedAttacks() {
        LivingEntity living = this.getTarget();
        if (this.getMainHandItem().getItem() instanceof BowItem || this.getOffhandItem().getItem() instanceof BowItem) {
            return living != null && living.distanceToSqr((Entity)this) > 100.0;
        }
        return false;
    }

    private boolean hasFireCapabilities() {
        return this.getMainHandItem().getItem() instanceof FlintAndSteelItem || this.getOffhandItem().getItem() instanceof FlintAndSteelItem;
    }

    private boolean canShield() {
        return this.getMainHandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK) || this.getOffhandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK);
    }

    private ItemStack getShieldInHand() {
        if (this.getMainHandItem().getItem() instanceof ShieldItem) {
            return this.getMainHandItem();
        }
        return this.getOffhandItem();
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        Entity entity;
        if (this.canShield() && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (Math.random() < (double)0.35f) {
                this.playSound(SoundEvents.SHIELD_BLOCK);
                this.getShieldInHand().hurtAndBreak((int)amount, living, EquipmentSlot.MAINHAND);
                return false;
            }
        }
        return super.hurt(source, amount);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (this.hasFireCapabilities()) {
            entity.setRemainingFireTicks(200);
        }
        return super.doHurtTarget(entity);
    }

    protected AbstractArrow getArrow(ItemStack p_32156_, float p_32157_) {
        return ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)p_32156_, (float)p_32157_, null);
    }

    public void performRangedAttack(LivingEntity entity, float v) {
        ItemStack itemstack = this.getProjectile(this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, v);
        if (this.getMainHandItem().getItem() instanceof BowItem) {
            abstractarrow = ((BowItem)this.getMainHandItem().getItem()).customArrow(abstractarrow, ItemStack.EMPTY, ItemStack.EMPTY);
        }
        double d0 = entity.getX() - this.getX();
        double d1 = entity.getY(0.3333333333333333) - abstractarrow.getY();
        double d2 = entity.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        if (abstractarrow instanceof Arrow) {
            Arrow arrow = (Arrow)abstractarrow;
            arrow.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600));
            if (this.hasFireCapabilities()) {
                arrow.setRemainingFireTicks(200);
            }
        }
        abstractarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.CROSSBOW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)abstractarrow);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.ADVENTURER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.HORSE_STEP;
    }

    @Override
    public boolean hasUsableSlot(EquipmentSlot slot) {
        return true;
    }
}

