/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.ArmedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedPlayer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.HasUsableSlot;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SdamageTypes;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Protector
extends EvolvedInfected
implements ArmedInfected,
HasUsableSlot,
RangedAttackMob {
    public static final EntityDataAccessor<Boolean> SHIELDED = SynchedEntityData.defineId(Protector.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> PEARLS = SynchedEntityData.defineId(Protector.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int ticksUnShielded;

    public Protector(EntityType<? extends Infected> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(3, (Goal)new ProtectorMeleeGoal(this, (float)((Double)SConfig.SERVER.protector_damage.get() * (Double)SConfig.SERVER.global_damage.get())));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_protector_loot.get();
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.3) {
            return SdamageTypes.knight_damage((LivingEntity)this);
        }
        return super.getCustomDamage(entity);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.protector_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.protector_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.protector_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public boolean getShielded() {
        return (Boolean)this.entityData.get(SHIELDED);
    }

    public void setShielded(boolean value) {
        this.entityData.set(SHIELDED, (Object)value);
    }

    public int getPearls() {
        return (Integer)this.entityData.get(PEARLS);
    }

    public void setPearls(int e) {
        this.entityData.set(PEARLS, (Object)e);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHIELDED, (Object)false);
        builder.define(PEARLS, (Object)1);
    }

    @Override
    public void awardKillScore(Entity entity, int i, DamageSource damageSource) {
        super.awardKillScore(entity, i, damageSource);
        if (entity instanceof EnderMan) {
            this.setPearls(this.getPearls() + this.random.nextInt(3));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setShielded(tag.getBoolean("shield"));
        this.setPearls(tag.getInt("pearls"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("shield", this.getShielded());
        tag.putInt("pearls", this.getPearls());
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.ADVENTURER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public void tick() {
        double distance;
        LivingEntity entity;
        super.tick();
        if (this.ticksUnShielded > 0) {
            --this.ticksUnShielded;
        }
        if (this.tickCount % 200 == 0) {
            this.setShielded(false);
        }
        if (this.tickCount % 40 == 0 && (entity = this.getTarget()) != null && (distance = (double)this.distanceTo((Entity)entity)) > 20.0 && this.getPearls() > 0 && this.hasLineOfSight((Entity)entity)) {
            this.performRangedAttack(entity, 0.0f);
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        LivingEntity livingEntity;
        Entity entity = source.getEntity();
        LivingEntity target = this.getTarget();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).equals((Object)target)) {
            ItemStack stack = livingEntity.getMainHandItem();
            if (this.getShielded() && stack.canDisableShield(stack, (LivingEntity)this, livingEntity)) {
                this.ticksUnShielded = 200;
                this.playSound(SoundEvents.SHIELD_BREAK);
                this.setShielded(false);
            }
            if (this.getShielded() && this.isLookingAtMe(livingEntity)) {
                this.playSound(SoundEvents.SHIELD_BLOCK);
                return false;
            }
        } else if (entity != null && this.getShielded()) {
            this.playSound(SoundEvents.SHIELD_BREAK);
            this.ticksUnShielded = 100;
        }
        return super.hurt(source, amount);
    }

    public void onSyncedDataUpdated(List<SynchedEntityData.DataValue<?>> values) {
        super.onSyncedDataUpdated(values);
        for (SynchedEntityData.DataValue<?> value : values) {
            if (!value.value().equals(SHIELDED)) continue;
            AttributeInstance attributes = this.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributes == null) break;
            attributes.setBaseValue(this.getShielded() ? 0.1 : 0.2);
            break;
        }
    }

    boolean isLookingAtMe(LivingEntity entity) {
        double angleThreshold;
        Vec3 toThis;
        Vec3 lookVec = entity.getViewVector(1.0f).normalize();
        double dot = lookVec.dot(toThis = new Vec3(this.getX() - entity.getX(), this.getEyeY() - entity.getEyeY(), this.getZ() - entity.getZ()).normalize());
        return dot > (angleThreshold = 0.9) && entity.hasLineOfSight((Entity)this);
    }

    @Override
    public boolean hasUsableSlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.FEET || slot == EquipmentSlot.HEAD;
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_219059_, DifficultyInstance p_219060_) {
        InfectedPlayer.createName((LivingEntity)this, (List)SConfig.DATAGEN.name.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.HEAD, (List)SConfig.DATAGEN.player_h.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.FEET, (List)SConfig.DATAGEN.player_b.get());
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.populateDefaultEquipmentSlots(this.random, difficulty);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public void die(DamageSource source) {
        super.die(source);
    }

    public void performRangedAttack(LivingEntity livingEntity, float v) {
        if (!this.level().isClientSide) {
            ThrownEnderpearl pearl = new ThrownEnderpearl(this.level(), (LivingEntity)this);
            double d0 = livingEntity.getEyeY() - this.getEyeY();
            double d1 = livingEntity.getX() - this.getX();
            double d2 = d0;
            double d3 = livingEntity.getZ() - this.getZ();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3) * 0.2;
            pearl.setOwner((Entity)this);
            pearl.shoot(d1, d2 + d4, d3, 1.6f, 12.0f);
            this.playSound(SoundEvents.ENDER_PEARL_THROW, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)pearl);
            this.setPearls(this.getPearls() - 1);
        }
    }

    public static class ProtectorMeleeGoal
    extends CustomMeleeAttackGoal {
        private final float meleeDamage;

        public ProtectorMeleeGoal(Protector mob, float meleeDamage) {
            super(mob, 1.2, false);
            this.meleeDamage = meleeDamage;
        }

        @Override
        protected double getAttackReachSqr(LivingEntity entity) {
            return 4.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
        }

        @Override
        protected void checkAndPerformAttack(LivingEntity entity, double at) {
            PathfinderMob pathfinderMob = this.mob;
            if (pathfinderMob instanceof Protector) {
                Protector protector;
                double distance = (protector = (Protector)pathfinderMob).distanceTo((Entity)entity);
                protector.setShielded(distance < 15.0 && protector.ticksUnShielded <= 0);
                if (protector.getShielded() && entity.getHealth() > this.meleeDamage) {
                    double d0 = this.getAttackReachSqr(entity);
                    if (at <= d0 && this.ticksUntilNextAttack <= 0 && protector.hasLineOfSight((Entity)entity)) {
                        this.resetAttackCooldown(20);
                        this.mob.playSound(SoundEvents.SHIELD_BLOCK);
                        this.mob.swing(InteractionHand.MAIN_HAND);
                        entity.hurtMarked = true;
                        if (entity instanceof Mob) {
                            Mob mob1 = (Mob)entity;
                            mob1.setTarget((LivingEntity)this.mob);
                        }
                        entity.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 100, 0));
                        entity.knockback((double)1.2f, (double)Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)))));
                    }
                } else {
                    super.checkAndPerformAttack(entity, at);
                }
            }
        }
    }
}

