/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.HybridPathNavigation;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.Harbinger.Spore.Sentities.Utility.GastGeber;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import com.Harbinger.Spore.Sentities.WaterInfected;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class Scamper
extends EvolvedInfected
implements WaterInfected,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(Scamper.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> AGE = SynchedEntityData.defineId(Scamper.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int deployClock = 0;
    public boolean deploying;

    public Scamper(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.setPersistenceRequired();
        this.navigation = new HybridPathNavigation((Mob)this, this.level());
    }

    @Override
    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isDeploying() {
        return this.deploying;
    }

    public void setDeploying(boolean deploying) {
        this.deploying = deploying;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.sca_loot.get();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("age", ((Integer)this.entityData.get(AGE)).intValue());
        tag.putInt("Variant", this.getTypeVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(AGE, (Object)tag.getInt("age"));
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(AGE, (Object)0);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void setAge(int e) {
        this.entityData.set(AGE, (Object)e);
    }

    public int getAge() {
        return (Integer)this.entityData.get(AGE);
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (this.getVariant() == ScamperVariants.DROWNED) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    @Override
    public void travel(Vec3 vec3) {
        super.travel(vec3);
        if (this.isEffectiveAi() && this.isInFluidType() && this.getVariant() == ScamperVariants.DROWNED) {
            this.moveRelative(0.1f, vec3);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.85));
        } else {
            if (this.isInFluidType() && this.getVariant() != ScamperVariants.DROWNED) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
            }
            super.travel(vec3);
        }
    }

    public void tick() {
        if (this.isAlive() && this.deployClock > 0) {
            --this.deployClock;
        }
        if (this.deployClock == 0) {
            this.deploying = false;
        }
        if (this.isAlive() && this.tickCount % 20 == 0) {
            this.setAge(this.getAge() + 1);
            if (this.getAge() >= (Integer)SConfig.SERVER.scamper_age.get() && !this.level().isClientSide) {
                if (this.getLinked() && Math.random() < (double)0.3f || this.getEvoPoints() >= (Integer)SConfig.SERVER.min_kills_hyper.get()) {
                    GastGeber geber = new GastGeber((EntityType<? extends Infected>)Sentities.GASTGABER.get(), this.level());
                    geber.setKills(this.getKills() + this.getEvoPoints());
                    geber.moveTo(this.position());
                    this.level().addFreshEntity((Entity)geber);
                } else {
                    int chance = this.random.nextInt(1, 3);
                    int age = this.random.nextInt(1, 4);
                    if (((Boolean)SConfig.SERVER.scamper_summon.get()).booleanValue()) {
                        this.Summon(4);
                    }
                    for (int i = 0; i < chance; ++i) {
                        if (!((Boolean)SConfig.SERVER.scamper_summon.get()).booleanValue()) continue;
                        this.Summon(age);
                    }
                    if (((Boolean)SConfig.SERVER.scent_spawn.get()).booleanValue()) {
                        this.SummonScent();
                    }
                    this.level().setBlock(new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ()), ((Block)Sblocks.REMAINS.get()).defaultBlockState(), 2);
                }
                Level age = this.level();
                if (age instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)age;
                    double x0 = this.getX() - ((double)this.random.nextFloat() - 0.1) * 0.1;
                    double y0 = this.getY() + ((double)this.random.nextFloat() - 0.25) * 0.15 * 5.0;
                    double z0 = this.getZ() + ((double)this.random.nextFloat() - 0.1) * 0.1;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
                }
                this.discard();
            }
        }
        super.tick();
    }

    private void Summon(int i) {
        RandomSource randomSource = RandomSource.create();
        Mound mound = new Mound(Sentities.MOUND.get(), this.level());
        int vecx = randomSource.nextInt(-3, 3);
        int vecz = randomSource.nextInt(-3, 3);
        mound.moveTo(this.getX() + (double)vecx, this.getY(), this.getZ() + (double)vecz);
        mound.setMaxAge(i);
        mound.setLinked(this.getLinked());
        mound.tickEmerging();
        mound.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0));
        this.level().addFreshEntity((Entity)mound);
    }

    private void SummonScent() {
        ScentEntity scent = new ScentEntity(Sentities.SCENT.get(), this.level());
        scent.moveTo(this.getX(), this.getY() + (double)0.4f, this.getZ());
        this.level().addFreshEntity((Entity)scent);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new CustomMeleeAttackGoal(this, 1.2, true));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.scamper_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.scamper_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.scamper_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.ATTACK_KNOCKBACK, 0.0);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.SCAMPER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public ScamperVariants getVariant() {
        return ScamperVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        if (i > ScamperVariants.values().length || i < 0) {
            this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)0);
        } else {
            this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)i);
        }
    }

    @Override
    public int amountOfMutations() {
        return ScamperVariants.values().length;
    }

    public void setVariant(ScamperVariants variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600, 1), (Entity)this);
                if (this.deployClock == 0 && !this.isDeploying()) {
                    this.setDeploying(true);
                    Scamper.setcloud((LivingEntity)this);
                    this.deployClock = 800;
                }
            }
            return true;
        }
        return false;
    }

    public static void setcloud(LivingEntity entity) {
        if (!entity.level().isClientSide) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(entity.level(), entity.getX(), entity.getY(), entity.getZ());
            areaeffectcloud.setOwner(entity);
            areaeffectcloud.setRadius(2.0f);
            areaeffectcloud.setDuration(600);
            areaeffectcloud.setRadiusPerTick((4.0f - areaeffectcloud.getRadius()) / (float)areaeffectcloud.getDuration());
            areaeffectcloud.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 200, 1));
            entity.level().addFreshEntity((Entity)areaeffectcloud);
        }
    }
}

