/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.FlyingInfected;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedArialMovementControl;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Scavenger
extends EvolvedInfected
implements FlyingInfected {
    private int screams;
    private int ticksAggressive;

    public Scavenger(EntityType<? extends Infected> type, Level level) {
        super(type, level);
        this.moveControl = new InfectedArialMovementControl((Mob)this, 20, false);
        this.navigation = new FlyingPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.scavenger_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.scavenger_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.scavenger_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.FLYING_SPEED, 0.4);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.scavenger_loot.get();
    }

    public boolean canAttack() {
        return this.ticksAggressive > 0 || this.checkForHelp();
    }

    public boolean causeFallDamage(float p_147105_, float p_147106_, DamageSource p_147107_) {
        return false;
    }

    @Override
    public void travel(Vec3 vec) {
        if (this.isEffectiveAi() && !this.onGround()) {
            this.moveRelative(0.1f, vec);
            this.move(MoverType.SELF, this.getDeltaMovement().scale(this.isInWater() ? 0.2 : 1.0));
            this.setDeltaMovement(this.getDeltaMovement().scale(0.85));
        } else {
            super.travel(vec);
        }
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.01, 0.0));
    }

    private boolean checkForHelp() {
        LivingEntity living = this.getTarget();
        if (living == null) {
            return false;
        }
        if (living.getHealth() <= living.getMaxHealth() / 2.0f) {
            return true;
        }
        List infected = this.level().getEntities((Entity)this, living.getBoundingBox().inflate(3.0), entity -> entity instanceof Infected || entity instanceof UtilityEntity);
        return !infected.isEmpty();
    }

    public void tick() {
        super.tick();
        LivingEntity living = this.getTarget();
        if (living != null && !this.canAttack()) {
            this.moveToTarget(living, 150.0);
        }
        if (this.ticksAggressive > 0) {
            --this.ticksAggressive;
        }
    }

    public void scream(LivingEntity living) {
        if (this.screams > 3) {
            this.ticksAggressive = 200;
            this.screams = 0;
            return;
        }
        this.playSound(Ssounds.SCAVENGER_SCREECH.get());
        ++this.screams;
        this.screamForHelp(living);
    }

    public void screamForHelp(LivingEntity living) {
        AABB aabb = this.getBoundingBox().inflate(48.0);
        List infected = this.level().getEntities((Entity)this, aabb, entity -> entity instanceof Infected);
        for (Entity entity2 : infected) {
            Infected infected1;
            if (!(entity2 instanceof Infected) || (infected1 = (Infected)entity2).getTarget() != null) continue;
            infected1.setTarget(living);
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() != null) {
            this.ticksAggressive = 200;
        }
        return super.hurt(source, amount);
    }

    private void moveToTarget(LivingEntity living, double range) {
        double distance = this.distanceToSqr((Entity)living);
        if (this.tickCount % 80 == 0) {
            this.scream(living);
        }
        if (distance >= range) {
            if (this.tickCount % 20 == 0) {
                this.getNavigation().moveTo((Entity)living, 1.0);
            }
        } else if (distance < range * 0.75) {
            if (this.tickCount % 20 == 0) {
                Vec3 vec3 = Utilities.generatePositionAway(living.position(), 10.0);
                this.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, 1.5);
            }
        } else if (this.getNavigation().isDone()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0).add(living.position().subtract(this.position()).normalize().yRot(90.0f)).scale(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 2.0));
        } else {
            this.getNavigation().stop();
        }
        if (this.getY() < living.getY() + 4.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.1, 0.0));
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.HUNGER, 1200, 0));
        }
        return super.doHurtTarget(entity);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new CustomMeleeAttackGoal(this, 1.5, false){

            @Override
            public boolean canUse() {
                return Scavenger.this.canAttack() && super.canUse();
            }

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INF_VILLAGER_GROWL.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_VILLAGER_DEATH.get();
    }
}

