/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.PullGoal;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.SlasherVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SdamageTypes;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Slasher
extends EvolvedInfected
implements ArmorPersentageBypass,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(Slasher.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Slasher(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.sla_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.22).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.sla_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.sla_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.ATTACK_KNOCKBACK, 0.0);
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (this.getVariant() == SlasherVariants.PIERCER) {
            return SdamageTypes.slasher_piercing_damage(entity);
        }
        if (Math.random() < 0.3) {
            return SdamageTypes.slasher_damage((LivingEntity)this);
        }
        return super.getCustomDamage(entity);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_slasher_loot.get();
    }

    public boolean canDisableShield() {
        if (this.getVariant() == SlasherVariants.PIERCER) {
            return true;
        }
        return super.canDisableShield();
    }

    public double getRanges() {
        return this.getVariant() == SlasherVariants.GRABBER ? 1.5 : 1.0;
    }

    public boolean pull() {
        if (this.getVariant() == SlasherVariants.PIERCER || this.getVariant() == SlasherVariants.SMASHER) {
            return false;
        }
        LivingEntity living = this.getTarget();
        return living != null && this.distanceToSqr((Entity)living) < 32.0 * this.getRanges() && this.distanceToSqr((Entity)living) > 16.0 * this.getRanges() && this.hasLineOfSight((Entity)living);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new AOEMeleeAttackGoal(this, 1.2, true, 1.2, 3.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.goalSelector.addGoal(1, (Goal)new PullGoal((Mob)this, 32.0, 16.0){

            @Override
            public boolean canUse() {
                return Slasher.this.pull();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (this.getVariant() == SlasherVariants.PIERCER && !player.isBlocking()) {
                for (int i = 0; i < Inventory.ALL_ARMOR_SLOTS.length; ++i) {
                    EquipmentSlot equipmentSlot = EquipmentSlot.values()[i + 2];
                    player.getInventory().getArmor(i).hurtAndBreak(10, (LivingEntity)this, equipmentSlot);
                }
            }
        }
        if (this.getVariant() == SlasherVariants.SMASHER && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            livingEntity.hurtMarked = true;
            livingEntity.knockback(4.0, (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
        }
        if (this.getVariant() == SlasherVariants.GRABBER && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            if (!this.level().isClientSide && Math.random() < 0.15) {
                if (Math.random() < 0.5) {
                    this.dropItems(livingEntity, InteractionHand.MAIN_HAND, livingEntity.getOnPos());
                } else {
                    this.dropItems(livingEntity, InteractionHand.OFF_HAND, livingEntity.getOnPos());
                }
            }
        }
        return super.doHurtTarget(entity);
    }

    private void dropItems(LivingEntity living, InteractionHand hand, BlockPos pos) {
        ItemStack stack = living.getItemInHand(hand);
        if (stack == ItemStack.EMPTY) {
            return;
        }
        ItemEntity entity = new ItemEntity(this.level(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
        this.level().addFreshEntity((Entity)entity);
        living.setItemInHand(hand, ItemStack.EMPTY);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getTypeVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INF_VILLAGER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_VILLAGER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SlasherVariants variant = (SlasherVariants)((Object)Util.getRandom((Object[])SlasherVariants.values(), (RandomSource)this.random));
        this.setVariant(variant);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public SlasherVariants getVariant() {
        return SlasherVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(i > SlasherVariants.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return SlasherVariants.values().length;
    }

    private void setVariant(SlasherVariants variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public float amountOfDamage(float value) {
        return this.getVariant() == SlasherVariants.PIERCER ? (float)((Double)SConfig.SERVER.sla_damage.get() * (Double)SConfig.SERVER.global_damage.get() / 2.0) : 0.0f;
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }
}

