/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Projectile.AcidBall;
import com.Harbinger.Spore.Sentities.Projectile.BileProjectile;
import com.Harbinger.Spore.Sentities.Projectile.ThrownTumor;
import com.Harbinger.Spore.Sentities.Projectile.Vomit;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.SpitterVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Spitter
extends EvolvedInfected
implements RangedAttackMob,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(Spitter.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Spitter(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, 1.1, this.getShootingPerVariant(), this.getRangePerVariant()){

            public boolean canUse() {
                return Spitter.this.switchyFar() && super.canUse();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RangedAttackGoal(this, 1.1, 5, 5.0f){

            public boolean canUse() {
                return Spitter.this.switchyClose() && super.canUse();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_spitter_loot.get();
    }

    private boolean switchyFar() {
        if (this.getTarget() != null && (this.getTypeVariant() == 0 || this.getTypeVariant() == 3)) {
            double ze = this.distanceToSqr((Entity)this.getTarget());
            return ze > 32.0;
        }
        return true;
    }

    private boolean switchyClose() {
        if (this.getTarget() != null && (this.getTypeVariant() == 0 || this.getTypeVariant() == 3)) {
            double ze = this.distanceToSqr((Entity)this.getTarget());
            return ze < 32.0;
        }
        return false;
    }

    private int getShootingPerVariant() {
        return switch (this.getVariant()) {
            case SpitterVariants.BILE -> 50;
            case SpitterVariants.EXPLOSIVE -> 60;
            default -> 40;
        };
    }

    private int getRangePerVariant() {
        return this.getVariant() == SpitterVariants.SNIPER ? 32 : 16;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.spit_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ARMOR, (Double)SConfig.SERVER.spit_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        AttributeInstance instance;
        super.onSyncedDataUpdated(accessor);
        if (accessor.equals(DATA_ID_TYPE_VARIANT) && (instance = this.getAttribute(Attributes.FOLLOW_RANGE)) != null) {
            instance.setBaseValue(this.getTypeVariant() == 4 ? 64.0 : 32.0);
        }
    }

    public void performRangedAttack(LivingEntity target, float f) {
        if (this.level().isClientSide) {
            return;
        }
        double dx = target.getX() - this.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.0;
        double dz = target.getZ() - this.getZ();
        double dist = this.distanceToSqr((Entity)target);
        switch (this.getTypeVariant()) {
            case 1: {
                this.shootTumor(dx, dy, dz);
                break;
            }
            case 2: {
                this.shootBile(dx, dy, dz);
                break;
            }
            case 3: {
                this.shootCloseOrFar(target, dist, true);
                break;
            }
            case 4: {
                AcidBall.shoot((LivingEntity)this, target, (float)((Double)SConfig.SERVER.spit_damage_l.get() * (Double)SConfig.SERVER.global_damage.get()) * 2.0f);
                break;
            }
            default: {
                this.shootCloseOrFar(target, dist, false);
            }
        }
    }

    private void shootTumor(double dx, double dy, double dz) {
        ThrownTumor tumor = new ThrownTumor(this.level(), (LivingEntity)this);
        tumor.setMobEffect(Seffects.CORROSION);
        tumor.setExplode(Level.ExplosionInteraction.NONE);
        tumor.moveTo(this.getX(), this.getY() + 1.5, this.getZ());
        tumor.shoot(dx, dy - tumor.getY() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
        this.level().addFreshEntity((Entity)tumor);
    }

    private void shootBile(double dx, double dy, double dz) {
        BileProjectile bile = new BileProjectile(this.level(), (LivingEntity)this, this.TARGET_SELECTOR);
        bile.setDamage((float)((Double)SConfig.SERVER.spit_damage_l.get() * (Double)SConfig.SERVER.global_damage.get()));
        bile.moveTo(this.getX(), this.getY() + 1.5, this.getZ());
        bile.shoot(dx, dy - bile.getY() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
        this.level().addFreshEntity((Entity)bile);
    }

    private void shootCloseOrFar(LivingEntity target, double dist, boolean doubleShot) {
        if (dist < 32.0) {
            float dmg = (float)((Double)SConfig.SERVER.spit_damage_c.get() * (Double)SConfig.SERVER.global_damage.get());
            Vomit.shoot((LivingEntity)this, target, dmg);
            if (doubleShot) {
                Vomit.shoot((LivingEntity)this, target, dmg);
            }
        } else {
            float dmg = (float)((Double)SConfig.SERVER.spit_damage_l.get() * (Double)SConfig.SERVER.global_damage.get());
            AcidBall.shoot((LivingEntity)this, target, dmg);
            if (doubleShot) {
                AcidBall.shoot((LivingEntity)this, target, dmg);
            }
            this.playSound(SoundEvents.SLIME_JUMP, 1.0f, 0.5f);
        }
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getTypeVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INF_VILLAGER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setVariant((SpitterVariants)((Object)Util.getRandom((Object[])SpitterVariants.values(), (RandomSource)this.random)));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public SpitterVariants getVariant() {
        return SpitterVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(i >= 0 && i < SpitterVariants.values().length ? i : 0));
    }

    @Override
    public int amountOfMutations() {
        return SpitterVariants.values().length;
    }

    private void setVariant(SpitterVariants variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public String getMutation() {
        return this.getTypeVariant() != 0 ? this.getVariant().getName() : super.getMutation();
    }

    @Override
    public boolean hasLineOfSight(Entity entity) {
        return !entity.isInFluidType() && super.hasLineOfSight(entity);
    }
}

