/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.Hyper.Wendigo;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedWallMovementControl;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class Stalker
extends EvolvedInfected
implements EvolvingInfected {
    public static final EntityDataAccessor<Integer> CAMO = SynchedEntityData.defineId(Stalker.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int camo;

    public Stalker(EntityType<? extends Infected> type, Level level) {
        super(type, level);
        this.navigation = new WallClimberNavigation((Mob)this, level);
        this.moveControl = new InfectedWallMovementControl((Mob)this);
    }

    public void customServerAiStep() {
        this.setSprinting(this.isAggressive() && this.getTarget() != null && (this.getTarget().isSprinting() || this.getTarget().getHealth() < this.getTarget().getMaxHealth() / 2.0f));
        this.spawnSprintParticle();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_stalker_loot.get();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.goalSelector.addGoal(1, (Goal)new CustomMeleeAttackGoal(this, this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 4.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.stalker_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.stalker_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.stalker_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_KNOCKBACK, 2.0);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INF_PILLAGER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_VILLAGER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("camo", ((Integer)this.entityData.get(CAMO)).intValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(CAMO, (Object)tag.getInt("camo"));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CAMO, (Object)0);
    }

    public int getCamo() {
        return (Integer)this.entityData.get(CAMO);
    }

    public void setCamo(int i) {
        this.entityData.set(CAMO, (Object)i);
    }

    public int getBiomeTint() {
        int i = Mth.floor((double)this.getX());
        int j = Mth.floor((double)this.getY());
        int k = Mth.floor((double)this.getZ());
        BlockPos blockpos = new BlockPos(i, j, k);
        Biome biome = (Biome)this.level().getBiome(blockpos).value();
        return biome.getFoliageColor();
    }

    public void tick() {
        super.tick();
        this.tickHyperEvolution(this);
        if (this.camo <= 1200) {
            ++this.camo;
        } else {
            this.camo = 0;
            this.setCamo(this.getBiomeTint());
        }
    }

    @Override
    public void HyperEvolve(LivingEntity living) {
        Wendigo wendigo = new Wendigo(Sentities.WENDIGO.get(), this.level());
        Collection collection = this.getActiveEffects();
        for (MobEffectInstance mobeffectinstance : collection) {
            wendigo.addEffect(new MobEffectInstance(mobeffectinstance));
        }
        wendigo.setKills(this.getKills());
        wendigo.setEvoPoints(this.getEvoPoints() - (Integer)SConfig.SERVER.min_kills_hyper.get());
        wendigo.setCustomName(this.getCustomName());
        wendigo.setPos(this.getX(), this.getY(), this.getZ());
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            wendigo.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.getOnPos()), MobSpawnType.CONVERSION, null);
        }
        this.level().addFreshEntity((Entity)wendigo);
        this.discard();
        EvolvingInfected.super.HyperEvolve(living);
    }
}

