/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.VolatileSwellGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class Volatile
extends EvolvedInfected {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.defineId(Volatile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int swell;

    public Volatile(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new VolatileSwellGoal(this));
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 6.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_volatile_loot.get();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SWELL_DIR, (Object)-1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.vola_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.vola_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.vola_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        int randomIndex;
        List ev = (List)SConfig.SERVER.vola_buffs.get();
        ResourceLocation randomElement1 = ResourceLocation.parse((String)((String)ev.get(randomIndex = this.random.nextInt(ev.size()))));
        Holder<MobEffect> randomElement = Utilities.tryToCreateEffect(randomElement1);
        if (randomElement != null) {
            this.addEffect(new MobEffectInstance(randomElement, 600, 0));
        }
        return super.hurt(source, amount);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        int randomIndex;
        List ev = (List)SConfig.SERVER.vola_debuffs.get();
        ResourceLocation randomElement1 = ResourceLocation.parse((String)((String)ev.get(randomIndex = this.random.nextInt(ev.size()))));
        Holder<MobEffect> randomElement = Utilities.tryToCreateEffect(randomElement1);
        if (randomElement != null && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(randomElement, 600, 0));
        }
        return super.doHurtTarget(entity);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.WITCH_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public int getSwellDir() {
        return (Integer)this.entityData.get(DATA_SWELL_DIR);
    }

    public void tick() {
        super.tick();
        if (this.isAlive()) {
            int i = this.getSwellDir();
            if (i > 0 && this.swell == 0) {
                this.playSound(SoundEvents.CREEPER_PRIMED, 1.0f, 0.5f);
                this.gameEvent((Holder)GameEvent.PRIME_FUSE);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= 40) {
                this.swell = 40;
                this.explodeVolatile();
            }
        }
    }

    private void explodeVolatile() {
        if (!this.level().isClientSide) {
            Level.ExplosionInteraction explosion$blockinteraction = EventHooks.canEntityGrief((Level)this.level(), (Entity)this) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)((Integer)SConfig.SERVER.volatile_explosion.get()).intValue(), explosion$blockinteraction);
            this.discard();
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            areaeffectcloud.setRadius(5.5f);
            areaeffectcloud.setRadiusOnUse(-0.5f);
            areaeffectcloud.setWaitTime(20);
            for (String string : (List)SConfig.SERVER.vola_debuffs.get()) {
                Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)string));
                if (effect == null) continue;
                areaeffectcloud.addEffect(new MobEffectInstance(effect, 600, 1));
            }
            areaeffectcloud.setDuration(areaeffectcloud.getDuration() / 2);
            areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
            this.level().addFreshEntity((Entity)areaeffectcloud);
        }
    }

    public void setSwellDir(int i) {
        this.entityData.set(DATA_SWELL_DIR, (Object)i);
    }
}

