/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities;

import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public interface EvolvingInfected {
    default public void tickEvolution(Infected infected, List<? extends String> value, ScamperVariants variants) {
        if (infected.tickCount % 20 == 0 && infected.getEvoPoints() >= (Integer)SConfig.SERVER.min_kills.get()) {
            if (infected.getEvolutionCoolDown() >= (Integer)SConfig.SERVER.evolution_age_human.get()) {
                this.Evolve(infected, value, variants);
            } else if (!infected.hasEffect(MobEffects.WEAKNESS)) {
                infected.setEvolution(infected.getEvolutionCoolDown() + 1);
            }
        }
    }

    default public void tickHyperEvolution(EvolvedInfected infected) {
        if (infected.tickCount % 20 == 0 && infected.getEvoPoints() >= (Integer)SConfig.SERVER.min_kills_hyper.get()) {
            if (infected.getEvolutionCoolDown() >= (Integer)SConfig.SERVER.evolution_age_human.get()) {
                this.HyperEvolve((LivingEntity)infected);
            } else if (!infected.hasEffect(MobEffects.WEAKNESS)) {
                infected.setEvolution(infected.getEvolutionCoolDown() + 1);
            }
        }
    }

    default public void HyperEvolve(LivingEntity living) {
        Level level = living.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x0 = living.getX() - ((double)living.getRandom().nextFloat() - 0.1) * 0.1;
            double y0 = living.getY() + ((double)living.getRandom().nextFloat() - 0.25) * 0.15 * 5.0;
            double z0 = living.getZ() + ((double)living.getRandom().nextFloat() - 0.1) * 0.1;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            this.ringPlayers(living);
        }
    }

    default public void ringPlayers(LivingEntity living) {
        List entities = living.level().getEntities((Entity)living, living.getBoundingBox().inflate(64.0), entity -> entity instanceof Player);
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof Player)) continue;
            Player player = (Player)entity2;
            player.playNotifySound(Ssounds.HYPER_EVOLVE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    default public void Evolve(Infected livingEntity, List<? extends String> value, ScamperVariants variants) {
        Level level;
        if (livingEntity != null && value != null && (level = livingEntity.level()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            Level level2 = livingEntity.level();
            RandomSource random = RandomSource.create();
            if (Math.random() < 0.9) {
                Random rand = new Random();
                for (int i = 0; i < 1; ++i) {
                    int randomIndex = rand.nextInt(value.size());
                    ResourceLocation randomElement1 = ResourceLocation.parse((String)value.get(randomIndex));
                    EntityType randomElement = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(randomElement1);
                    Entity waveentity = randomElement.create(level2);
                    waveentity.setPos(livingEntity.getX(), livingEntity.getY() + 0.5, livingEntity.getZ());
                    waveentity.setCustomName(livingEntity.getCustomName());
                    if (waveentity instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)waveentity;
                        Collection collection = livingEntity.getActiveEffects();
                        for (MobEffectInstance mobeffectinstance : collection) {
                            entity.addEffect(new MobEffectInstance(mobeffectinstance));
                        }
                    }
                    if (waveentity instanceof Infected) {
                        Infected infected = (Infected)waveentity;
                        DifficultyInstance instance = livingEntity.level().getCurrentDifficultyAt(new BlockPos((int)livingEntity.getX(), (int)livingEntity.getY(), (int)livingEntity.getZ()));
                        infected.setKills(livingEntity.getKills());
                        infected.setEvoPoints(livingEntity.getEvoPoints());
                        infected.setSearchPos(livingEntity.getSearchPos());
                        infected.setLinked(livingEntity.getLinked());
                        infected.finalizeSpawn((ServerLevelAccessor)world, instance, MobSpawnType.CONVERSION, null);
                    }
                    level2.addFreshEntity(waveentity);
                    livingEntity.discard();
                }
            } else {
                Scamper scamper = new Scamper(Sentities.SCAMPER.get(), level2);
                scamper.setVariant(variants);
                scamper.setPos(livingEntity.getX(), livingEntity.getY() + 0.5, livingEntity.getZ());
                scamper.setCustomName(livingEntity.getCustomName());
                scamper.setKills(livingEntity.getKills());
                scamper.setEvoPoints(livingEntity.getEvoPoints());
                scamper.setLinked(livingEntity.getLinked());
                scamper.setSearchPos(livingEntity.getSearchPos());
                Collection collection = livingEntity.getActiveEffects();
                for (MobEffectInstance mobeffectinstance : collection) {
                    scamper.addEffect(new MobEffectInstance(mobeffectinstance));
                }
                level2.addFreshEntity((Entity)scamper);
                livingEntity.discard();
            }
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                double x0 = livingEntity.getX() - ((double)random.nextFloat() - 0.1) * 0.1;
                double y0 = livingEntity.getY() + ((double)random.nextFloat() - 0.25) * 0.15 * 5.0;
                double z0 = livingEntity.getZ() + ((double)random.nextFloat() - 0.1) * 0.1;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }
}

