/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Experiments;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Experiment;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Projectile.AcidBall;
import com.Harbinger.Spore.Sentities.Projectile.BileProjectile;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Biobloob
extends Experiment
implements RangedAttackMob {
    public static final EntityDataAccessor<Float> SCALE = SynchedEntityData.defineId(Biobloob.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final float maxScale = 2.0f;
    private static final float minScale = 0.5f;
    private static final double health = (Double)SConfig.SERVER.biobloob_hp.get() * (Double)SConfig.SERVER.global_health.get();
    private static final double damage = (Double)SConfig.SERVER.biobloob_damage.get() * (Double)SConfig.SERVER.global_damage.get();
    private static final double armor = (Double)SConfig.SERVER.biobloob_armor.get() * (Double)SConfig.SERVER.global_armor.get();

    public Biobloob(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("scale", ((Float)this.entityData.get(SCALE)).floatValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(SCALE, (Object)Float.valueOf(tag.getFloat("scale")));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SCALE, (Object)Float.valueOf(1.0f));
    }

    public float getScale() {
        return ((Float)this.entityData.get(SCALE)).floatValue();
    }

    public void setScale(float value) {
        this.entityData.set(SCALE, (Object)Float.valueOf(value));
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        boolean result = super.hurt(source, amount);
        if (result) {
            this.shrink(amount);
        }
        return result;
    }

    @Override
    public void awardKillScore(Entity entity, int i, DamageSource damageSource) {
        super.awardKillScore(entity, i, damageSource);
        this.grow();
    }

    private void grow() {
        if (this.getScale() < 2.0f) {
            this.setScale(this.getScale() + 0.1f);
            this.applyScaleEffects();
        }
    }

    private void shrink(float damageTaken) {
        this.setScale(this.getScale() - damageTaken * 0.01f);
        if (this.getScale() < 0.5f) {
            this.setScale(0.5f);
        }
        this.applyScaleEffects();
    }

    private void applyScaleEffects() {
        Vec3 position = this.position();
        this.setPos(position);
        this.computeAttribute((Holder<Attribute>)Attributes.MAX_HEALTH, health * (double)this.getScale());
        this.computeAttribute((Holder<Attribute>)Attributes.ATTACK_DAMAGE, damage * (double)this.getScale());
        this.computeAttribute((Holder<Attribute>)Attributes.ARMOR, armor * (double)this.getScale());
        this.computeAttribute((Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.3 * (double)(1.0f / this.getScale()));
        if (this.getHealth() > this.getMaxHealth()) {
            this.setHealth(this.getMaxHealth());
        }
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions baseDimensions = super.getDefaultDimensions(pose);
        return baseDimensions.scale(this.getScale() == 1.0f ? 1.0f : this.getScale() * 0.8f);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        super.onSyncedDataUpdated(accessor);
        if (SCALE.equals(accessor)) {
            this.refreshDimensions();
        }
    }

    private void computeAttribute(Holder<Attribute> attributes, double value) {
        AttributeInstance instance = this.getAttribute(attributes);
        if (instance != null) {
            instance.setBaseValue(value);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, health).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FLYING_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, damage).add(Attributes.ARMOR, armor).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.bioblob_loot.get();
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.BIOBLOB.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity livingEntity) {
                return livingEntity.getBbWidth() + 13.0f * Biobloob.this.getScale();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void performRangedAttack(LivingEntity livingEntity, float v) {
        if (!this.level().isClientSide) {
            if (Math.random() <= 0.5) {
                BileProjectile bileProjectile = new BileProjectile(this.level(), (LivingEntity)this, this.TARGET_SELECTOR);
                double dx = livingEntity.getX() - this.getX();
                double dy = livingEntity.getY() + (double)livingEntity.getEyeHeight() - 1.0;
                double dz = livingEntity.getZ() - this.getZ();
                bileProjectile.setDamage((float)((Double)SConfig.SERVER.biobloob__ranged_damage.get() * (Double)SConfig.SERVER.global_damage.get()));
                bileProjectile.moveTo(this.getX(), this.getY() + 1.5, this.getZ());
                bileProjectile.shoot(dx, dy - bileProjectile.getY() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
                this.level().addFreshEntity((Entity)bileProjectile);
            } else {
                AcidBall.shoot((LivingEntity)this, livingEntity, (float)((Double)SConfig.SERVER.biobloob__ranged_damage.get() * (Double)SConfig.SERVER.global_damage.get()));
                this.playSound(SoundEvents.SLIME_JUMP, 1.0f, 0.5f);
            }
        }
    }

    @Override
    public void tick() {
        LivingEntity living;
        super.tick();
        if (this.tickCount % 60 == 0 && (living = this.getTarget()) != null) {
            this.performRangedAttack(living, 0.0f);
        }
    }
}

