/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Experiments;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Experiment;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedWallMovementControl;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Saugling
extends Experiment {
    public static final EntityDataAccessor<Boolean> IS_HIDDEN = SynchedEntityData.defineId(Saugling.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<BlockPos> CHEST_POS = SynchedEntityData.defineId(Saugling.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<Boolean> PRIMED = SynchedEntityData.defineId(Saugling.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int setTicksOut = 0;
    private int ticksOpen = 0;

    public Saugling(EntityType<? extends Infected> type, Level level) {
        super(type, level);
        this.navigation = new WallClimberNavigation((Mob)this, level);
        this.moveControl = new InfectedWallMovementControl((Mob)this);
    }

    public boolean isHidden() {
        return (Boolean)this.entityData.get(IS_HIDDEN);
    }

    public void setIsHidden(boolean val) {
        this.entityData.set(IS_HIDDEN, (Object)val);
    }

    public boolean isPrimed() {
        return (Boolean)this.entityData.get(PRIMED);
    }

    public void setPrimed(boolean val) {
        this.entityData.set(PRIMED, (Object)val);
    }

    public BlockPos getChestPos() {
        return (BlockPos)this.entityData.get(CHEST_POS);
    }

    public void setChestPos(BlockPos val) {
        this.entityData.set(CHEST_POS, (Object)val);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.saugling_loot.get();
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.isHidden()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_HIDDEN, (Object)false);
        builder.define(CHEST_POS, (Object)BlockPos.ZERO);
        builder.define(PRIMED, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("hidden", ((Boolean)this.entityData.get(IS_HIDDEN)).booleanValue());
        tag.putBoolean("primed", ((Boolean)this.entityData.get(PRIMED)).booleanValue());
        tag.putInt("chestPosX", ((BlockPos)this.entityData.get(CHEST_POS)).getX());
        tag.putInt("chestPosY", ((BlockPos)this.entityData.get(CHEST_POS)).getY());
        tag.putInt("chestPosZ", ((BlockPos)this.entityData.get(CHEST_POS)).getZ());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(IS_HIDDEN, (Object)tag.getBoolean("hidden"));
        this.entityData.set(PRIMED, (Object)tag.getBoolean("primed"));
        int x = tag.getInt("chestPosX");
        int y = tag.getInt("chestPosY");
        int z = tag.getInt("chestPosZ");
        this.entityData.set(CHEST_POS, (Object)new BlockPos(x, y, z));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.sau_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.sau_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.sau_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public int getSetTicksOut() {
        return this.setTicksOut;
    }

    public void setSetTicksOut(int setTicksOut) {
        this.setTicksOut = setTicksOut;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new HideInChestGoal(this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(4, (Goal)new CustomMeleeAttackGoal(this, this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
    }

    public boolean isNoAi() {
        return this.isHidden();
    }

    public boolean isInvulnerable() {
        return this.isHidden();
    }

    private void leapAtTarget(LivingEntity target) {
        Vec3 $$0 = this.getDeltaMovement();
        Vec3 $$1 = new Vec3(target.getX() - this.getX(), target.getY() - this.getY(), this.getZ() - this.getZ());
        if ($$1.lengthSqr() > 1.0E-7) {
            $$1 = $$1.normalize().scale(0.4).add($$0.scale(0.2));
        }
        this.setDeltaMovement($$1.x, $$1.y, $$1.z);
    }

    private BlockPos findNearbyChest() {
        BlockPos mobPos = this.blockPosition();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)mobPos.offset(-8, -2, -8), (BlockPos)mobPos.offset(8, 2, 8))) {
            if (!this.level().getBlockState(pos).is(Blocks.CHEST)) continue;
            return pos.immutable();
        }
        return BlockPos.ZERO;
    }

    public boolean isInvisible() {
        return this.isHidden();
    }

    public boolean checkChest(Level level) {
        return level.getBlockState(this.getChestPos()).is(Blocks.CHEST) && this.getChestPos() != BlockPos.ZERO;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.tickCount % 60 == 0) {
            this.setChestPos(this.findNearbyChest());
        }
        if (this.setTicksOut > 0) {
            --this.setTicksOut;
        }
        if (this.isHidden() && this.tickCount % 20 == 0) {
            if (!this.checkChest(this.level())) {
                this.setIsHidden(false);
                this.setPrimed(false);
            }
            if (!this.isPrimed()) {
                AABB aabb = this.getBoundingBox().inflate(3.0);
                List livingEntities = this.level().getEntitiesOfClass(LivingEntity.class, aabb, entity -> {
                    if (!entity.isAlive()) return false;
                    if (!this.TARGET_SELECTOR.test(entity)) return false;
                    if (!(entity instanceof Player)) return true;
                    Player player = (Player)entity;
                    if (player.getAbilities().instabuild) return false;
                    if (player.isSpectator()) return false;
                    return true;
                });
                if (!livingEntities.isEmpty()) {
                    this.setPrimed(true);
                    this.playSound(Ssounds.SAUGLING_JUMPSCARE.get());
                    this.setTarget((LivingEntity)livingEntities.get(this.random.nextInt(livingEntities.size())));
                }
            } else {
                this.setIsHidden(false);
                this.setPrimed(false);
                this.openChest(this.getChestPos());
                this.setSetTicksOut(100);
                LivingEntity target = this.getTarget();
                if (target != null) {
                    this.leapAtTarget(target);
                }
            }
        }
        if (this.ticksOpen > 0) {
            if (this.ticksOpen == 1) {
                this.closeChest(this.getChestPos());
            }
            --this.ticksOpen;
        }
    }

    public void hideInChest() {
        this.ticksOpen = 50;
        this.setIsHidden(true);
        this.setPrimed(false);
        this.openChest(this.getChestPos());
        if (this.level().getBlockState(this.getChestPos().above()).isAir()) {
            this.teleportTo((double)this.getChestPos().getX() + 0.5, this.getChestPos().getY() + 1, (double)this.getChestPos().getZ() + 0.5);
        }
    }

    public void openChest(BlockPos pos) {
        BlockEntity entity = this.level().getBlockEntity(pos);
        if (entity instanceof ChestBlockEntity) {
            ChestBlockEntity chestBlock = (ChestBlockEntity)entity;
            this.playSound(SoundEvents.CHEST_OPEN);
            this.level().blockEvent(pos, chestBlock.getBlockState().getBlock(), 1, 1);
            this.level().updateNeighborsAt(pos, chestBlock.getBlockState().getBlock());
            this.level().updateNeighborsAt(pos.below(), chestBlock.getBlockState().getBlock());
        }
    }

    public void closeChest(BlockPos pos) {
        BlockEntity entity = this.level().getBlockEntity(pos);
        if (entity instanceof ChestBlockEntity) {
            ChestBlockEntity chestBlock = (ChestBlockEntity)entity;
            this.playSound(SoundEvents.CHEST_CLOSE);
            this.level().blockEvent(pos, chestBlock.getBlockState().getBlock(), 1, 0);
            this.level().updateNeighborsAt(pos, chestBlock.getBlockState().getBlock());
            this.level().updateNeighborsAt(pos.below(), chestBlock.getBlockState().getBlock());
        }
    }

    @Override
    public boolean isDormant() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return this.isHidden() ? Ssounds.SAUGLING_CHEST_AMBIENT.get() : Ssounds.SAUGLING_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    protected int calculateFallDamage(float p_21237_, float p_21238_) {
        return super.calculateFallDamage(p_21237_, p_21238_) - 10;
    }

    public static class HideInChestGoal
    extends Goal {
        private final Saugling mob;

        public HideInChestGoal(Saugling mob) {
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.mob.isHidden() || this.mob.getTarget() != null) {
                return false;
            }
            return this.mob.getChestPos() != BlockPos.ZERO && this.mob.getSetTicksOut() <= 0;
        }

        public void start() {
            if (this.mob.getChestPos() != null && this.mob.getChestPos() != BlockPos.ZERO) {
                this.mob.setChestPos(this.mob.getChestPos());
                this.mob.getNavigation().moveTo((double)this.mob.getChestPos().getX(), (double)this.mob.getChestPos().getY(), (double)this.mob.getChestPos().getZ(), 1.0);
            }
        }

        public void tick() {
            if (this.mob.getChestPos() != null && this.mob.getChestPos() != BlockPos.ZERO && this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.mob.getChestPos())) < 1.5) {
                this.mob.hideInChest();
            }
        }
    }
}

