/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.FallenMultipart;

import com.Harbinger.Spore.Sentities.BaseEntities.FallenMultipartEntity;
import com.Harbinger.Spore.core.SConfig;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class HowitzerArm
extends FallenMultipartEntity {
    public static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.defineId(HowitzerArm.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> NUCLEAR = SynchedEntityData.defineId(HowitzerArm.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public HowitzerArm(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.howit_hp.get() / 4.0 * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.howit_armor.get() / 4.0 * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.howit_foot_loot.get();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RIGHT, (Object)true);
        builder.define(NUCLEAR, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("right", ((Boolean)this.entityData.get(RIGHT)).booleanValue());
        tag.putBoolean("nuclear", ((Boolean)this.entityData.get(NUCLEAR)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(RIGHT, (Object)tag.getBoolean("right"));
        this.entityData.set(NUCLEAR, (Object)tag.getBoolean("nuclear"));
    }

    public boolean getRight() {
        return (Boolean)this.entityData.get(RIGHT);
    }

    public void setRight(boolean i) {
        this.entityData.set(RIGHT, (Object)i);
    }

    public boolean getNuclear() {
        return (Boolean)this.entityData.get(NUCLEAR);
    }

    public void setNuclear(boolean i) {
        this.entityData.set(NUCLEAR, (Object)i);
    }
}

