/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.FallenMultipart;

import com.Harbinger.Spore.Sentities.BaseEntities.FallenMultipartEntity;
import com.Harbinger.Spore.core.SConfig;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidType;

public class Licker
extends FallenMultipartEntity {
    public static final EntityDataAccessor<Boolean> BURNED = SynchedEntityData.defineId(Licker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Licker(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BURNED, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("burned", ((Boolean)this.entityData.get(BURNED)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(BURNED, (Object)tag.getBoolean("burned"));
    }

    public boolean getBurned() {
        return (Boolean)this.entityData.get(BURNED);
    }

    public void setBurned(boolean i) {
        this.entityData.set(BURNED, (Object)i);
    }

    public boolean fireImmune() {
        return this.getBurned();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.gazen_tongue_loot.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.gazen_hp.get() / 6.0 * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.gazen_armor.get() / 4.0 * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Override
    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }
}

