/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.FallenMultipart;

import com.Harbinger.Spore.Sentities.BaseEntities.FallenMultipartEntity;
import com.Harbinger.Spore.core.SConfig;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class SiegerTail
extends FallenMultipartEntity {
    public static final EntityDataAccessor<Boolean> WAR = SynchedEntityData.defineId(SiegerTail.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public SiegerTail(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.sieger_tail_loot.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.sieger_hp.get() / 4.0 * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.sieger_armor.get() / 4.0 * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WAR, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("war", ((Boolean)this.entityData.get(WAR)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(WAR, (Object)tag.getBoolean("war"));
    }

    public boolean getWar() {
        return (Boolean)this.entityData.get(WAR);
    }

    public void setWar(boolean i) {
        this.entityData.set(WAR, (Object)i);
    }
}

