/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sblocks.GenericFoliageBlock;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public interface FoliageSpread {
    public static final RandomSource source = RandomSource.create();

    private List<Holder<Block>> GROUND_FOLIAGE(Level level) {
        return Utilities.tryToCreateBlockFromTag(level, ResourceLocation.parse((String)"spore:ground_foliage"));
    }

    private List<Holder<Block>> WATER_FOLIAGE(Level level) {
        return Utilities.tryToCreateBlockFromTag(level, ResourceLocation.parse((String)"spore:underwater_blocks"));
    }

    private List<Holder<Block>> ROOF_FOLIAGE(Level level) {
        return Utilities.tryToCreateBlockFromTag(level, ResourceLocation.parse((String)"spore:roof_foliage"));
    }

    private List<Holder<Block>> WALL_FOLIAGE(Level level) {
        return Utilities.tryToCreateBlockFromTag(level, ResourceLocation.parse((String)"spore:wall_foliage"));
    }

    default public void SpreadInfection(Level level, double range, BlockPos pos) {
        if (!level.isClientSide) {
            if (((Boolean)SConfig.SERVER.mound_foliage.get()).booleanValue()) {
                this.additionPlacers(level, pos, range);
                int i = 0;
                while ((double)i <= 2.0 * range) {
                    int j = 0;
                    while ((double)j <= 2.0 * range) {
                        int k = 0;
                        while ((double)k <= 2.0 * range) {
                            double distance = Mth.sqrt((float)((float)(((double)i - range) * ((double)i - range) + ((double)j - range) * ((double)j - range) + ((double)k - range) * ((double)k - range))));
                            if ((Math.abs(i) != 2 || Math.abs(j) != 2 || Math.abs(k) != 2) && distance < range + 0.5) {
                                BlockPos blockpos = pos.offset(i - (int)range, j - (int)range, k - (int)range);
                                BlockState blockstate = level.getBlockState(blockpos);
                                this.SpreadFoliageAndConvert(level, blockstate, blockpos);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.additionIgnoreConfigPlacers(level, pos, range);
            }
        }
    }

    default public void SpreadFoliageAndConvert(Level level, BlockState blockstate, BlockPos blockpos) {
        boolean belowT;
        BlockState nord = level.getBlockState(blockpos.north());
        BlockState south = level.getBlockState(blockpos.south());
        BlockState west = level.getBlockState(blockpos.west());
        BlockState east = level.getBlockState(blockpos.east());
        BlockState above = level.getBlockState(blockpos.above());
        BlockState below = level.getBlockState(blockpos.below());
        boolean nordT = !nord.isSolidRender((BlockGetter)level, blockpos.north());
        boolean southT = !south.isSolidRender((BlockGetter)level, blockpos.south());
        boolean westT = !west.isSolidRender((BlockGetter)level, blockpos.west());
        boolean eastT = !east.isSolidRender((BlockGetter)level, blockpos.east());
        boolean aboveT = !above.isSolidRender((BlockGetter)level, blockpos.above());
        boolean bl = belowT = !below.isSolidRender((BlockGetter)level, blockpos.below());
        if (Math.random() < 0.1 && blockstate.isSolidRender((BlockGetter)level, blockpos) && (nordT || southT || westT || eastT || aboveT || belowT)) {
            this.convertBlocks(blockstate, level, blockpos);
        }
        if (Math.random() < 0.2) {
            this.convertWood(level, blockstate, blockpos);
            this.placeRottenBush(above, level, blockpos, blockstate);
        }
        if (Math.random() < 0.01) {
            this.placeGroundFoliage(above, level, blockpos, blockstate);
        }
        if (Math.random() < 0.1) {
            this.placeCropsFoliage(level, blockpos, blockstate);
        }
        if (Math.random() < 0.01) {
            this.placeWaterFoliage(above, level, blockpos, blockstate);
        }
        if (Math.random() < 0.01) {
            this.placeHangingFoliage(below, level, blockpos, blockstate);
        }
        if (Math.random() < 0.01) {
            this.placeWallFoliage(nord, south, west, east, nordT, southT, westT, eastT, level, blockpos, blockstate);
        }
    }

    default public void additionPlacers(Level level, BlockPos pos, double range) {
    }

    default public void additionIgnoreConfigPlacers(Level level, BlockPos pos, double range) {
    }

    default public void placeGroundFoliage(BlockState above, Level level, BlockPos blockpos, BlockState blockstate) {
        if (above.isAir() && blockstate.isSolidRender((BlockGetter)level, blockpos)) {
            List<Holder<Block>> blocks = this.GROUND_FOLIAGE(level);
            if (blocks.isEmpty()) {
                return;
            }
            Holder<Block> value = blocks.get(source.nextInt(blocks.size()));
            BlockState block1 = ((Block)value.value()).defaultBlockState();
            level.setBlock(blockpos.above(), block1, 3);
        }
    }

    default public void placeCropsFoliage(Level level, BlockPos blockpos, BlockState blockstate) {
        if (blockstate.getBlock() instanceof CropBlock) {
            level.setBlock(blockpos, ((Block)Sblocks.ROTTEN_CROPS.get()).defaultBlockState(), 3);
        }
    }

    default public void placeRottenBush(BlockState above, Level level, BlockPos blockpos, BlockState blockstate) {
        if (above.getBlock() instanceof BushBlock && !(above.getBlock() instanceof GenericFoliageBlock) && blockstate.isSolidRender((BlockGetter)level, blockpos)) {
            BlockState state = Math.random() < 0.5 ? ((Block)Sblocks.ROTTEN_BUSH.get()).defaultBlockState() : ((Block)Sblocks.GROWTHS_BIG.get()).defaultBlockState();
            level.setBlock(blockpos.above(), state, 3);
        }
    }

    default public void placeWaterFoliage(BlockState above, Level level, BlockPos blockpos, BlockState blockstate) {
        List<Holder<Block>> blocks = this.WATER_FOLIAGE(level);
        if (blocks.isEmpty()) {
            return;
        }
        Holder<Block> value = blocks.get(source.nextInt(blocks.size()));
        BlockState block5 = ((Block)value.value()).defaultBlockState();
        if (blockstate.isSolidRender((BlockGetter)level, blockpos) && above.getFluidState().is((Fluid)Fluids.WATER)) {
            Property property = block5.getBlock().getStateDefinition().getProperty("waterlogged");
            if (property instanceof BooleanProperty) {
                BooleanProperty property2 = (BooleanProperty)property;
                level.setBlock(blockpos.above(), (BlockState)block5.setValue((Property)property2, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                level.setBlock(blockpos.above(), block5, 3);
            }
        }
    }

    default public void placeHangingFoliage(BlockState below, Level level, BlockPos blockpos, BlockState blockstate) {
        if (below.isAir() && blockstate.isSolidRender((BlockGetter)level, blockpos)) {
            List<Holder<Block>> blocks = this.ROOF_FOLIAGE(level);
            if (blocks.isEmpty()) {
                return;
            }
            Holder<Block> value = blocks.get(source.nextInt(blocks.size()));
            BlockState block2 = ((Block)value.value()).defaultBlockState();
            Property property = block2.getBlock().getStateDefinition().getProperty("hanging");
            if (property instanceof BooleanProperty) {
                BooleanProperty property2 = (BooleanProperty)property;
                level.setBlock(blockpos.below(), (BlockState)block2.setValue((Property)property2, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                level.setBlock(blockpos.below(), block2, 3);
            }
        }
    }

    default public void placeWallFoliage(BlockState nord, BlockState south, BlockState west, BlockState east, boolean nordT, boolean southT, boolean westT, boolean eastT, Level level, BlockPos blockpos, BlockState blockstate) {
        if (blockstate.isSolidRender((BlockGetter)level, blockpos) && (nordT || southT || westT || eastT)) {
            List<Holder<Block>> blocks = this.WALL_FOLIAGE(level);
            if (blocks.isEmpty()) {
                return;
            }
            Holder<Block> value = blocks.get(source.nextInt(blocks.size()));
            BlockState block3 = ((Block)value.value()).defaultBlockState();
            Direction direction = Direction.NORTH;
            Direction direction2 = Direction.SOUTH;
            Direction direction3 = Direction.EAST;
            Direction direction4 = Direction.WEST;
            Property property = block3.getBlock().getStateDefinition().getProperty("facing");
            if (property instanceof DirectionProperty) {
                DirectionProperty directionProperty = (DirectionProperty)property;
                if (nord.isAir() && Math.random() < 0.5) {
                    level.setBlock(blockpos.north(), (BlockState)block3.setValue((Property)directionProperty, (Comparable)direction), 3);
                }
                if (south.isAir() && Math.random() < 0.5) {
                    level.setBlock(blockpos.south(), (BlockState)block3.setValue((Property)directionProperty, (Comparable)direction2), 3);
                }
                if (west.isAir() && Math.random() < 0.5) {
                    level.setBlock(blockpos.west(), (BlockState)block3.setValue((Property)directionProperty, (Comparable)direction4), 3);
                }
                if (east.isAir() && Math.random() < 0.5) {
                    level.setBlock(blockpos.east(), (BlockState)block3.setValue((Property)directionProperty, (Comparable)direction3), 3);
                }
            }
        }
    }

    default public void placeBranches(Level level, BlockPos blockpos, BlockState blockstate) {
        if (blockstate.isSolidRender((BlockGetter)level, blockpos)) {
            BlockState block3 = ((Block)Sblocks.ROTTEN_BRANCH.get()).defaultBlockState();
            BlockState nord = level.getBlockState(blockpos.north());
            BlockState south = level.getBlockState(blockpos.south());
            BlockState west = level.getBlockState(blockpos.west());
            BlockState east = level.getBlockState(blockpos.east());
            Property property = block3.getBlock().getStateDefinition().getProperty("facing");
            if (property instanceof DirectionProperty) {
                DirectionProperty directionProperty = (DirectionProperty)property;
                if (nord.getBlock() instanceof LeavesBlock && Math.random() < 0.3) {
                    level.setBlock(blockpos.north(), (BlockState)block3.setValue((Property)directionProperty, (Comparable)Direction.NORTH), 3);
                }
                if (south.getBlock() instanceof LeavesBlock && Math.random() < 0.3) {
                    level.setBlock(blockpos.south(), (BlockState)block3.setValue((Property)directionProperty, (Comparable)Direction.SOUTH), 3);
                }
                if (west.getBlock() instanceof LeavesBlock && Math.random() < 0.3) {
                    level.setBlock(blockpos.west(), (BlockState)block3.setValue((Property)directionProperty, (Comparable)Direction.WEST), 3);
                }
                if (east.getBlock() instanceof LeavesBlock && Math.random() < 0.3) {
                    level.setBlock(blockpos.east(), (BlockState)block3.setValue((Property)directionProperty, (Comparable)Direction.EAST), 3);
                }
            }
        }
    }

    default public void convertBlocks(BlockState blockstate, Level level, BlockPos blockpos) {
        for (String str : (List)SConfig.DATAGEN.block_infection.get()) {
            String[] string = str.split("\\|");
            Block blockCon1 = Utilities.tryToCreateBlock(ResourceLocation.parse((String)string[0]));
            Block blockCon2 = Utilities.tryToCreateBlock(ResourceLocation.parse((String)string[1]));
            if (blockCon1 == Blocks.AIR || blockCon2 == Blocks.AIR || blockCon1 != blockstate.getBlock()) continue;
            level.setBlock(blockpos, blockCon2.defaultBlockState(), 3);
        }
    }

    default public void convertWood(Level level, BlockState blockstate, BlockPos blockpos) {
        Property _property;
        BlockState _bs;
        if (blockstate.is(BlockTags.LOGS)) {
            _bs = ((Block)Sblocks.ROTTEN_LOG.get()).defaultBlockState();
            for (Map.Entry entry : blockstate.getValues().entrySet()) {
                _property = _bs.getBlock().getStateDefinition().getProperty(((Property)entry.getKey()).getName());
                if (_property == null || _bs.getValue(_property) == null) continue;
                try {
                    _bs = (BlockState)_bs.setValue(_property, (Comparable)entry.getValue());
                }
                catch (Exception exception) {}
            }
            level.setBlock(blockpos, _bs, 3);
            this.placeBranches(level, blockpos, blockstate);
        }
        if (blockstate.is(BlockTags.WOODEN_STAIRS)) {
            _bs = ((Block)Sblocks.ROTTEN_STAIR.get()).defaultBlockState();
            for (Map.Entry entry : blockstate.getValues().entrySet()) {
                _property = _bs.getBlock().getStateDefinition().getProperty(((Property)entry.getKey()).getName());
                if (_property == null || _bs.getValue(_property) == null) continue;
                try {
                    _bs = (BlockState)_bs.setValue(_property, (Comparable)entry.getValue());
                }
                catch (Exception exception) {}
            }
            if (Math.random() < (double)0.3f) {
                FallingBlockEntity.fall((Level)level, (BlockPos)blockpos, (BlockState)_bs);
            } else {
                level.setBlock(blockpos, _bs, 3);
            }
        }
        if (blockstate.is(BlockTags.PLANKS)) {
            _bs = ((Block)Sblocks.ROTTEN_PLANKS.get()).defaultBlockState();
            if (Math.random() < (double)0.3f && level.getBlockState(blockpos.below()).isAir()) {
                FallingBlockEntity.fall((Level)level, (BlockPos)blockpos, (BlockState)_bs);
            } else {
                level.setBlock(blockpos, _bs, 3);
            }
        }
        if (blockstate.is(BlockTags.WOODEN_SLABS)) {
            _bs = ((Block)Sblocks.ROTTEN_SLAB.get()).defaultBlockState();
            for (Map.Entry entry : blockstate.getValues().entrySet()) {
                _property = _bs.getBlock().getStateDefinition().getProperty(((Property)entry.getKey()).getName());
                if (_property == null || _bs.getValue(_property) == null) continue;
                try {
                    _bs = (BlockState)_bs.setValue(_property, (Comparable)entry.getValue());
                }
                catch (Exception exception) {}
            }
            level.setBlock(blockpos, _bs, 3);
        }
        if (blockstate.is(BlockTags.WOODEN_DOORS) || blockstate.is(BlockTags.WOODEN_TRAPDOORS) || blockstate.is(BlockTags.WOODEN_FENCES) || blockstate.is(BlockTags.WOODEN_PRESSURE_PLATES)) {
            _bs = ((Block)Sblocks.ROTTEN_SCRAPS.get()).defaultBlockState();
            FallingBlockEntity.fall((Level)level, (BlockPos)blockpos, (BlockState)_bs);
        }
    }
}

