/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Brot
extends Hyper {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.defineId(Hyper.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int swell;
    private final int maxSwell = 40;
    private boolean leapt = false;

    public Brot(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.brot_loot.get();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SWELL_DIR, (Object)-1);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag data) {
        super.addAdditionalSaveData(data);
        data.putShort("Fuse", (short)this.maxSwell);
    }

    public int getSwellDir() {
        return (Integer)this.entityData.get(DATA_SWELL_DIR);
    }

    public void setSwellDir(int data) {
        this.entityData.set(DATA_SWELL_DIR, (Object)data);
    }

    public void setLeapt(boolean value) {
        this.leapt = value;
    }

    public boolean getLeapt() {
        return this.leapt;
    }

    private void chemAttack(LivingEntity pLivingEntity) {
        AABB boundingBox = pLivingEntity.getBoundingBox().inflate(12.0);
        List entities = pLivingEntity.level().getEntities((Entity)pLivingEntity, boundingBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (Utilities.helmetList().contains(livingEntity.getItemBySlot(EquipmentSlot.HEAD).getItem()) || !this.TARGET_SELECTOR.test(livingEntity)) continue;
            for (String str : (List)SConfig.SERVER.brot_effects.get()) {
                String[] string = str.split("\\|");
                Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)string[0]));
                if (effect == null || livingEntity.hasEffect(effect)) continue;
                livingEntity.addEffect(new MobEffectInstance(effect, Integer.parseUnsignedInt(string[1]), Integer.parseUnsignedInt(string[2])));
            }
        }
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(2, (Goal)new BrotLeapGoal(this));
        this.goalSelector.addGoal(3, (Goal)new AOEMeleeAttackGoal(this, 1.2, true, 1.2, 5.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.brot_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.brot_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.brot_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public void tick() {
        if (this.isAlive()) {
            LivingEntity target;
            int i;
            if (this.tickCount % 20 == 0 && this.getLeapt() && this.onGround()) {
                this.setLeapt(false);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.playSound(Ssounds.BRAIOMIL_ATTACK.get(), 1.0f, 0.5f);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.setSwellDir(-1);
                this.chemAttack((LivingEntity)this);
            }
            if (this.tickCount % 20 == 0 && (target = this.getTarget()) != null && this.distanceToSqr((Entity)target) < 120.0) {
                this.setSwellDir(1);
            }
        }
        super.tick();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        if (this.swell >= 25) {
            for (int i = 0; i < 360; ++i) {
                if (i % 20 != 0) continue;
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y + 1.0, z, Math.cos(i) * 0.15, Math.sin(i) * Math.cos(i) * 0.15, Math.sin(i) * 0.15);
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.BROT_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    public static class BrotLeapGoal
    extends Goal {
        private final Brot mob;
        private LivingEntity target;

        public BrotLeapGoal(Brot value) {
            this.mob = value;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.mob.isVehicle()) {
                return false;
            }
            this.target = this.mob.getTarget();
            if (this.target == null) {
                return false;
            }
            double d0 = this.mob.distanceToSqr((Entity)this.target);
            if (!(d0 < 16.0) && !(d0 > 48.0)) {
                if (!this.mob.onGround()) {
                    return false;
                }
                return this.mob.getRandom().nextInt(BrotLeapGoal.reducedTickDelay((int)5)) == 0;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return !this.mob.onGround();
        }

        public void start() {
            Vec3 vec3 = this.mob.getDeltaMovement();
            Vec3 vec31 = new Vec3(this.target.getX() - this.mob.getX(), 0.0, this.target.getZ() - this.mob.getZ());
            if (vec31.lengthSqr() > 1.0E-7) {
                vec31 = vec31.normalize().scale(0.8).add(vec3.scale(0.3));
            }
            this.mob.setDeltaMovement(vec31.x, 0.6, vec31.z);
            this.mob.setLeapt(true);
        }
    }
}

