/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.PullGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Hyper.HevokerPart;
import com.Harbinger.Spore.Sentities.Utility.HyperClaw;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.entity.living.LivingUseTotemEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Hevoker
extends Hyper {
    private static final EntityDataAccessor<Boolean> DEAD = SynchedEntityData.defineId(Hevoker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_ARM = SynchedEntityData.defineId(Hevoker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TIME_REGROW = SynchedEntityData.defineId(Hevoker.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final HevokerPart[] subEntities;
    private final HevokerPart totem = new HevokerPart(this, "totem", 0.5f, 0.5f);
    private final HevokerPart arm1 = new HevokerPart(this, "right_arm1", 0.5f, 0.5f);
    private final HevokerPart arm2 = new HevokerPart(this, "right_arm2", 0.5f, 0.5f);
    private final HevokerPart arm3 = new HevokerPart(this, "right_arm3", 0.5f, 0.5f);
    private final HevokerPart arm4 = new HevokerPart(this, "right_arm4", 0.5f, 0.5f);
    private int reviveTimer = 0;
    private int attackAnimationTick;
    private boolean value = true;

    public Hevoker(EntityType<? extends Infected> type, Level level) {
        super(type, level);
        this.subEntities = new HevokerPart[]{this.totem, this.arm1, this.arm2, this.arm3, this.arm4};
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public void setId(int p_20235_) {
        super.setId(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(p_20235_ + i + 1);
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public HevokerPart[] getSubEntities() {
        return this.subEntities;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_218825_) {
        super.recreateFromPacket(p_218825_);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("fake_death", this.isFakeDead());
        tag.putBoolean("arm", this.hasArm());
        tag.putInt("regrow", this.getTimeRegrow());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setFakeDead(tag.getBoolean("fake_death"));
        this.setArm(tag.getBoolean("arm"));
        this.setTimeRegrow(tag.getInt("regrow"));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DEAD, (Object)false);
        builder.define(HAS_ARM, (Object)true);
        builder.define(TIME_REGROW, (Object)0);
    }

    public boolean isFakeDead() {
        return (Boolean)this.entityData.get(DEAD);
    }

    public void setFakeDead(boolean value) {
        this.entityData.set(DEAD, (Object)value);
    }

    public boolean hasArm() {
        return (Boolean)this.entityData.get(HAS_ARM);
    }

    public void setArm(boolean value) {
        this.entityData.set(HAS_ARM, (Object)value);
    }

    public void setTimeRegrow(int value) {
        this.entityData.set(TIME_REGROW, (Object)value);
    }

    public void tickTimeRegrow() {
        this.entityData.set(TIME_REGROW, (Object)((Integer)this.entityData.get(TIME_REGROW) + 1));
    }

    public int getTimeRegrow() {
        return (Integer)this.entityData.get(TIME_REGROW);
    }

    public void tick() {
        super.tick();
        if (this.reviveTimer > 0) {
            if (this.reviveTimer == 1) {
                this.reviveBody();
            }
            --this.reviveTimer;
        }
        if (this.isFakeDead()) {
            this.makeStuckInBlock(Blocks.AIR.defaultBlockState(), new Vec3(0.0, 1.0, 0.0));
        }
        if (!this.hasArm() && this.tickCount % 20 == 0) {
            this.tickTimeRegrow();
            if (this.getTimeRegrow() >= 300) {
                this.setArm(true);
                this.setTimeRegrow(0);
            }
        }
    }

    public void reviveBody() {
        float hp = (float)((Double)SConfig.SERVER.hevoker_hp.get() * (Double)SConfig.SERVER.global_health.get() / 4.0);
        this.setHealth(hp);
        ItemStack stack = new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING);
        DamageSource source = this.getLastDamageSource();
        if (source != null) {
            LivingUseTotemEvent event = new LivingUseTotemEvent((LivingEntity)this, source, stack, InteractionHand.MAIN_HAND);
            NeoForge.EVENT_BUS.post((Event)event);
        }
        this.setFakeDead(false);
        this.playSound(SoundEvents.TOTEM_USE);
        this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 800, 1));
        this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
        this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.hevoker_loot.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.hevoker_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.hevoker_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.hevoker_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    private boolean switchy() {
        LivingEntity living = this.getTarget();
        if (this.isFakeDead()) {
            return false;
        }
        if (living != null && this.canSee((Entity)living)) {
            double ze = this.distanceToSqr((Entity)living);
            return ze > 200.0 && ze < 600.0 && (Boolean)this.entityData.get(HAS_ARM) != false;
        }
        return false;
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(3, (Goal)new AOEMeleeAttackGoal(this, 1.2, true, 1.2, 3.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            public boolean canUse() {
                if (Hevoker.this.isFakeDead()) {
                    return false;
                }
                return super.canUse();
            }

            @Override
            protected void checkAndPerformAttack(LivingEntity entity, double p_25558_) {
                if (!Hevoker.this.isFakeDead()) {
                    super.checkAndPerformAttack(entity, p_25558_);
                }
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal(this, 0.8){

            public boolean canUse() {
                if (Hevoker.this.isFakeDead()) {
                    return false;
                }
                return super.canUse();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new PullGoal((Mob)this, 32.0, 8.0){

            @Override
            public boolean canUse() {
                return Hevoker.this.switchy();
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                if (Hevoker.this.isFakeDead()) {
                    return false;
                }
                return super.canUse();
            }
        });
    }

    public void handleEntityEvent(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.handleEntityEvent(value);
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(entity);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.moveHitBoxesAround();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public boolean isInvulnerable() {
        return super.isInvulnerable() || this.isFakeDead();
    }

    public boolean isAttackable() {
        if (this.isFakeDead()) {
            return false;
        }
        return super.isAttackable();
    }

    public boolean canSee(Entity entity) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vec31 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        if (vec31.distanceTo(vec3) > 128.0) {
            return false;
        }
        return this.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.isInPowderSnow || source.is(DamageTypes.FREEZE) || amount > 100.0f) {
            return super.hurt(source, amount);
        }
        if (this.isFakeDead()) {
            return false;
        }
        if (!this.isFakeDead() && amount > this.getHealth() && !this.isInPowderSnow) {
            this.setFakeDead(true);
            this.setHealth(1.0f);
            this.reviveTimer = 200;
            return true;
        }
        if (Math.random() < 0.2) {
            this.performTelekineticThrow();
        }
        return super.hurt(source, amount);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (DEAD.equals(dataAccessor)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions dimensions = super.getDefaultDimensions(pose);
        if (this.isFakeDead()) {
            return dimensions.scale(2.2f, 0.25f);
        }
        return dimensions;
    }

    public boolean hurt(HevokerPart hevokerArm, DamageSource source, float amount) {
        if (Math.random() < 0.2 && this.hasArm() && !this.level().isClientSide && (hevokerArm == this.arm1 || hevokerArm == this.arm2 || hevokerArm == this.arm3 || hevokerArm == this.arm4)) {
            this.SummonClaw();
            this.setArm(false);
        }
        if (this.isFakeDead() && hevokerArm == this.totem) {
            return this.hurt(source, Float.MAX_VALUE);
        }
        return this.hurt(source, amount);
    }

    protected void tickPart(HevokerPart part, Vec3 vec3i) {
        Vec3 vec3 = vec3i.yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
        part.setPos(this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
    }

    public void SummonClaw() {
        Vec3 vec3 = new Vec3(0.3, 0.5, -0.8).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
        HyperClaw claw = new HyperClaw(Sentities.HEVOKER_ARM.get(), this.level());
        claw.moveTo(this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
        this.level().addFreshEntity((Entity)claw);
        this.playSound(Ssounds.LIMB_SLASH.get());
    }

    public void moveHitBoxesAround() {
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].getX(), this.subEntities[j].getY(), this.subEntities[j].getZ());
        }
        this.tickPart(this.arm1, this.isFakeDead() ? new Vec3(0.0, 0.0, -0.5) : new Vec3(0.3, 0.5, -0.8));
        this.tickPart(this.arm2, this.isFakeDead() ? new Vec3(0.5, 0.0, -1.0) : new Vec3(0.3, 1.0, -0.8));
        this.tickPart(this.arm3, this.isFakeDead() ? new Vec3(0.6, 0.0, -1.5) : new Vec3(0.3, 1.5, -0.8));
        this.tickPart(this.arm4, this.isFakeDead() ? new Vec3(0.6, 0.0, -2.0) : new Vec3(0.3, 2.0, -0.8));
        this.tickPart(this.totem, this.isFakeDead() ? new Vec3(-0.2, 0.5, 0.0) : new Vec3(0.5, 1.8, 0.0));
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].xo = avec3[l].x;
            this.subEntities[l].yo = avec3[l].y;
            this.subEntities[l].zo = avec3[l].z;
            this.subEntities[l].xOld = avec3[l].x;
            this.subEntities[l].yOld = avec3[l].y;
            this.subEntities[l].zOld = avec3[l].z;
        }
    }

    public InteractionResult interact(HevokerPart hevokerPart, Player player, InteractionHand hand) {
        if (this.isFakeDead() && hevokerPart == this.totem && this.reviveTimer > 20 && this.value) {
            this.hurt(this.damageSources().playerAttack(player), Float.MAX_VALUE);
            this.createTotem();
            this.value = false;
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void createTotem() {
        ItemStack stack = new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING);
        ItemEntity entity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
        this.level().addFreshEntity((Entity)entity);
    }

    protected SoundEvent getAmbientSound() {
        return this.isFakeDead() ? null : Ssounds.HEVOKER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    public void performTelekineticThrow() {
        AABB aabb = this.getBoundingBox().inflate(8.0);
        List entities = this.level().getEntities((Entity)this, aabb, entity -> {
            LivingEntity living;
            return entity instanceof LivingEntity && this.TARGET_SELECTOR.test(living = (LivingEntity)entity);
        });
        if (entities.size() > 1) {
            for (Entity entity2 : entities) {
                entity2.setDeltaMovement(entity2.getDeltaMovement().add(0.0, 1.0, 0.0));
            }
            this.swing(InteractionHand.MAIN_HAND);
        }
    }
}

