/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Projectile.ThrownItemProjectile;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Hvindicator
extends Hyper
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> RIGHT_SKULL = SynchedEntityData.defineId(Hvindicator.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEFT_SKULL = SynchedEntityData.defineId(Hvindicator.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TIME_AXE = SynchedEntityData.defineId(Hvindicator.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int attackAnimationTick;
    private int rangedAnimationTick;
    private int blockTime = 0;
    public AnimationState block_attack = new AnimationState();

    public Hvindicator(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.hindicator_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.hindicator_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.hindicator_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("left_skull", ((Boolean)this.entityData.get(LEFT_SKULL)).booleanValue());
        tag.putBoolean("right_skull", ((Boolean)this.entityData.get(RIGHT_SKULL)).booleanValue());
        tag.putInt("time_axe", ((Integer)this.entityData.get(TIME_AXE)).intValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(LEFT_SKULL, (Object)tag.getBoolean("left_skull"));
        this.entityData.set(RIGHT_SKULL, (Object)tag.getBoolean("right_skull"));
        this.entityData.set(TIME_AXE, (Object)tag.getInt("time_axe"));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RIGHT_SKULL, (Object)false);
        builder.define(LEFT_SKULL, (Object)false);
        builder.define(TIME_AXE, (Object)600);
    }

    public boolean hasRightSkull() {
        return (Boolean)this.entityData.get(RIGHT_SKULL);
    }

    public boolean hasLeftSkull() {
        return (Boolean)this.entityData.get(LEFT_SKULL);
    }

    public boolean hasAxe() {
        return (Integer)this.entityData.get(TIME_AXE) >= 600;
    }

    private void tickAxe() {
        if (this.hasAxe()) {
            return;
        }
        this.entityData.set(TIME_AXE, (Object)((Integer)this.entityData.get(TIME_AXE) + 1));
    }

    public void handleEntityEvent(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
        } else if (value == 5) {
            this.block_attack.start(this.tickCount);
            this.blockTime = 10;
        } else if (value == 6) {
            this.rangedAnimationTick = 10;
        } else {
            super.handleEntityEvent(value);
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        Player player;
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        if (entity instanceof Player && (this.doesPlayerHaveShieldInHand(player = (Player)entity, InteractionHand.MAIN_HAND) || this.doesPlayerHaveShieldInHand(player, InteractionHand.OFF_HAND))) {
            player.disableShield();
        }
        return super.doHurtTarget(entity);
    }

    public boolean doesPlayerHaveShieldInHand(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return stack.getItem() instanceof ShieldItem;
    }

    public void tick() {
        LivingEntity target;
        super.tick();
        this.tickAxe();
        this.setupAnimationStates();
        if (this.tickCount % 60 == 0 && this.hasAxe() && (target = this.getTarget()) != null && this.hasLineOfSight((Entity)target)) {
            this.rangedAnimationTick = 10;
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
            this.performRangedAttack(target, 0.0f);
            this.entityData.set(TIME_AXE, (Object)0);
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.hindicator_loot.get();
    }

    private void setupAnimationStates() {
        if (this.blockTime > 0) {
            if (this.blockTime == 1) {
                this.block_attack.stop();
            }
            --this.blockTime;
        }
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(3, (Goal)new AOEMeleeAttackGoal(this, 1.2, true, 1.2, 3.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean canDisableShield() {
        super.canDisableShield();
        return true;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        float reduction = 1.0f;
        reduction = this.hasLeftSkull() ? reduction - 0.1f : reduction;
        float f = reduction = this.hasRightSkull() ? reduction - 0.1f : reduction;
        if (source.is(DamageTypeTags.IS_PROJECTILE) && Math.random() < 0.75) {
            if (!this.level().isClientSide()) {
                this.playSound(SoundEvents.SHIELD_BLOCK);
                this.level().broadcastEntityEvent((Entity)this, (byte)5);
            }
            return false;
        }
        if (source.getEntity() != null && Math.random() < (double)0.3f) {
            if (!this.level().isClientSide()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)5);
            }
            return false;
        }
        return super.hurt(source, amount * reduction);
    }

    public void awardSkull(LivingEntity entity) {
        if ((entity instanceof Villager || entity instanceof AbstractIllager || entity instanceof Witch) && !this.hasLeftSkull()) {
            this.entityData.set(LEFT_SKULL, (Object)true);
        }
        if ((entity instanceof Zombie || entity instanceof Player) && !this.hasRightSkull()) {
            this.entityData.set(RIGHT_SKULL, (Object)true);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public int getRangedAttackAnimationTick() {
        return this.rangedAnimationTick;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.rangedAnimationTick > 0) {
            --this.rangedAnimationTick;
        }
    }

    public void performRangedAttack(LivingEntity livingEntity, float v) {
        ThrownItemProjectile thrownItemProjectile = new ThrownItemProjectile(this.level(), (LivingEntity)this, (float)((Double)SConfig.SERVER.hindicator_ranged_damage.get() * 1.0), new ItemStack((ItemLike)Items.IRON_AXE));
        thrownItemProjectile.setLivingEntityPredicate(this.TARGET_SELECTOR);
        double d0 = livingEntity.getX() - this.getX();
        double d1 = livingEntity.getY(0.3333333333333333) - thrownItemProjectile.getY();
        double d2 = livingEntity.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        thrownItemProjectile.shoot(d0, d1 + d3 * (double)0.2f, d2, 2.0f, 2.0f);
        this.playSound(SoundEvents.PLAYER_ATTACK_CRIT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)thrownItemProjectile);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.HINDICATOR_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }
}

