/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Inquisitor
extends Hyper {
    public static final EntityDataAccessor<Integer> DAMAGE_BONUS = SynchedEntityData.defineId(Inquisitor.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Inquisitor(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inquisitor_loot.get();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("bonus_damage", this.getBonusDamage());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBonusDamage(tag.getInt("bonus_damage"));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DAMAGE_BONUS, (Object)0);
    }

    public void setBonusDamage(int value) {
        this.entityData.set(DAMAGE_BONUS, (Object)value);
        AttributeInstance damage = this.getAttribute(Attributes.ATTACK_DAMAGE);
        if (damage != null && damage.getValue() < (Double)SConfig.SERVER.inquisitor_damage.get() * 2.0 * (Double)SConfig.SERVER.global_damage.get()) {
            double new_damage = (Double)SConfig.SERVER.inquisitor_damage.get() * (Double)SConfig.SERVER.global_damage.get() + (double)this.getBonusDamage() * 0.5;
            damage.setBaseValue(new_damage);
        }
    }

    public int getBonusDamage() {
        return (Integer)this.entityData.get(DAMAGE_BONUS);
    }

    @Override
    public void awardKillScore(Entity entity, int i, DamageSource damageSource) {
        super.awardKillScore(entity, i, damageSource);
        this.setBonusDamage(this.getBonusDamage() + 1);
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(3, (Goal)new AOEMeleeAttackGoal(this, 1.2, true, 1.2, 3.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.inquisitor_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.inquisitor_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.inquisitor_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        AttributeInstance armor = this.getAttribute(Attributes.ARMOR);
        float baseArmor = (float)((Double)SConfig.SERVER.inquisitor_armor.get() * (Double)SConfig.SERVER.global_armor.get());
        float maxPossibleArmor = baseArmor * 3.0f;
        if (armor != null && this.getHealth() < this.getMaxHealth()) {
            double new_armor = (this.getMaxHealth() - this.getHealth()) / 2.0f + baseArmor;
            armor.setBaseValue(new_armor > (double)maxPossibleArmor ? (double)maxPossibleArmor : new_armor);
        }
        return super.hurt(source, amount);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.INQUISITOR_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }
}

