/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Projectile.ThrownBlockProjectile;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Ogre
extends Hyper
implements RangedAttackMob,
ArmorPersentageBypass {
    public static final EntityDataAccessor<Boolean> HAS_IMPALED_BODY = SynchedEntityData.defineId(Ogre.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int attackAnimationTick;
    private int attacks;

    public Ogre(EntityType<? extends Infected> type, Level level) {
        super(type, level);
    }

    public boolean canDoTailAttack() {
        return this.attacks > 2;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.ogre_loot.get();
    }

    public boolean hasImpaledBody() {
        return (Boolean)this.entityData.get(HAS_IMPALED_BODY);
    }

    public void setHasImpaledBody(boolean value) {
        this.entityData.set(HAS_IMPALED_BODY, (Object)value);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("impaled_body", this.hasImpaledBody());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setHasImpaledBody(tag.getBoolean("impaled_body"));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_IMPALED_BODY, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.ogre_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.ogre_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.ogre_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.MOVEMENT_SPEED, 0.27).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(3, (Goal)new AOEMeleeAttackGoal(this, 1.2, true, 1.2, 7.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return Ogre.this.canDoTailAttack() ? super.getAttackReachSqr(entity) * 1.5 : super.getAttackReachSqr(entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void tick() {
        LivingEntity livingEntity;
        super.tick();
        if (this.tickCount % 40 == 0 && this.isAggressive()) {
            this.performRangedThrow((LivingEntity)this);
        }
        if (this.tickCount % 200 == 0 && (livingEntity = this.getTarget()) != null && this.hasLineOfSight((Entity)livingEntity)) {
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
            for (int i = 0; i < this.random.nextInt(1, 4); ++i) {
                this.performRangedAttack(livingEntity, 0.0f);
            }
        }
    }

    public void handleEntityEvent(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.handleEntityEvent(value);
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        LivingEntity living;
        if (this.canDoTailAttack() && !this.isVehicle() && entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            this.attackAnimationTick = 10;
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
            living.knockback(10.0, (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
            this.attacks = 0;
            living.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 120));
        } else {
            ++this.attacks;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (Math.random() < 0.2) {
                player.startRiding((Entity)this);
            }
        }
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600, 0), (Entity)this);
        }
        return super.doHurtTarget(entity);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    @Override
    public void awardKillScore(Entity entity, int i, DamageSource damageSource) {
        if (this.canDoTailAttack() && !this.hasImpaledBody()) {
            this.setHasImpaledBody(true);
        }
        super.awardKillScore(entity, i, damageSource);
    }

    public void performRangedAttack(LivingEntity livingEntity, float v) {
        this.attackAnimationTick = 10;
        BlockState state = this.getBlock();
        if (!this.level().isClientSide && state != null) {
            ThrownBlockProjectile thrownBlockProjectile = new ThrownBlockProjectile(this.level(), (LivingEntity)this, Float.valueOf(10.0f), state, this.TARGET_SELECTOR);
            double dx = livingEntity.getX() - this.getX();
            double dy = livingEntity.getY() + (double)livingEntity.getEyeHeight() - 1.0;
            double dz = livingEntity.getZ() - this.getZ();
            thrownBlockProjectile.moveTo(this.getX(), this.getY() + 1.5, this.getZ());
            thrownBlockProjectile.shoot(dx, dy - thrownBlockProjectile.getY() + Math.hypot(dx, dz) * (double)0.05f, dz, 1.0f, 6.0f);
            this.level().addFreshEntity((Entity)thrownBlockProjectile);
        }
    }

    public BlockState getBlock() {
        AABB aabb = this.getBoundingBox().inflate(0.2);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (!(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) < 5.0f) || !(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) >= 0.0f) || blockstate.isAir()) continue;
            this.level().destroyBlock(blockpos, false);
            return blockstate;
        }
        return null;
    }

    public void performRangedThrow(LivingEntity entity) {
        LivingEntity livingEntity = this.getTarget();
        if (livingEntity != null) {
            this.attackAnimationTick = 10;
            Vec3 vec3 = entity.getDeltaMovement();
            double d0 = entity.getX() + vec3.x - livingEntity.getX();
            double d1 = entity.getEyeY() - (double)1.1f - this.getY();
            double d2 = entity.getZ() + vec3.z - livingEntity.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            AABB boundingBox = entity.getBoundingBox().inflate(1.2);
            List entities = entity.level().getEntities((Entity)entity, boundingBox);
            for (Entity en : entities) {
                if (!(en instanceof Mob) || !((List)SConfig.SERVER.can_be_carried.get()).contains(en.getEncodeId())) continue;
                en.setDeltaMovement(d0 * -0.2, (d1 + d3) * 0.02, d2 * -0.2);
                ((Mob)en).addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 200, 0));
            }
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    @Override
    public float amountOfDamage(float value) {
        return this.canDoTailAttack() ? value * 0.5f : 0.0f;
    }

    protected void positionRider(Entity entity, Entity.MoveFunction function) {
        super.positionRider(entity, function);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Vec3 vec3 = new Vec3(1.1, 1.4, 0.0).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
            player.setPos(this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
        }
    }

    public boolean isVehicle() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.setPose(Pose.SWIMMING);
        }
        return super.isVehicle();
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.OGRE_AMBIENT.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.INF_VILLAGER_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }
}

