/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedWallMovementControl;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Wendigo
extends Hyper {
    private static final ResourceLocation CRAWLING_SPEED = ResourceLocation.parse((String)"spore:crawling_speed_slowdown");
    private static final ResourceLocation SPRINTING_SPEED = ResourceLocation.parse((String)"spore:sprinting_speed");
    private static final AttributeModifier SPEED_MODIFIER_STALKING = new AttributeModifier(CRAWLING_SPEED, (double)-0.15f, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPRINTING_SPEED, (double)0.15f, AttributeModifier.Operation.ADD_VALUE);
    public static final EntityDataAccessor<Boolean> IS_STALKING = SynchedEntityData.defineId(Wendigo.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> STALKING_TIMEOUT = SynchedEntityData.defineId(Wendigo.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> CAMO = SynchedEntityData.defineId(Wendigo.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> IS_SPRINTING = SynchedEntityData.defineId(Wendigo.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Wendigo(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.moveControl = new InfectedWallMovementControl((Mob)this);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("stalking", this.isStalking());
        tag.putInt("camo", this.getCamo());
        tag.putInt("stalking_timeout", this.getStalkingTimeout());
        tag.putInt("sprinting", this.getIsSprinting());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setIsStalking(tag.getBoolean("stalking"));
        this.setCamo(tag.getInt("camo"));
        this.setStalkingTimeout(tag.getInt("stalking_timeout"));
        this.setIsSprinting(tag.getInt("sprinting"));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_STALKING, (Object)false);
        builder.define(STALKING_TIMEOUT, (Object)0);
        builder.define(CAMO, (Object)0);
        builder.define(IS_SPRINTING, (Object)0);
    }

    public void setIsStalking(boolean value) {
        this.entityData.set(IS_STALKING, (Object)value);
    }

    public boolean isStalking() {
        return (Boolean)this.entityData.get(IS_STALKING);
    }

    public void setCamo(int value) {
        this.entityData.set(CAMO, (Object)value);
    }

    public int getCamo() {
        return (Integer)this.entityData.get(CAMO);
    }

    public void setStalkingTimeout(int value) {
        this.entityData.set(STALKING_TIMEOUT, (Object)value);
    }

    public int getStalkingTimeout() {
        return (Integer)this.entityData.get(STALKING_TIMEOUT);
    }

    public void setIsSprinting(int value) {
        this.entityData.set(IS_SPRINTING, (Object)value);
    }

    public int getIsSprinting() {
        return (Integer)this.entityData.get(IS_SPRINTING);
    }

    public boolean isCrouching() {
        return this.isStalking();
    }

    public double getJumpRange() {
        return 300.0;
    }

    boolean isLookingAtMe(LivingEntity entity) {
        Vec3 vec3 = entity.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(this.getX() - entity.getX(), this.getEyeY() - entity.getEyeY(), this.getZ() - entity.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0 && entity.hasLineOfSight((Entity)this);
    }

    boolean canStartStalking(LivingEntity livingEntity) {
        if (this.getStalkingTimeout() > 0) {
            return false;
        }
        if (livingEntity.distanceToSqr((Entity)this) < this.getJumpRange()) {
            return false;
        }
        if (this.isLookingAtMe(livingEntity)) {
            this.setStalkingTimeout(20);
            return false;
        }
        return true;
    }

    public void setTarget(@Nullable LivingEntity livingEntity) {
        super.setTarget(livingEntity);
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attributeinstance != null) {
            if (livingEntity != null && this.canStartStalking(livingEntity)) {
                if (!attributeinstance.hasModifier(CRAWLING_SPEED)) {
                    attributeinstance.addTransientModifier(SPEED_MODIFIER_STALKING);
                }
            } else {
                attributeinstance.removeModifier(SPEED_MODIFIER_STALKING);
            }
            this.setIsStalking(attributeinstance.hasModifier(CRAWLING_SPEED));
        }
    }

    public List<SoundEvent> LureList() {
        ArrayList<SoundEvent> values = new ArrayList<SoundEvent>();
        values.add(SoundEvents.VILLAGER_AMBIENT);
        values.add(SoundEvents.WANDERING_TRADER_AMBIENT);
        values.add(SoundEvents.ENDERMAN_AMBIENT);
        values.add(SoundEvents.ENDERMAN_SCREAM);
        values.add(SoundEvents.PILLAGER_AMBIENT);
        return values;
    }

    public void playSoundsNearTarget(Entity target) {
        SoundEvent soundEvent = this.LureList().get(this.random.nextInt(this.LureList().size()));
        BlockPos pos = target.getOnPos();
        target.level().playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), soundEvent, target.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.wendigo_loot.get();
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.goalSelector.addGoal(3, (Goal)new AOEMeleeAttackGoal(this, 1.2, true, 1.2, 3.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void aiStep() {
        super.aiStep();
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attributeinstance != null) {
            if (!this.isStalking() && this.getIsSprinting() > 0) {
                if (!attributeinstance.hasModifier(SPRINTING_SPEED)) {
                    attributeinstance.addTransientModifier(SPEED_MODIFIER_ATTACKING);
                }
            } else {
                attributeinstance.removeModifier(SPEED_MODIFIER_ATTACKING);
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.wendigo_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.wendigo_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.wendigo_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.undressTarget(livingEntity);
        }
        return super.doHurtTarget(entity);
    }

    private void undressTarget(LivingEntity livingEntity) {
        this.dropItem(livingEntity, livingEntity.getItemBySlot(EquipmentSlot.HEAD), EquipmentSlot.HEAD);
        this.dropItem(livingEntity, livingEntity.getItemBySlot(EquipmentSlot.CHEST), EquipmentSlot.CHEST);
        this.dropItem(livingEntity, livingEntity.getItemBySlot(EquipmentSlot.LEGS), EquipmentSlot.LEGS);
        this.dropItem(livingEntity, livingEntity.getItemBySlot(EquipmentSlot.FEET), EquipmentSlot.FEET);
    }

    private void dropItem(LivingEntity livingEntity, ItemStack stack, EquipmentSlot slot) {
        if (Math.random() < (double)0.02f && Wendigo.shouldDropItemsPerSlot(slot)) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.addItem(stack);
            } else {
                ItemEntity entity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
                this.level().addFreshEntity((Entity)entity);
                livingEntity.setItemSlot(slot, ItemStack.EMPTY);
            }
        }
    }

    public static boolean shouldDropItemsPerSlot(EquipmentSlot slot) {
        return (Boolean)SConfig.SERVER.wendigo_disarmor.get();
    }

    public void tick() {
        LivingEntity entity;
        super.tick();
        if (this.tickCount % 200 == 0 && this.isStalking() && (entity = this.getTarget()) != null) {
            this.playSoundsNearTarget((Entity)entity);
        }
        if (this.tickCount % 20 == 0) {
            if (this.getStalkingTimeout() > 0) {
                this.setStalkingTimeout(this.getStalkingTimeout() - 1);
            }
            if (this.getIsSprinting() > 0) {
                this.setIsSprinting(this.getIsSprinting() - 1);
            }
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() != null) {
            this.setStalkingTimeout(20);
        }
        return super.hurt(source, amount);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (IS_STALKING.equals(dataAccessor)) {
            if (this.getTarget() != null && this.getIsSprinting() <= 0) {
                this.setIsSprinting(10);
                this.playSound(Ssounds.WENDIGO_SCREECH.get());
            }
            this.setCamo(this.isStalking() ? this.getBiomeTint() : 0);
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    public int getBiomeTint() {
        int i = Mth.floor((double)this.getX());
        int j = Mth.floor((double)this.getY());
        int k = Mth.floor((double)this.getZ());
        BlockPos blockpos = new BlockPos(i, j, k);
        Biome biome = (Biome)this.level().getBiome(blockpos).value();
        return biome.getFoliageColor();
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.WENDIGO_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions dimensions = super.getDefaultDimensions(pose);
        if (this.isStalking()) {
            return dimensions.scale(2.2f, 0.35f);
        }
        return dimensions;
    }
}

