/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;

public class IkLegWithHitbox {
    private final Entity owner;
    private final PartEntity<?>[] entities;
    private final float maxLength;
    private final float minLength;
    private final Vec3 defaultBodyOffset;
    private final Vec3 defaultLimbOffset;
    private final float maxDistance;
    public final float length;
    private final RandomSource randomSource = RandomSource.create();
    private Vec3 sitPosition = null;
    private Vec3 lastSitPosition = null;

    public IkLegWithHitbox(Entity owner, PartEntity<?>[] entities, Vec3 defaultBodyOffset, Vec3 defaultLimbOffset, float maxDistance, float length, float maxLength, float minLength) {
        this.owner = owner;
        this.entities = entities;
        this.defaultBodyOffset = defaultBodyOffset;
        this.defaultLimbOffset = defaultLimbOffset;
        this.maxDistance = maxDistance;
        this.length = length;
        this.maxLength = maxLength;
        this.minLength = minLength;
    }

    public Vec3 getSitPosition() {
        return this.sitPosition;
    }

    public PartEntity<?>[] getEntities() {
        return this.entities;
    }

    public Vec3 getLastSitPosition() {
        return this.lastSitPosition;
    }

    public Vec3 getLegBasePos() {
        float yRotRad = -this.owner.getYRot() * ((float)Math.PI / 180);
        double rotatedX = this.defaultLimbOffset.x * Math.cos(yRotRad) - this.defaultLimbOffset.z * Math.sin(yRotRad);
        double rotatedZ = this.defaultLimbOffset.x * Math.sin(yRotRad) + this.defaultLimbOffset.z * Math.cos(yRotRad);
        return this.owner.position().add(rotatedX, this.defaultLimbOffset.y, rotatedZ);
    }

    public Vec3 getDefaultBodyOffset() {
        float yRotRad = -this.owner.getYRot() * ((float)Math.PI / 180);
        double rotatedX = this.defaultBodyOffset.x * Math.cos(yRotRad) - this.defaultBodyOffset.z * Math.sin(yRotRad);
        double rotatedZ = this.defaultBodyOffset.x * Math.sin(yRotRad) + this.defaultBodyOffset.z * Math.cos(yRotRad);
        return this.owner.position().add(rotatedX, this.defaultBodyOffset.y, rotatedZ);
    }

    private void moveSegmentTowards(int index, Vec3 target, boolean far) {
        Vec3 currentPos = this.entities[index].position();
        Vec3 newPos = currentPos.lerp(target, 0.25);
        this.entities[index].setPos(far ? target : newPos);
    }

    public void applyIK() {
        Vec3 solvedPos;
        Vec3 dir;
        int i;
        boolean tooFar;
        if (this.entities == null || this.entities.length == 0) {
            return;
        }
        Vec3[] oldPositions = new Vec3[this.entities.length];
        for (int j = 0; j < this.entities.length; ++j) {
            oldPositions[j] = this.entities[j].position();
        }
        Vec3 basePos = this.getDefaultBodyOffset();
        Vec3 defaultTipPos = this.getLegBasePos();
        boolean bl = tooFar = this.entities[this.entities.length - 1].distanceToSqr(defaultTipPos) > 100.0;
        if (this.sitPosition != null) {
            this.sitPosition = this.applyLengthConstraints(defaultTipPos, this.sitPosition);
        }
        Vec3 targetPos = this.sitPosition == null || tooFar ? defaultTipPos : this.sitPosition;
        targetPos = this.applyLengthConstraints(defaultTipPos, targetPos);
        this.entities[0].setPos(basePos.x, basePos.y, basePos.z);
        Vec3 tipTarget = targetPos;
        this.moveSegmentTowards(this.entities.length - 1, tipTarget, tooFar);
        for (i = this.entities.length - 2; i >= 0; --i) {
            Vec3 nextPos = this.entities[i + 1].position();
            dir = this.entities[i].position().subtract(nextPos).normalize();
            solvedPos = nextPos.add(dir.scale((double)this.length));
            this.moveSegmentTowards(i, solvedPos, tooFar);
        }
        this.entities[0].setPos(basePos.x, basePos.y, basePos.z);
        for (i = 1; i < this.entities.length; ++i) {
            Vec3 prevPos = this.entities[i - 1].position();
            dir = this.entities[i].position().subtract(prevPos).normalize();
            solvedPos = prevPos.add(dir.scale((double)this.length));
            this.moveSegmentTowards(i, solvedPos, tooFar);
        }
        for (int l = 0; l < this.entities.length; ++l) {
            this.entities[l].xo = oldPositions[l].x;
            this.entities[l].yo = oldPositions[l].y;
            this.entities[l].zo = oldPositions[l].z;
            this.entities[l].xOld = oldPositions[l].x;
            this.entities[l].yOld = oldPositions[l].y;
            this.entities[l].zOld = oldPositions[l].z;
        }
    }

    public void refreshLegStandingPoint() {
        this.sitPosition = this.findStableFooting(this.entities[this.entities.length - 1]);
        if (!this.sitPosition.equals((Object)this.lastSitPosition)) {
            this.lastSitPosition = this.sitPosition;
        }
    }

    private Vec3 applyLengthConstraints(Vec3 basePos, Vec3 targetPos) {
        double distance = basePos.distanceTo(targetPos);
        if (distance > (double)this.maxLength) {
            Vec3 dir = targetPos.subtract(basePos).normalize();
            return basePos.add(dir.scale((double)this.maxLength));
        }
        if (distance < (double)this.minLength && distance > 1.0E-4) {
            Vec3 dir = targetPos.subtract(basePos).normalize();
            return basePos.add(dir.scale((double)this.minLength));
        }
        return targetPos;
    }

    private Vec3 findStableFooting(PartEntity<?> tip) {
        Level level = this.owner.level();
        Vec3 legBasePos = this.getLegBasePos();
        if (level.isClientSide) {
            return legBasePos;
        }
        if (this.lastSitPosition != null && legBasePos.distanceTo(this.lastSitPosition) < (double)this.maxDistance) {
            return this.lastSitPosition;
        }
        double randX = (this.randomSource.nextDouble() - 0.5) * 2.0;
        double randZ = (this.randomSource.nextDouble() - 0.5) * 2.0;
        Vec3 randomizedBase = legBasePos.add(randX, 0.0, randZ);
        double entityWidth = this.owner.getBbWidth();
        double minDistance = entityWidth * 1.2;
        Vec3 horizontalVec = new Vec3(randomizedBase.x - legBasePos.x, 0.0, randomizedBase.z - legBasePos.z);
        double horizontalDist = horizontalVec.length();
        if (horizontalDist < minDistance && horizontalDist > 1.0E-4) {
            Vec3 direction = horizontalVec.normalize();
            randomizedBase = legBasePos.add(direction.scale(minDistance));
        }
        BlockPos searchStart = new BlockPos((int)Math.floor(randomizedBase.x), (int)Math.floor(tip.position().y + 2.0), (int)Math.floor(randomizedBase.z));
        for (int y = 0; y < 4; ++y) {
            BlockPos checkPos = searchStart.below(y);
            if (!this.owner.level().getBlockState(checkPos).isSolidRender((BlockGetter)this.owner.level(), checkPos)) continue;
            return new Vec3((double)checkPos.getX() + 0.5, (double)checkPos.getY() - 0.5, (double)checkPos.getZ() + 0.5);
        }
        return this.lastSitPosition == null ? legBasePos : randomizedBase;
    }
}

