/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.MovementControls;

import com.Harbinger.Spore.Sentities.Calamities.Hohlfresser;
import com.Harbinger.Spore.Sentities.MovementControls.CalamityMovementControl;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UndergroundMovementControl
extends CalamityMovementControl {
    public UndergroundMovementControl(Mob mob) {
        super(mob, 30);
    }

    @Override
    public void tick() {
        this.moveUnderground();
        this.mob.setNoGravity(this.isInWall((LivingEntity)this.mob));
    }

    boolean isInWall(LivingEntity mob) {
        if (mob.isInWater() || mob.isInLava()) {
            return true;
        }
        float f = mob.getBbWidth() * 0.8f;
        AABB aabb = AABB.ofSize((Vec3)mob.getEyePosition().add(0.0, -0.05, 0.0), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.betweenClosedStream((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = mob.level().getBlockState(p_201942_);
            return !blockstate.isAir() && blockstate.isSuffocating((BlockGetter)mob.level(), p_201942_) && Shapes.joinIsNotEmpty((VoxelShape)blockstate.getCollisionShape((BlockGetter)mob.level(), p_201942_).move((double)p_201942_.getX(), (double)p_201942_.getY(), (double)p_201942_.getZ()), (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.AND);
        });
    }

    public void moveUnderground() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            Hohlfresser hohlfresser;
            Vec3 vec3 = new Vec3(this.wantedX - this.mob.getX(), this.wantedY - this.mob.getY(), this.wantedZ - this.mob.getZ());
            vec3 = vec3.normalize();
            vec3 = vec3.multiply(1.0, this.isInWall((LivingEntity)this.mob) ? 1.0 : 0.0, 1.0);
            Mob mob = this.mob;
            double speed = mob instanceof Hohlfresser && (hohlfresser = (Hohlfresser)mob).isUnderground() ? 0.05 : 0.15;
            double speedRep = this.mob.isInWater() ? speed * 0.5 : speed;
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(vec3.scale(speedRep)));
            float yaw = (float)(Mth.atan2((double)vec3.z, (double)vec3.x) * 57.29577951308232) - 90.0f;
            this.mob.setYRot(yaw);
            this.mob.setYHeadRot(yaw);
            if (this.mob.horizontalCollision && this.getWantedY() > this.mob.getY()) {
                Vec3 initialVec = this.mob.getDeltaMovement();
                Vec3 climbVec = new Vec3(initialVec.x, 0.2, initialVec.z);
                this.mob.setDeltaMovement(climbVec.x * 0.91, climbVec.y * 0.98, climbVec.z * 0.91);
            }
        } else {
            this.operation = MoveControl.Operation.WAIT;
        }
        if (this.operation == MoveControl.Operation.WAIT && !this.hasWanted() && this.mob.getTarget() == null) {
            this.mob.setDeltaMovement(Vec3.ZERO);
            this.mob.setYRot(0.0f);
            this.mob.setYHeadRot(0.0f);
        }
    }
}

