/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.MovementControls;

import com.Harbinger.Spore.Sentities.Calamities.Hohlfresser;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class UndergroundPathNavigation
extends GroundPathNavigation {
    @Nullable
    private BlockPos pathToPosition;

    public UndergroundPathNavigation(PathfinderMob mob, Level level) {
        super((Mob)mob, level);
    }

    @NotNull
    protected PathFinder createPathFinder(int maxNodes) {
        HohlfresserNodeEvaluator evaluator = new HohlfresserNodeEvaluator();
        evaluator.setCanPassDoors(true);
        evaluator.canFloat();
        return new PathFinder((NodeEvaluator)evaluator, maxNodes);
    }

    public Path createPath(BlockPos pos, int value) {
        this.pathToPosition = pos;
        return super.createPath(pos, value);
    }

    public Path createPath(Entity entity, int value) {
        this.pathToPosition = entity.blockPosition();
        return super.createPath(entity, value);
    }

    public boolean moveTo(Entity entity, double value) {
        Path path = this.createPath(entity, 0);
        if (path != null) {
            return this.moveTo(path, value);
        }
        this.pathToPosition = entity.blockPosition();
        this.speedModifier = value;
        return true;
    }

    @NotNull
    protected Vec3 getTempMobPos() {
        return this.mob.position().add(0.0, (double)this.mob.getBbHeight() * 0.5, 0.0);
    }

    protected boolean canUpdatePath() {
        return this.mob.getTarget() != null && this.mob.getNavigation().isInProgress();
    }

    public boolean isStableDestination(BlockPos pos) {
        Hohlfresser hohlfresser;
        Mob mob = this.mob;
        if (mob instanceof Hohlfresser && (hohlfresser = (Hohlfresser)mob).canGoUnderground()) {
            return hohlfresser.isColliding(pos, this.level.getBlockState(pos));
        }
        return super.isStableDestination(pos);
    }

    public void tick() {
        if (!this.isDone()) {
            super.tick();
        } else if (this.pathToPosition != null) {
            if (!(this.pathToPosition.closerToCenterThan((Position)this.mob.position(), Math.max((double)this.mob.getBbWidth(), 1.0)) || this.mob.getY() > (double)this.pathToPosition.getY() && new BlockPos(this.pathToPosition.getX(), (int)this.mob.getY(), this.pathToPosition.getZ()).closerToCenterThan((Position)this.mob.position(), Math.max((double)this.mob.getBbWidth(), 1.0)))) {
                this.mob.getMoveControl().setWantedPosition((double)this.pathToPosition.getX(), (double)this.pathToPosition.getY(), (double)this.pathToPosition.getZ(), this.speedModifier);
            } else {
                this.pathToPosition = null;
            }
        }
    }

    public static class HohlfresserNodeEvaluator
    extends SwimNodeEvaluator {
        public HohlfresserNodeEvaluator() {
            super(true);
        }

        protected PathType getCachedBlockType(int x, int y, int z) {
            return PathType.OPEN;
        }

        public PathType getPathType(Mob mob, BlockPos pos) {
            return this.getCachedBlockType(pos.getX(), pos.getY(), pos.getZ());
        }
    }
}

