/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.BraureiVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Spotion;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Brauerei
extends Organoid
implements RangedAttackMob,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(Brauerei.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.defineId(Brauerei.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(Brauerei.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.defineId(Brauerei.class, (EntityDataSerializer)EntityDataSerializers.PARTICLE);
    @Nullable
    private Holder<MobEffect> effect;

    public Brauerei(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public int getEmerge_tick() {
        return 200;
    }

    @Override
    public int getBorrow_tick() {
        return 200;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("timer", ((Integer)this.entityData.get(TIMER)).intValue());
        tag.putInt("color", ((Integer)this.entityData.get(COLOR)).intValue());
        tag.putInt("Variant", this.getTypeVariant());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(TIMER, (Object)tag.getInt("timer"));
        this.entityData.set(COLOR, (Object)tag.getInt("color"));
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TIMER, (Object)0);
        builder.define(COLOR, (Object)0);
        builder.define(DATA_PARTICLE, (Object)ParticleTypes.WITCH);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public Holder<MobEffect> getEffect() {
        return this.effect;
    }

    public void setEffect(Holder<MobEffect> effect) {
        this.entityData.set(COLOR, (Object)((MobEffect)effect.value()).getColor());
        this.effect = effect;
    }

    public int getTimer() {
        return (Integer)this.entityData.get(TIMER);
    }

    @Override
    public void tick() {
        ParticleOptions particleoptions;
        super.tick();
        if (!this.level().isClientSide && this.tickCount % 20 == 0) {
            if (this.getTarget() == null && (Integer)this.entityData.get(TIMER) < 300) {
                this.entityData.set(TIMER, (Object)((Integer)this.entityData.get(TIMER) + 1));
            } else if ((Integer)this.entityData.get(TIMER) >= 300) {
                this.tickBurrowing();
            }
        }
        if (this.tickCount % 300 == 0) {
            if (this.getVariant() == BraureiVariants.HAZARD) {
                this.setEffect(this.debuff_List().get(this.random.nextInt(this.debuff_List().size())));
            } else {
                this.setEffect(this.testList().get(this.random.nextInt(this.testList().size())));
            }
            if (this.getEffect() != null) {
                if (this.getVariant() == BraureiVariants.HAZARD) {
                    this.spreadDeBuffs((LivingEntity)this, this.getEffect());
                } else {
                    this.spreadBuffs((LivingEntity)this, this.getEffect());
                }
            }
        }
        if ((Integer)this.entityData.get(COLOR) != 0 && (particleoptions = (ParticleOptions)this.entityData.get(DATA_PARTICLE)).getType() == ParticleTypes.ENTITY_EFFECT) {
            int k = this.getColor();
            double d5 = (float)(k >> 16 & 0xFF) / 255.0f;
            double d6 = (float)(k >> 8 & 0xFF) / 255.0f;
            double d7 = (float)(k & 0xFF) / 255.0f;
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), d5, d6, d7);
            }
        }
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.entityData.get(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            this.discard();
            burrowing = -1;
        }
        this.entityData.set(BORROW, (Object)(burrowing + 1));
    }

    private List<Holder<MobEffect>> testList() {
        ArrayList<Holder<MobEffect>> contents = new ArrayList<Holder<MobEffect>>();
        for (String str : (List)SConfig.SERVER.braurei_buffs.get()) {
            Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)str));
            if (effect == null) continue;
            contents.add(effect);
        }
        if (contents.isEmpty()) {
            contents.add((Holder<MobEffect>)MobEffects.REGENERATION);
        }
        return contents;
    }

    private List<Holder<MobEffect>> debuff_List() {
        ArrayList<Holder<MobEffect>> contents = new ArrayList<Holder<MobEffect>>();
        for (String str : (List)SConfig.SERVER.braurei_debuffs.get()) {
            Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)str));
            if (effect == null) continue;
            contents.add(effect);
        }
        if (contents.isEmpty()) {
            contents.add(Seffects.MYCELIUM);
        }
        return contents;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.braurei_loot.get();
    }

    protected void spreadBuffs(LivingEntity entity, Holder<MobEffect> effect) {
        this.awardHivemind();
        AABB aabb = entity.getBoundingBox().inflate(32.0);
        List entities = entity.level().getEntities((Entity)entity, aabb, living -> living instanceof Infected || living instanceof UtilityEntity);
        for (Entity testEntity : entities) {
            if (!(testEntity instanceof LivingEntity)) continue;
            LivingEntity living2 = (LivingEntity)testEntity;
            int level = entity.level().getDifficulty() == Difficulty.HARD ? 1 : 0;
            living2.addEffect(new MobEffectInstance(effect, 600, level));
        }
    }

    protected void spreadDeBuffs(LivingEntity entity, Holder<MobEffect> effect) {
        this.awardHivemind();
        AABB aabb = entity.getBoundingBox().inflate(32.0);
        List entities = entity.level().getEntities((Entity)entity, aabb, living -> {
            LivingEntity livingEntity;
            return living instanceof LivingEntity && this.TARGET_SELECTOR.test(livingEntity = (LivingEntity)living) && !Utilities.helmetList().contains(livingEntity.getItemBySlot(EquipmentSlot.HEAD).getItem());
        });
        for (Entity testEntity : entities) {
            if (!(testEntity instanceof LivingEntity)) continue;
            LivingEntity living2 = (LivingEntity)testEntity;
            int level = entity.level().getDifficulty() == Difficulty.HARD ? 1 : 0;
            living2.addEffect(new MobEffectInstance(effect, 600, level));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.braurei_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.braurei_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    protected void registerGoals() {
        this.addTargettingGoals();
        this.goalSelector.addGoal(3, (Goal)new ScatterShotRangedGoal(this, 0.0, 80, 20.0f, 1, 3));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    private List<Holder<Potion>> getPotion() {
        ArrayList<Holder<Potion>> values = new ArrayList<Holder<Potion>>();
        values.add(Spotion.MARKER_POTION);
        values.add(Spotion.MYCELIUM_POTION);
        values.add(Spotion.CORROSION_POTION_STRONG);
        values.add(Potions.WEAKNESS);
        values.add(Potions.STRONG_POISON);
        return values;
    }

    @Override
    public boolean hurt(DamageSource source, float value) {
        if (this.isEmerging()) {
            return false;
        }
        return super.hurt(source, value);
    }

    public void performRangedAttack(LivingEntity entity, float p_33318_) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = entity.getX() + vec3.x - this.getX();
        double d1 = entity.getEyeY() - (double)1.1f - this.getY();
        double d2 = entity.getZ() + vec3.z - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        ThrownPotion thrownpotion = new ThrownPotion(this.level(), (LivingEntity)this);
        thrownpotion.setItem(PotionContents.createItemStack((Item)Items.SPLASH_POTION, this.getPotion().get(this.random.nextInt(this.getPotion().size()))));
        thrownpotion.setXRot(thrownpotion.getXRot() - -20.0f);
        thrownpotion.shoot(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
        if (!this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        }
        this.level().addFreshEntity((Entity)thrownpotion);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.BRAUREI_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    public BraureiVariants getVariant() {
        return BraureiVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(i > BraureiVariants.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return BraureiVariants.values().length;
    }

    private void setVariant(BraureiVariants variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        BraureiVariants variant = (BraureiVariants)((Object)Util.getRandom((Object[])BraureiVariants.values(), (RandomSource)this.random));
        this.setVariant(variant);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }
}

