/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.Utility.Illusion;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class Delusionare
extends Organoid {
    private static final EntityDataAccessor<Integer> SPELL_TIME = SynchedEntityData.defineId(Delusionare.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SPELL_ID = SynchedEntityData.defineId(Delusionare.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Delusionare(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public int getEmerge_tick() {
        return 100;
    }

    @Override
    public int getBorrow_tick() {
        return 100;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("spell_timer", ((Integer)this.entityData.get(SPELL_TIME)).intValue());
        tag.putInt("spell_id", ((Integer)this.entityData.get(SPELL_ID)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(SPELL_TIME, (Object)tag.getInt("spell_timer"));
        this.entityData.set(SPELL_ID, (Object)tag.getInt("spell_id"));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPELL_TIME, (Object)0);
        builder.define(SPELL_ID, (Object)0);
    }

    public int getSpellById() {
        return (Integer)this.entityData.get(SPELL_ID);
    }

    public boolean isCasting() {
        return (Integer)this.entityData.get(SPELL_TIME) > 0;
    }

    public void setSpellTime(int value) {
        this.entityData.set(SPELL_TIME, (Object)value);
    }

    public void setSpellId(int value) {
        this.entityData.set(SPELL_ID, (Object)value);
    }

    protected void tickSpell() {
        this.entityData.set(SPELL_TIME, (Object)((Integer)this.entityData.get(SPELL_TIME) + 1));
        if ((Integer)this.entityData.get(SPELL_TIME) == 40) {
            this.playSound(Ssounds.DELUSIONER_CASTING.get());
        }
        if ((Integer)this.entityData.get(SPELL_TIME) > 80) {
            this.castSpell(this.getSpellById());
            this.entityData.set(SPELL_TIME, (Object)0);
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.delusioner_loot.get();
    }

    @Override
    public void tick() {
        super.tick();
        if ((Integer)this.entityData.get(SPELL_TIME) > 0) {
            this.tickSpell();
        }
        if (this.tickCount % 1200 == 0 && this.getTarget() == null) {
            this.tickBurrowing();
        }
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.entityData.get(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            this.discard();
            burrowing = -1;
        }
        this.entityData.set(BORROW, (Object)(burrowing + 1));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.delusioner_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.delusioner_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.addTargettingGoals();
        this.goalSelector.addGoal(4, (Goal)new CastMagicGoal(this));
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.DELUSIONER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    public void castSpell(int value) {
        int i;
        LivingEntity entity = this.getTarget();
        if (entity == null) {
            return;
        }
        if (value == Spells.SUMMON_ILLUSION.getId()) {
            for (i = 0; i < this.random.nextInt(2, 5); ++i) {
                Illusion illusion = new Illusion(Sentities.ILLUSION.get(), this.level());
                illusion.setSeeAble(true);
                illusion.moveTo(this.getX(), this.getY(), this.getZ());
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    illusion.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.getOnPos()), MobSpawnType.MOB_SUMMONED, null);
                }
                illusion.setTarget(entity);
                this.level().addFreshEntity((Entity)illusion);
            }
        }
        if (value == Spells.CAST_ARROWS.getId() && this.hasLineOfSight((Entity)entity)) {
            for (i = 0; i < this.random.nextInt(3, 7); ++i) {
                int randomX = this.random.nextInt(-4, 4);
                int randomZ = this.random.nextInt(-4, 4);
                Arrow arrow = new Arrow(EntityType.ARROW, this.level());
                arrow.moveTo(entity.getX() + (double)randomX, entity.getY() + 3.0, entity.getZ() + (double)randomZ);
                arrow.setOwner((Entity)this);
                if (Math.random() < 0.3) {
                    arrow.setRemainingFireTicks(80);
                }
                double d0 = entity.getX() - arrow.getX();
                double d1 = entity.getY(0.3333333333333333) - arrow.getY();
                double d2 = entity.getZ() - arrow.getZ();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                arrow.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600));
                arrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
                this.level().addFreshEntity((Entity)arrow);
            }
        }
        if (value == Spells.CAST_INVISIBILITY.getId()) {
            AABB aabb = this.getBoundingBox().inflate(32.0);
            List entities = this.level().getEntities((Entity)this, aabb);
            for (Entity entity1 : entities) {
                if (!(entity1 instanceof Infected)) continue;
                Infected infected = (Infected)entity1;
                infected.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 600));
            }
        }
        if (value == Spells.CAST_TELEPORTATION.getId()) {
            AABB aabb = this.getBoundingBox().inflate(32.0);
            List entities = this.level().getEntities((Entity)this, aabb);
            for (Entity entity1 : entities) {
                double randomX = entity.getX() + (double)this.random.nextInt(-4, 4);
                double randomZ = entity.getZ() + (double)this.random.nextInt(-4, 4);
                if (!(entity1 instanceof Infected)) continue;
                Infected infected = (Infected)entity1;
                infected.randomTeleport(randomX, entity.getY(), randomZ, true);
                infected.playSound(SoundEvents.ENDERMAN_TELEPORT);
            }
        }
        this.awardHivemind();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide && this.isCasting()) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    @Override
    public boolean hurt(DamageSource p_21016_, float p_21017_) {
        if (this.isEmerging()) {
            return false;
        }
        return super.hurt(p_21016_, p_21017_);
    }

    public static class CastMagicGoal
    extends Goal {
        Delusionare delusionare;

        public CastMagicGoal(Delusionare delusionare) {
            this.delusionare = delusionare;
        }

        public boolean canUse() {
            if (this.delusionare.isCasting()) {
                return false;
            }
            return this.delusionare.getTarget() != null;
        }

        private boolean hasAlliesAround() {
            AABB aabb = this.delusionare.getBoundingBox().inflate(8.0);
            List possible_allies = this.delusionare.level().getEntities((Entity)this.delusionare, aabb);
            ArrayList<Infected> allies = new ArrayList<Infected>();
            for (Entity entity : possible_allies) {
                if (!(entity instanceof Infected)) continue;
                Infected infected = (Infected)entity;
                allies.add(infected);
            }
            return allies.size() > 2;
        }

        private boolean isFar() {
            LivingEntity entity = this.delusionare.getTarget();
            if (entity == null) {
                return false;
            }
            return this.delusionare.distanceToSqr((Entity)entity) > 140.0;
        }

        public void start() {
            super.start();
            if (this.hasAlliesAround() && this.isFar()) {
                this.delusionare.setSpellId(3);
            }
            if (this.hasAlliesAround() && !this.isFar()) {
                this.delusionare.setSpellId(2);
            }
            if (!this.hasAlliesAround() && this.isFar()) {
                this.delusionare.setSpellId(1);
            }
            if (!this.hasAlliesAround() && !this.isFar()) {
                this.delusionare.setSpellId(0);
            }
            this.delusionare.setSpellTime(1);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    public static enum Spells {
        SUMMON_ILLUSION(0),
        CAST_ARROWS(1),
        CAST_INVISIBILITY(2),
        CAST_TELEPORTATION(3);

        private final int id;

        private Spells(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

